/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.nio;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.util.LogSupport;

public class SocketChannelOutputStream
extends OutputStream {
    private static Log log = LogFactory.getLog((Class)(class$org$mortbay$http$nio$SocketChannelOutputStream == null ? (class$org$mortbay$http$nio$SocketChannelOutputStream = SocketChannelOutputStream.class$("org.mortbay.http.nio.SocketChannelOutputStream")) : class$org$mortbay$http$nio$SocketChannelOutputStream));
    ByteBuffer _buffer;
    ByteBuffer _flush;
    SocketChannel _channel;
    Selector _selector;
    static /* synthetic */ Class class$org$mortbay$http$nio$SocketChannelOutputStream;

    public SocketChannelOutputStream(SocketChannel channel, int bufferSize) {
        this._channel = channel;
        this._buffer = ByteBuffer.allocateDirect(bufferSize);
    }

    public void write(int b) throws IOException {
        this._buffer.clear();
        this._buffer.put((byte)b);
        this._buffer.flip();
        this._flush = this._buffer;
        this.flushBuffer();
    }

    public void close() throws IOException {
        this._channel.close();
    }

    public void flush() throws IOException {
    }

    public void write(byte[] buf, int offset, int length) throws IOException {
        if (length > this._buffer.capacity()) {
            this._flush = ByteBuffer.wrap(buf, offset, length);
        } else {
            this._buffer.clear();
            this._buffer.put(buf, offset, length);
            this._buffer.flip();
            this._flush = this._buffer;
        }
        this.flushBuffer();
    }

    public void write(byte[] buf) throws IOException {
        if (buf.length > this._buffer.capacity()) {
            this._flush = ByteBuffer.wrap(buf);
        } else {
            this._buffer.clear();
            this._buffer.put(buf);
            this._buffer.flip();
            this._flush = this._buffer;
        }
        this.flushBuffer();
    }

    private void flushBuffer() throws IOException {
        while (this._flush.hasRemaining()) {
            int len = this._channel.write(this._flush);
            if (len < 0) {
                throw new IOException("EOF");
            }
            if (len != 0) continue;
            Thread.yield();
            len = this._channel.write(this._flush);
            if (len < 0) {
                throw new IOException("EOF");
            }
            if (len != 0) continue;
            if (this._selector == null) {
                this._selector = Selector.open();
                this._channel.register(this._selector, 4);
            }
            this._selector.select();
        }
    }

    public void destroy() {
        if (this._selector != null) {
            try {
                this._selector.close();
            }
            catch (IOException e) {
                LogSupport.ignore(log, e);
            }
            this._selector = null;
            this._buffer = null;
            this._flush = null;
            this._channel = null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

