/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.convert;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import uk.ltd.getahead.dwr.ConversionException;
import uk.ltd.getahead.dwr.Converter;
import uk.ltd.getahead.dwr.ConverterManager;
import uk.ltd.getahead.dwr.InboundContext;
import uk.ltd.getahead.dwr.InboundVariable;
import uk.ltd.getahead.dwr.Messages;
import uk.ltd.getahead.dwr.OutboundContext;
import uk.ltd.getahead.dwr.compat.BaseV10Converter;

public class DateConverter
extends BaseV10Converter
implements Converter {
    public void setConverterManager(ConverterManager config) {
    }

    public Object convertInbound(Class paramType, InboundVariable iv, InboundContext inctx) throws ConversionException {
        String value = iv.getValue();
        if (value.trim().equals("null")) {
            return null;
        }
        try {
            long millis = 0L;
            if (value.length() > 0) {
                millis = Long.parseLong(value);
            }
            Date date = new Date(millis);
            if (paramType == Date.class) {
                return date;
            }
            if (paramType == java.sql.Date.class) {
                return new java.sql.Date(date.getTime());
            }
            if (paramType == Time.class) {
                return new Time(date.getTime());
            }
            if (paramType == Timestamp.class) {
                return new Timestamp(date.getTime());
            }
            throw new ConversionException(Messages.getString("DateConverter.WrongType") + paramType.getName());
        }
        catch (ConversionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConversionException(Messages.getString("DateConverter.ErrorConverting", value, paramType.getName()), ex);
        }
    }

    public String convertOutbound(Object data, String varname, OutboundContext outctx) throws ConversionException {
        if (!(data instanceof Date)) {
            throw new ConversionException(Messages.getString("DateConverter.TypeError", data.getClass()));
        }
        Date date = (Date)data;
        long millis = date.getTime();
        StringBuffer buffer = new StringBuffer();
        buffer.append("var " + varname + "=new Date(");
        buffer.append(millis);
        buffer.append(");");
        return buffer.toString();
    }
}

