/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.flapcmd;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flap.FlapCommand;
import net.kano.joscar.flap.FlapPacket;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class LoginFlapCmd
extends FlapCommand {
    public static final int CHANNEL_LOGIN = 1;
    public static final long VERSION_DEFAULT = 1L;
    private static final int TYPE_COOKIE = 6;
    private final long version;
    private final ByteBlock cookie;

    public LoginFlapCmd(FlapPacket flapPacket) {
        super(1);
        DefensiveTools.checkNull(flapPacket, "packet");
        ByteBlock byteBlock = flapPacket.getData();
        this.version = BinaryTools.getUInt(byteBlock, 0);
        ByteBlock byteBlock2 = byteBlock.subBlock(4);
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock2);
        Tlv tlv = immutableTlvChain.getLastTlv(6);
        this.cookie = tlv != null ? tlv.getData() : null;
    }

    public LoginFlapCmd() {
        this(1L, null);
    }

    public LoginFlapCmd(long l) {
        this(l, null);
    }

    public LoginFlapCmd(ByteBlock byteBlock) {
        this(1L, byteBlock);
    }

    public LoginFlapCmd(long l, ByteBlock byteBlock) {
        super(1);
        DefensiveTools.checkRange(l, "version", 0);
        this.version = l;
        this.cookie = byteBlock;
    }

    public final long getVersion() {
        return this.version;
    }

    public final ByteBlock getCookie() {
        return this.cookie;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        BinaryTools.writeUInt(outputStream, this.version);
        if (this.cookie != null) {
            new Tlv(6, this.cookie).write(outputStream);
        }
    }
}

