/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.ProcessDestroyer;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.Commandline;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Execute {
    public static final int INVALID = Integer.MAX_VALUE;
    private static String antWorkingDirectory = System.getProperty("user.dir");
    private static CommandLauncher vmLauncher = null;
    private static CommandLauncher shellLauncher = null;
    private static Vector procEnvironment = null;
    private static ProcessDestroyer processDestroyer = new ProcessDestroyer();
    private String[] cmdl;
    private String[] env;
    private int exitValue;
    private ExecuteStreamHandler streamHandler;
    private ExecuteWatchdog watchdog;
    private File workingDirectory;
    private Project project;
    private boolean newEnvironment;
    private boolean useVMLauncher;
    private boolean spawn;

    public void setSpawn(boolean bl) {
        this.spawn = bl;
    }

    public static synchronized Vector getProcEnvironment() {
        if (procEnvironment != null) {
            return procEnvironment;
        }
        procEnvironment = new Vector();
        try {
            String string;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Execute execute = new Execute(new PumpStreamHandler(byteArrayOutputStream));
            execute.setCommandline(Execute.getProcEnvCommand());
            execute.setNewenvironment(true);
            int n = execute.execute();
            BufferedReader bufferedReader = new BufferedReader(new StringReader(Execute.toString(byteArrayOutputStream)));
            if (Os.isFamily("openvms")) {
                procEnvironment = Execute.addVMSLogicals(procEnvironment, bufferedReader);
                return procEnvironment;
            }
            String string2 = null;
            String string3 = System.getProperty("line.separator");
            while ((string = bufferedReader.readLine()) != null) {
                if (string.indexOf(61) == -1) {
                    if (string2 == null) {
                        string2 = string3 + string;
                        continue;
                    }
                    string2 = string2 + string3 + string;
                    continue;
                }
                if (string2 != null) {
                    procEnvironment.addElement(string2);
                }
                string2 = string;
            }
            if (string2 != null) {
                procEnvironment.addElement(string2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return procEnvironment;
    }

    private static final String[] getProcEnvCommand() {
        if (Os.isFamily("os/2")) {
            return new String[]{"cmd", "/c", "set"};
        }
        if (Os.isFamily("windows")) {
            if (Os.isFamily("win9x")) {
                return new String[]{"command.com", "/c", "set"};
            }
            return new String[]{"cmd", "/c", "set"};
        }
        if (Os.isFamily("z/os") || Os.isFamily("unix")) {
            String[] stringArray = new String[]{new File("/bin/env").canRead() ? "/bin/env" : (new File("/usr/bin/env").canRead() ? "/usr/bin/env" : "env")};
            return stringArray;
        }
        if (Os.isFamily("netware") || Os.isFamily("os/400")) {
            return new String[]{"env"};
        }
        if (Os.isFamily("openvms")) {
            return new String[]{"show", "logical"};
        }
        return null;
    }

    public static String toString(ByteArrayOutputStream byteArrayOutputStream) {
        if (Os.isFamily("z/os")) {
            try {
                return byteArrayOutputStream.toString("Cp1047");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
        } else if (Os.isFamily("os/400")) {
            try {
                return byteArrayOutputStream.toString("Cp500");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return byteArrayOutputStream.toString();
    }

    public void setStreamHandler(ExecuteStreamHandler executeStreamHandler) {
        this.streamHandler = executeStreamHandler;
    }

    public String[] getCommandline() {
        return this.cmdl;
    }

    public void setCommandline(String[] stringArray) {
        this.cmdl = stringArray;
    }

    public void setNewenvironment(boolean bl) {
        this.newEnvironment = bl;
    }

    public String[] getEnvironment() {
        if (this.env == null || this.newEnvironment) {
            return this.env;
        }
        return this.patchEnvironment();
    }

    public void setEnvironment(String[] stringArray) {
        this.env = stringArray;
    }

    public void setWorkingDirectory(File file) {
        this.workingDirectory = file == null || file.getAbsolutePath().equals(antWorkingDirectory) ? null : file;
    }

    public void setAntRun(Project project) throws BuildException {
        this.project = project;
    }

    public void setVMLauncher(boolean bl) {
        this.useVMLauncher = bl;
    }

    public static Process launch(Project project, String[] stringArray, String[] stringArray2, File file, boolean bl) throws IOException {
        CommandLauncher commandLauncher;
        CommandLauncher commandLauncher2 = commandLauncher = vmLauncher != null ? vmLauncher : shellLauncher;
        if (!bl) {
            commandLauncher = shellLauncher;
        }
        if (file != null && !file.exists()) {
            throw new BuildException(file + " doesn't exist.");
        }
        return commandLauncher.exec(project, stringArray, stringArray2, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws IOException {
        int n;
        if (this.workingDirectory != null && !this.workingDirectory.exists()) {
            throw new BuildException(this.workingDirectory + " doesn't exist.");
        }
        Process process = Execute.launch(this.project, this.getCommandline(), this.getEnvironment(), this.workingDirectory, this.useVMLauncher);
        try {
            this.streamHandler.setProcessInputStream(process.getOutputStream());
            this.streamHandler.setProcessOutputStream(process.getInputStream());
            this.streamHandler.setProcessErrorStream(process.getErrorStream());
        }
        catch (IOException iOException) {
            process.destroy();
            throw iOException;
        }
        this.streamHandler.start();
        try {
            processDestroyer.add(process);
            if (this.watchdog != null) {
                this.watchdog.start(process);
            }
            this.waitFor(process);
            if (this.watchdog != null) {
                this.watchdog.stop();
            }
            this.streamHandler.stop();
            Execute.closeStreams(process);
            if (this.watchdog != null) {
                this.watchdog.checkException();
            }
            n = this.getExitValue();
            Object var3_5 = null;
            processDestroyer.remove(process);
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            processDestroyer.remove(process);
            throw throwable;
        }
        return n;
    }

    public void spawn() throws IOException {
        if (this.workingDirectory != null && !this.workingDirectory.exists()) {
            throw new BuildException(this.workingDirectory + " doesn't exist.");
        }
        Process process = Execute.launch(this.project, this.getCommandline(), this.getEnvironment(), this.workingDirectory, this.useVMLauncher);
        if (Os.isFamily("windows")) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                this.project.log("interruption in the sleep after having spawned a process", 3);
            }
        }
        OutputStream outputStream = new OutputStream(){

            public final void write(int n) throws IOException {
            }
        };
        PumpStreamHandler pumpStreamHandler = new PumpStreamHandler(outputStream);
        pumpStreamHandler.setProcessErrorStream(process.getErrorStream());
        pumpStreamHandler.setProcessOutputStream(process.getInputStream());
        pumpStreamHandler.start();
        process.getOutputStream().close();
        this.project.log("spawned process " + process.toString(), 3);
    }

    protected void waitFor(Process process) {
        try {
            process.waitFor();
            this.setExitValue(process.exitValue());
        }
        catch (InterruptedException interruptedException) {
            process.destroy();
        }
    }

    protected void setExitValue(int n) {
        this.exitValue = n;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public static boolean isFailure(int n) {
        if (Os.isFamily("openvms")) {
            boolean bl = false;
            if (n % 2 == 0) {
                bl = true;
            }
            return bl;
        }
        boolean bl = false;
        if (n != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean killedProcess() {
        boolean bl = false;
        if (this.watchdog != null && this.watchdog.killedProcess()) {
            bl = true;
        }
        return bl;
    }

    private final String[] patchEnvironment() {
        if (Os.isFamily("openvms")) {
            return this.env;
        }
        Vector vector = (Vector)Execute.getProcEnvironment().clone();
        int n = 0;
        while (n < this.env.length) {
            int n2 = this.env[n].indexOf(61);
            String string = this.env[n].substring(0, n2 + 1);
            int n3 = vector.size();
            int n4 = 0;
            while (n4 < n3) {
                if (((String)vector.elementAt(n4)).startsWith(string)) {
                    vector.removeElementAt(n4);
                    break;
                }
                ++n4;
            }
            vector.addElement(this.env[n]);
            ++n;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static void runCommand(Task task, String[] stringArray) throws BuildException {
        try {
            task.log(Commandline.describeCommand(stringArray), 3);
            Execute execute = new Execute(new LogStreamHandler(task, 2, 0));
            execute.setAntRun(task.getProject());
            execute.setCommandline(stringArray);
            int n = execute.execute();
            if (Execute.isFailure(n)) {
                throw new BuildException(stringArray[0] + " failed with return code " + n, task.getLocation());
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Could not launch " + stringArray[0] + ": " + iOException, task.getLocation());
        }
    }

    public static void closeStreams(Process process) {
        try {
            process.getInputStream().close();
        }
        catch (IOException iOException) {}
        try {
            process.getOutputStream().close();
        }
        catch (IOException iOException) {}
        try {
            process.getErrorStream().close();
        }
        catch (IOException iOException) {}
    }

    private static final Vector addVMSLogicals(Vector vector, BufferedReader bufferedReader) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = null;
        String string2 = null;
        String string3 = null;
        while ((string3 = bufferedReader.readLine()) != null) {
            int n;
            String string4;
            if (string3.startsWith("\t=")) {
                if (string == null) continue;
                string2 = string2 + ',' + string3.substring(4, string3.length() - 1);
                continue;
            }
            if (!string3.startsWith("  \"")) continue;
            if (string != null) {
                hashMap.put(string, string2);
            }
            if (hashMap.containsKey(string4 = string3.substring(3, (n = string3.indexOf(61)) - 2))) {
                string = null;
                continue;
            }
            string = string4;
            string2 = string3.substring(n + 3, string3.length() - 1);
        }
        if (string != null) {
            hashMap.put(string, string2);
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string5 = (String)iterator.next();
            vector.add(string5 + '=' + hashMap.get(string5));
        }
        return vector;
    }

    private final /* synthetic */ void this() {
        this.cmdl = null;
        this.env = null;
        this.exitValue = Integer.MAX_VALUE;
        this.workingDirectory = null;
        this.project = null;
        this.newEnvironment = false;
        this.useVMLauncher = true;
        this.spawn = false;
    }

    public Execute() {
        this(new PumpStreamHandler(), null);
    }

    public Execute(ExecuteStreamHandler executeStreamHandler) {
        this(executeStreamHandler, null);
    }

    public Execute(ExecuteStreamHandler executeStreamHandler, ExecuteWatchdog executeWatchdog) {
        this.this();
        this.setStreamHandler(executeStreamHandler);
        this.watchdog = executeWatchdog;
    }

    static {
        try {
            if (Os.isFamily("openvms")) {
                vmLauncher = new VmsCommandLauncher();
            } else if (!Os.isFamily("os/2")) {
                vmLauncher = new Java13CommandLauncher();
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        if (Os.isFamily("mac") && !Os.isFamily("unix")) {
            shellLauncher = new MacCommandLauncher(new CommandLauncher());
        } else if (Os.isFamily("os/2")) {
            shellLauncher = new OS2CommandLauncher(new CommandLauncher());
        } else if (Os.isFamily("windows")) {
            CommandLauncher commandLauncher = System.getProperty("java.version").startsWith("1.1") ? new Java11CommandLauncher() : new CommandLauncher();
            shellLauncher = !Os.isFamily("win9x") ? new WinNTCommandLauncher(commandLauncher) : new ScriptCommandLauncher("bin/antRun.bat", commandLauncher);
        } else if (Os.isFamily("netware")) {
            CommandLauncher commandLauncher = System.getProperty("java.version").startsWith("1.1") ? new Java11CommandLauncher() : new CommandLauncher();
            shellLauncher = new PerlScriptCommandLauncher("bin/antRun.pl", commandLauncher);
        } else {
            shellLauncher = Os.isFamily("openvms") ? vmLauncher : new ScriptCommandLauncher("bin/antRun", new CommandLauncher());
        }
    }

    private static class CommandLauncher {
        public Process exec(Project project, String[] stringArray, String[] stringArray2) throws IOException {
            if (project != null) {
                project.log("Execute:CommandLauncher: " + Commandline.describeCommand(stringArray), 4);
            }
            return Runtime.getRuntime().exec(stringArray, stringArray2);
        }

        public Process exec(Project project, String[] stringArray, String[] stringArray2, File file) throws IOException {
            if (file == null) {
                return this.exec(project, stringArray, stringArray2);
            }
            throw new IOException("Cannot execute a process in different directory under this JVM");
        }

        private CommandLauncher() {
        }
    }

    private static class VmsCommandLauncher
    extends Java13CommandLauncher {
        public Process exec(Project project, String[] stringArray, String[] stringArray2) throws IOException {
            String[] stringArray3 = new String[]{this.createCommandFile(stringArray, stringArray2).getPath()};
            return super.exec(project, stringArray3, stringArray2);
        }

        public Process exec(Project project, String[] stringArray, String[] stringArray2, File file) throws IOException {
            String[] stringArray3 = new String[]{this.createCommandFile(stringArray, stringArray2).getPath()};
            return super.exec(project, stringArray3, stringArray2, file);
        }

        /*
         * Exception decompiling
         */
        private final File createCommandFile(String[] var1_1, String[] var2_2) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 201->204)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class Java13CommandLauncher
    extends CommandLauncher {
        private Method myExecWithCWD;
        static /* synthetic */ Class array$Ljava$lang$String;
        static /* synthetic */ Class class$java$io$File;
        static /* synthetic */ Class class$java$lang$Runtime;

        public Process exec(Project project, String[] stringArray, String[] stringArray2, File file) throws IOException {
            try {
                if (project != null) {
                    project.log("Execute:Java13CommandLauncher: " + Commandline.describeCommand(stringArray), 4);
                }
                Object[] objectArray = new Object[]{stringArray, stringArray2, file};
                return (Process)this.myExecWithCWD.invoke((Object)Runtime.getRuntime(), objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                throw new BuildException("Unable to execute command", throwable);
            }
            catch (Exception exception) {
                throw new BuildException("Unable to execute command", exception);
            }
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError().initCause(classNotFoundException);
            }
        }

        public Java13CommandLauncher() throws NoSuchMethodException {
            Class clazz;
            Class clazz2;
            Class clazz3 = class$java$lang$Runtime;
            if (clazz3 == null) {
                clazz3 = class$java$lang$Runtime = Java13CommandLauncher.class("[Ljava.lang.Runtime;", false);
            }
            Class[] classArray = new Class[3];
            Class clazz4 = array$Ljava$lang$String;
            if (clazz4 == null) {
                clazz4 = classArray[0] = (array$Ljava$lang$String = Java13CommandLauncher.class("[Ljava.lang.String;", true));
            }
            if ((clazz2 = array$Ljava$lang$String) == null) {
                clazz2 = classArray[1] = (array$Ljava$lang$String = Java13CommandLauncher.class("[Ljava.lang.String;", true));
            }
            if ((clazz = class$java$io$File) == null) {
                clazz = class$java$io$File = Java13CommandLauncher.class("[Ljava.io.File;", false);
            }
            classArray[2] = clazz;
            this.myExecWithCWD = clazz3.getMethod("exec", classArray);
        }
    }

    private static class MacCommandLauncher
    extends CommandLauncherProxy {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Process exec(Project project, String[] stringArray, String[] stringArray2, File file) throws IOException {
            Process process;
            if (file == null) {
                return this.exec(project, stringArray, stringArray2);
            }
            System.getProperties().put("user.dir", file.getAbsolutePath());
            try {
                process = this.exec(project, stringArray, stringArray2);
                Object var6_6 = null;
                System.getProperties().put("user.dir", antWorkingDirectory);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                System.getProperties().put("user.dir", antWorkingDirectory);
                throw throwable;
            }
            return process;
        }

        MacCommandLauncher(CommandLauncher commandLauncher) {
            super(commandLauncher);
        }
    }

    private static class OS2CommandLauncher
    extends CommandLauncherProxy {
        public Process exec(Project project, String[] stringArray, String[] stringArray2, File file) throws IOException {
            File file2 = file;
            if (file == null) {
                if (project != null) {
                    file2 = project.getBaseDir();
                } else {
                    return this.exec(project, stringArray, stringArray2);
                }
            }
            String string = file2.getAbsolutePath();
            String[] stringArray3 = new String[stringArray.length + 7];
            stringArray3[0] = "cmd";
            stringArray3[1] = "/c";
            stringArray3[2] = string.substring(0, 2);
            stringArray3[3] = "&&";
            stringArray3[4] = "cd";
            stringArray3[5] = string.substring(2);
            stringArray3[6] = "&&";
            System.arraycopy(stringArray, 0, stringArray3, 7, stringArray.length);
            return this.exec(project, stringArray3, stringArray2);
        }

        OS2CommandLauncher(CommandLauncher commandLauncher) {
            super(commandLauncher);
        }
    }

    private static class Java11CommandLauncher
    extends CommandLauncher {
        public Process exec(Project project, String[] stringArray, String[] stringArray2) throws IOException {
            String[] stringArray3 = new String[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                stringArray3[n] = Commandline.quoteArgument(stringArray[n]);
                ++n;
            }
            if (project != null) {
                project.log("Execute:Java11CommandLauncher: " + Commandline.describeCommand(stringArray3), 4);
            }
            return Runtime.getRuntime().exec(stringArray3, stringArray2);
        }

        private Java11CommandLauncher() {
        }
    }

    private static class WinNTCommandLauncher
    extends CommandLauncherProxy {
        public Process exec(Project project, String[] stringArray, String[] stringArray2, File file) throws IOException {
            File file2 = file;
            if (file == null) {
                if (project != null) {
                    file2 = project.getBaseDir();
                } else {
                    return this.exec(project, stringArray, stringArray2);
                }
            }
            String[] stringArray3 = new String[stringArray.length + 6];
            stringArray3[0] = "cmd";
            stringArray3[1] = "/c";
            stringArray3[2] = "cd";
            stringArray3[3] = "/d";
            stringArray3[4] = file2.getAbsolutePath();
            stringArray3[5] = "&&";
            System.arraycopy(stringArray, 0, stringArray3, 6, stringArray.length);
            return this.exec(project, stringArray3, stringArray2);
        }

        WinNTCommandLauncher(CommandLauncher commandLauncher) {
            super(commandLauncher);
        }
    }

    private static class ScriptCommandLauncher
    extends CommandLauncherProxy {
        private String myScript;

        public Process exec(Project project, String[] stringArray, String[] stringArray2, File file) throws IOException {
            if (project == null) {
                if (file == null) {
                    return this.exec(project, stringArray, stringArray2);
                }
                throw new IOException("Cannot locate antRun script: No project provided");
            }
            String string = project.getProperty("ant.home");
            if (string == null) {
                throw new IOException("Cannot locate antRun script: Property 'ant.home' not found");
            }
            String string2 = project.resolveFile(string + File.separator + this.myScript).toString();
            File file2 = file;
            if (file == null && project != null) {
                file2 = project.getBaseDir();
            }
            String[] stringArray3 = new String[stringArray.length + 2];
            stringArray3[0] = string2;
            stringArray3[1] = file2.getAbsolutePath();
            System.arraycopy(stringArray, 0, stringArray3, 2, stringArray.length);
            return this.exec(project, stringArray3, stringArray2);
        }

        ScriptCommandLauncher(String string, CommandLauncher commandLauncher) {
            super(commandLauncher);
            this.myScript = string;
        }
    }

    private static class PerlScriptCommandLauncher
    extends CommandLauncherProxy {
        private String myScript;

        public Process exec(Project project, String[] stringArray, String[] stringArray2, File file) throws IOException {
            if (project == null) {
                if (file == null) {
                    return this.exec(project, stringArray, stringArray2);
                }
                throw new IOException("Cannot locate antRun script: No project provided");
            }
            String string = project.getProperty("ant.home");
            if (string == null) {
                throw new IOException("Cannot locate antRun script: Property 'ant.home' not found");
            }
            String string2 = project.resolveFile(string + File.separator + this.myScript).toString();
            File file2 = file;
            if (file == null && project != null) {
                file2 = project.getBaseDir();
            }
            String[] stringArray3 = new String[stringArray.length + 3];
            stringArray3[0] = "perl";
            stringArray3[1] = string2;
            stringArray3[2] = file2.getAbsolutePath();
            System.arraycopy(stringArray, 0, stringArray3, 3, stringArray.length);
            return this.exec(project, stringArray3, stringArray2);
        }

        PerlScriptCommandLauncher(String string, CommandLauncher commandLauncher) {
            super(commandLauncher);
            this.myScript = string;
        }
    }

    private static class CommandLauncherProxy
    extends CommandLauncher {
        private CommandLauncher myLauncher;

        public Process exec(Project project, String[] stringArray, String[] stringArray2) throws IOException {
            return this.myLauncher.exec(project, stringArray, stringArray2);
        }

        CommandLauncherProxy(CommandLauncher commandLauncher) {
            this.myLauncher = commandLauncher;
        }
    }
}

