/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.ssi;

import java.util.List;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.SnacCmdFactory;
import net.kano.joscar.snaccmd.ssi.ActivateSsiCmd;
import net.kano.joscar.snaccmd.ssi.BuddyAuthRequest;
import net.kano.joscar.snaccmd.ssi.CreateItemsCmd;
import net.kano.joscar.snaccmd.ssi.DeleteItemsCmd;
import net.kano.joscar.snaccmd.ssi.ModifyItemsCmd;
import net.kano.joscar.snaccmd.ssi.PostModCmd;
import net.kano.joscar.snaccmd.ssi.PreModCmd;
import net.kano.joscar.snaccmd.ssi.RemoveMeCmd;
import net.kano.joscar.snaccmd.ssi.SsiDataCheck;
import net.kano.joscar.snaccmd.ssi.SsiDataRequest;
import net.kano.joscar.snaccmd.ssi.SsiRightsRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerSsiCmdFactory
implements SnacCmdFactory {
    protected static final List<CmdType> SUPPORTED_TYPES = DefensiveTools.asUnmodifiableList((Object[])new CmdType[]{new CmdType(19, 2), new CmdType(19, 4), new CmdType(19, 5), new CmdType(19, 7), new CmdType(19, 8), new CmdType(19, 9), new CmdType(19, 10), new CmdType(19, 17), new CmdType(19, 18), new CmdType(19, 22), new CmdType(19, 24)});

    @Override
    public List<CmdType> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public SnacCommand genSnacCommand(SnacPacket packet) {
        if (packet.getFamily() != 19) {
            return null;
        }
        int command = packet.getCommand();
        if (command == 2) {
            return new SsiRightsRequest(packet);
        }
        if (command == 4) {
            return new SsiDataRequest(packet);
        }
        if (command == 5) {
            return new SsiDataCheck(packet);
        }
        if (command == 7) {
            return new ActivateSsiCmd(packet);
        }
        if (command == 8) {
            return new CreateItemsCmd(packet);
        }
        if (command == 9) {
            return new ModifyItemsCmd(packet);
        }
        if (command == 10) {
            return new DeleteItemsCmd(packet);
        }
        if (command == 17) {
            return new PreModCmd(packet);
        }
        if (command == 18) {
            return new PostModCmd(packet);
        }
        if (command == 22) {
            return new RemoveMeCmd(packet);
        }
        if (command == 24) {
            return new BuddyAuthRequest(packet);
        }
        return null;
    }
}

