/*
 * Decompiled with CFR 0.152.
 */
package com.oopsconsultancy.xmltask;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.Task;
import org.w3c.dom.Node;

public class BufferStore {
    private static final Map buffers = new HashMap();

    private BufferStore() {
    }

    public static Node[] get(String name) {
        List res = (List)buffers.get(name);
        if (res == null) {
            return null;
        }
        Node[] nodes = res.toArray(new Node[0]);
        for (int n = 0; n < nodes.length; ++n) {
            nodes[n] = nodes[n].cloneNode(true);
        }
        return nodes;
    }

    public static void set(String name, Node xml, boolean append, Task task) {
        Node newnode = xml.cloneNode(true);
        BufferStore.log("Storing " + newnode + " against buffer (" + name + ")", task);
        ArrayList<Node> list = (ArrayList<Node>)buffers.get(name);
        if (list != null) {
            if (!append) {
                BufferStore.log(" (overwriting existing entry)", task);
                list = new ArrayList();
                buffers.put(name, list);
            } else {
                BufferStore.log(" (appending to existing entry)", task);
            }
        } else {
            list = new ArrayList<Node>();
            buffers.put(name, list);
        }
        BufferStore.log("", task);
        list.add(newnode);
    }

    public static void clear(String name, Task task) {
        BufferStore.log("Clearing buffer (" + name + ")", task);
        buffers.put(name, new ArrayList());
    }

    public static void log(String msg, Task task) {
        if (task != null) {
            task.log(msg, 3);
        } else {
            System.out.println(msg);
        }
    }
}

