/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.message;

import java.nio.ByteBuffer;
import net.sf.jml.MsnContact;
import net.sf.jml.impl.AbstractMessenger;
import net.sf.jml.message.MsnMimeMessage;
import net.sf.jml.protocol.MsnSession;
import net.sf.jml.util.Charset;
import net.sf.jml.util.StringHolder;

public final class MsnEmailInitMessage
extends MsnMimeMessage {
    private static final String KEY_INBOX_UNREAD = "Inbox-Unread";
    private static final String KEY_FOLDERS_UNREAD = "Folders-Unread";
    private static final String KEY_INBOX_URL = "Inbox-URL";
    private static final String KEY_FOLDERS_URL = "Folders-URL";
    private static final String KEY_POST_URL = "Post-URL";
    protected final StringHolder bodykeys = new StringHolder();
    private Integer inboxUnread;
    private Integer foldersUnread;
    private String inboxURL;
    private String foldersURL;
    private String postURL;

    public MsnEmailInitMessage() {
        this.setContentType("text/x-msmsgsinitialemailnotification; charset=UTF-8");
    }

    public Integer getInboxUnread() {
        return this.inboxUnread;
    }

    public void setInboxUnread(Integer n) {
        this.inboxUnread = n;
    }

    public Integer getFoldersUnread() {
        return this.foldersUnread;
    }

    public void setFoldersUnread(Integer n) {
        this.foldersUnread = n;
    }

    public String getInboxURL() {
        return this.inboxURL;
    }

    public void setInboxURL(String string) {
        this.inboxURL = string;
    }

    public String getFoldersURL() {
        return this.foldersURL;
    }

    public void setFoldersURL(String string) {
        this.foldersURL = string;
    }

    public String getPostURL() {
        return this.postURL;
    }

    public void setPostURL(String string) {
        this.postURL = string;
    }

    protected void messageReceived(MsnSession msnSession, MsnContact msnContact) {
        super.messageReceived(msnSession, msnContact);
        ((AbstractMessenger)msnSession.getMessenger()).fireInitialEmailNotificationReceived(msnSession.getSwitchboard(), this, msnContact);
    }

    protected void parseMessage(byte[] byArray) {
        super.parseMessage(byArray);
        this.setInboxUnread(this.bodykeys.getIntProperty(KEY_INBOX_UNREAD));
        this.setFoldersUnread(this.bodykeys.getIntProperty(KEY_FOLDERS_UNREAD));
        this.setInboxURL(this.bodykeys.getProperty(KEY_INBOX_URL));
        this.setFoldersURL(this.bodykeys.getProperty(KEY_FOLDERS_URL));
        this.setPostURL(this.bodykeys.getProperty(KEY_POST_URL));
    }

    protected void parseBuffer(ByteBuffer byteBuffer) {
        super.parseBuffer(byteBuffer);
        this.bodykeys.parseString(Charset.decode(ByteBuffer.wrap(byteBuffer.array())));
    }
}

