/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snac;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.SeqNum;
import net.kano.joscar.flap.FlapProcessor;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snac.AbstractSnacProcessor;
import net.kano.joscar.snac.ImmediateSnacQueueManager;
import net.kano.joscar.snac.OutgoingSnacRequestListener;
import net.kano.joscar.snac.SnacPacketEvent;
import net.kano.joscar.snac.SnacQueueManager;
import net.kano.joscar.snac.SnacRequest;
import net.kano.joscar.snac.SnacRequestSentEvent;
import net.kano.joscar.snac.SnacRequestTimeoutEvent;
import net.kano.joscar.snac.SnacResponseEvent;
import net.kano.joscar.snac.SnacResponseListener;

public class ClientSnacProcessor
extends AbstractSnacProcessor {
    private static final Logger logger = Logger.getLogger("net.kano.joscar.snac");
    public static final Object ERRTYPE_SNAC_REQUEST_LISTENER = "ERRTYPE_SNAC_REQUEST_LISTENER";
    public static final Object ERRTYPE_SNAC_RESPONSE_LISTENER = "ERRTYPE_SNAC_RESPONSE_LISTENER";
    public static final int REQUEST_TTL_DEFAULT = 900;
    public static final long REQID_MIN = 0L;
    public static final long REQID_MAX = Integer.MAX_VALUE;
    private final SeqNum reqid = new SeqNum(0L, Integer.MAX_VALUE);
    private final Object requestEventLock = new Object();
    private final CopyOnWriteArrayList requestListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList responseListeners = new CopyOnWriteArrayList();
    private int requestTtl = 900;
    private final Map requests = new HashMap();
    private final List requestQueue = new LinkedList();
    private boolean paused = false;
    private SnacQueueManager queueManager;

    public ClientSnacProcessor(FlapProcessor flapProcessor) {
        super(flapProcessor);
        this.setSnacQueueManager(null);
    }

    public final synchronized void pause() {
        if (this.paused) {
            return;
        }
        this.queueManager.pause(this);
        this.paused = true;
    }

    public final synchronized void unpause() {
        if (!this.paused) {
            return;
        }
        this.queueManager.unpause(this);
        this.paused = false;
    }

    public final synchronized boolean isPaused() {
        return this.paused;
    }

    public final void migrate(FlapProcessor flapProcessor) {
        super.migrate(flapProcessor);
    }

    public final void addGlobalRequestListener(OutgoingSnacRequestListener outgoingSnacRequestListener) {
        DefensiveTools.checkNull(outgoingSnacRequestListener, "l");
        this.requestListeners.addIfAbsent(outgoingSnacRequestListener);
    }

    public final void removeGlobalRequestListener(OutgoingSnacRequestListener outgoingSnacRequestListener) {
        DefensiveTools.checkNull(outgoingSnacRequestListener, "l");
        this.requestListeners.remove(outgoingSnacRequestListener);
    }

    public final void addGlobalResponseListener(SnacResponseListener snacResponseListener) {
        DefensiveTools.checkNull(snacResponseListener, "l");
        this.responseListeners.addIfAbsent(snacResponseListener);
    }

    public final void removeGlobalResponseListener(SnacResponseListener snacResponseListener) {
        DefensiveTools.checkNull(snacResponseListener, "l");
        this.responseListeners.remove(snacResponseListener);
    }

    public final synchronized void setSnacQueueManager(SnacQueueManager snacQueueManager) {
        if (this.queueManager != null) {
            this.queueManager.clearQueue(this);
            this.queueManager.detached(this);
        }
        if (snacQueueManager == null) {
            snacQueueManager = new ImmediateSnacQueueManager();
        }
        this.queueManager = snacQueueManager;
        this.queueManager.attached(this);
        if (this.paused) {
            snacQueueManager.pause(this);
        }
    }

    public final synchronized void unsetSnacQueueManager(SnacQueueManager snacQueueManager) {
        if (this.queueManager == snacQueueManager) {
            this.setSnacQueueManager(null);
        }
    }

    public final synchronized SnacQueueManager getSnacQueueManager() {
        return this.queueManager;
    }

    public synchronized void setRequestTtl(int n) {
        DefensiveTools.checkRange(n, "requestTtl", 0);
        this.requestTtl = n;
    }

    public synchronized int getRequestTtl() {
        return this.requestTtl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void timeoutRequest(RequestInfo requestInfo) {
        int n;
        FlapProcessor flapProcessor;
        Object object = this;
        synchronized (object) {
            flapProcessor = this.getFlapProcessor();
            n = this.requestTtl;
        }
        object = requestInfo.getRequest();
        SnacRequestTimeoutEvent snacRequestTimeoutEvent = new SnacRequestTimeoutEvent(flapProcessor, this, (SnacRequest)object, n);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Snac request timed out: " + object);
        }
        Object object2 = this.requestEventLock;
        synchronized (object2) {
            if (!this.requestListeners.isEmpty()) {
                Iterator iterator = this.requestListeners.iterator();
                while (iterator.hasNext()) {
                    OutgoingSnacRequestListener outgoingSnacRequestListener = (OutgoingSnacRequestListener)iterator.next();
                    try {
                        outgoingSnacRequestListener.handleTimeout(snacRequestTimeoutEvent);
                    }
                    catch (Throwable throwable) {
                        flapProcessor.handleException(ERRTYPE_SNAC_REQUEST_LISTENER, throwable, outgoingSnacRequestListener);
                    }
                }
            }
            ((SnacRequest)object).timedOut(snacRequestTimeoutEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void clearAllRequests() {
        Map map = this.requests;
        synchronized (map) {
            Iterator iterator = this.requests.values().iterator();
            while (iterator.hasNext()) {
                RequestInfo requestInfo = (RequestInfo)iterator.next();
                this.timeoutRequest(requestInfo);
            }
            this.requests.clear();
            this.requestQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanRequests() {
        int n;
        Object object = this;
        synchronized (object) {
            n = this.requestTtl;
        }
        object = new LinkedList();
        Object object2 = this.requests;
        synchronized (object2) {
            if (this.requestQueue.isEmpty()) {
                return;
            }
            if (n == 0) {
                this.clearAllRequests();
                return;
            }
            long l = System.currentTimeMillis();
            long l2 = n * 1000;
            Iterator iterator = this.requestQueue.iterator();
            while (iterator.hasNext()) {
                RequestInfo requestInfo = (RequestInfo)iterator.next();
                long l3 = requestInfo.getSentTime();
                if (l3 == -1L) continue;
                long l4 = l - l3;
                if (l4 < l2) break;
                object.add(requestInfo);
                iterator.remove();
                this.requests.remove(new Long(requestInfo.getRequest().getReqid()));
            }
        }
        object2 = object.iterator();
        while (object2.hasNext()) {
            RequestInfo requestInfo = (RequestInfo)object2.next();
            this.timeoutRequest(requestInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendSnac(SnacRequest snacRequest) {
        SnacQueueManager snacQueueManager;
        DefensiveTools.checkNull(snacRequest, "request");
        SnacCommand snacCommand = snacRequest.getCommand();
        RequestInfo requestInfo = this.registerSnacRequest(snacRequest);
        long l = requestInfo.getRequest().getReqid();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Queueing Snac request #" + l + ": " + snacCommand);
        }
        ClientSnacProcessor clientSnacProcessor = this;
        synchronized (clientSnacProcessor) {
            snacQueueManager = this.queueManager;
        }
        snacQueueManager.queueSnac(this, snacRequest);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Finished queueing Snac request #" + l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendSnacImmediately(SnacRequest snacRequest) {
        int n;
        RequestInfo requestInfo;
        DefensiveTools.checkNull(snacRequest, "request");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Sending SNAC request " + snacRequest);
        }
        if ((requestInfo = this.registerSnacRequest(snacRequest)).getSentTime() != -1L) {
            throw new IllegalArgumentException("SNAC request " + snacRequest + " was already sent");
        }
        ClientSnacProcessor clientSnacProcessor = this;
        synchronized (clientSnacProcessor) {
            n = this.requestTtl;
        }
        long l = requestInfo.getRequest().getReqid();
        this.sendSnac(l, snacRequest.getCommand());
        this.fireSentEvent(requestInfo);
        Map map = this.requests;
        synchronized (map) {
            if (n != 0) {
                this.requestQueue.add(requestInfo);
            } else {
                this.requests.remove(new Long(l));
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Finished sending SNAC request " + snacRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSentEvent(RequestInfo requestInfo) {
        FlapProcessor flapProcessor;
        SnacRequest snacRequest = requestInfo.getRequest();
        long l = System.currentTimeMillis();
        requestInfo.sent(l);
        Object object = this;
        synchronized (object) {
            flapProcessor = this.getFlapProcessor();
        }
        object = new SnacRequestSentEvent(flapProcessor, this, snacRequest, l);
        Object object2 = this.requestEventLock;
        synchronized (object2) {
            if (!this.requestListeners.isEmpty()) {
                Iterator iterator = this.requestListeners.iterator();
                while (iterator.hasNext()) {
                    OutgoingSnacRequestListener outgoingSnacRequestListener = (OutgoingSnacRequestListener)iterator.next();
                    try {
                        outgoingSnacRequestListener.handleSent((SnacRequestSentEvent)object);
                    }
                    catch (Throwable throwable) {
                        flapProcessor.handleException(ERRTYPE_SNAC_REQUEST_LISTENER, throwable, outgoingSnacRequestListener);
                    }
                }
            }
            snacRequest.sent((SnacRequestSentEvent)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestInfo registerSnacRequest(SnacRequest snacRequest) {
        Map map = this.requests;
        synchronized (map) {
            if (snacRequest.getReqid() != -1L) {
                return (RequestInfo)this.requests.get(new Long(snacRequest.getReqid()));
            }
            long l = this.reqid.next();
            snacRequest.setReqid(l);
            Long l2 = new Long(l);
            this.cleanRequests();
            RequestInfo requestInfo = new RequestInfo(snacRequest);
            this.requests.put(l2, requestInfo);
            return requestInfo;
        }
    }

    public final synchronized void detach() {
        if (!this.isAttached()) {
            return;
        }
        super.detach();
        this.paused = false;
        this.queueManager.clearQueue(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean continueHandling(SnacPacketEvent snacPacketEvent) {
        RequestInfo requestInfo;
        boolean bl = logger.isLoggable(Level.FINER);
        FlapProcessor flapProcessor = snacPacketEvent.getFlapProcessor();
        SnacPacket snacPacket = snacPacketEvent.getSnacPacket();
        Long l = new Long(snacPacket.getReqid());
        Object object = this.requests;
        synchronized (object) {
            requestInfo = (RequestInfo)this.requests.get(l);
        }
        if (requestInfo == null) {
            return true;
        }
        object = requestInfo.getRequest();
        if (bl) {
            logger.finer("This Snac packet is a response to a request!");
        }
        SnacResponseEvent snacResponseEvent = new SnacResponseEvent(snacPacketEvent, (SnacRequest)object);
        if (!this.responseListeners.isEmpty()) {
            Iterator iterator = this.responseListeners.iterator();
            while (iterator.hasNext()) {
                SnacResponseListener snacResponseListener = (SnacResponseListener)iterator.next();
                try {
                    snacResponseListener.handleResponse(snacResponseEvent);
                }
                catch (Throwable throwable) {
                    flapProcessor.handleException(ERRTYPE_SNAC_RESPONSE_LISTENER, throwable, snacResponseListener);
                }
            }
        }
        try {
            ((SnacRequest)object).gotResponse(snacResponseEvent);
        }
        catch (Throwable throwable) {
            flapProcessor.handleException(ERRTYPE_SNAC_REQUEST_LISTENER, throwable, object);
        }
        return false;
    }

    private static class RequestInfo {
        private final SnacRequest request;
        private long sent = -1L;

        public RequestInfo(SnacRequest snacRequest) {
            this.request = snacRequest;
        }

        public final synchronized void sent(long l) throws IllegalStateException {
            if (this.sent != -1L) {
                throw new IllegalStateException(this.request + " was already sent " + (System.currentTimeMillis() - this.sent) / 1000L + " seconds ago");
            }
            this.sent = l;
        }

        public final SnacRequest getRequest() {
            return this.request;
        }

        public final synchronized long getSentTime() {
            return this.sent;
        }

        public String toString() {
            return "Request " + MiscTools.getClassName(this.request.getCommand()) + ": " + (this.sent == -1L ? "not sent" : "sent " + (System.currentTimeMillis() - this.sent) / 1000L + "s ago");
        }
    }
}

