/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.ssi;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;

public class SsiItem
implements LiveWritable,
Serializable {
    public static final int TYPE_BUDDY = 0;
    public static final int TYPE_GROUP = 1;
    public static final int TYPE_PERMIT = 2;
    public static final int TYPE_DENY = 3;
    public static final int TYPE_PRIVACY = 4;
    public static final int TYPE_VISIBILITY = 5;
    public static final int TYPE_ICON_INFO = 20;
    private final String name;
    private final int parentid;
    private final int id;
    private final int type;
    private final ByteBlock data;
    private final transient int totalSize;

    protected static SsiItem readSsiItem(ByteBlock byteBlock) {
        DefensiveTools.checkNull(byteBlock, "block");
        if (byteBlock.getLength() < 10) {
            return null;
        }
        int n = BinaryTools.getUShort(byteBlock, 0);
        if (byteBlock.getLength() < 2 + n) {
            return null;
        }
        ByteBlock byteBlock2 = byteBlock.subBlock(2, n);
        String string = BinaryTools.getAsciiString(byteBlock2);
        ByteBlock byteBlock3 = byteBlock.subBlock(2 + n);
        if (byteBlock3.getLength() < 8) {
            return null;
        }
        int n2 = BinaryTools.getUShort(byteBlock3, 0);
        int n3 = BinaryTools.getUShort(byteBlock3, 2);
        int n4 = BinaryTools.getUShort(byteBlock3, 4);
        int n5 = BinaryTools.getUShort(byteBlock3, 6);
        if (byteBlock3.getLength() < 1 + n5) {
            return null;
        }
        ByteBlock byteBlock4 = byteBlock3.subBlock(8, n5);
        int n6 = byteBlock4.getOffset() + byteBlock4.getLength() - byteBlock.getOffset();
        return new SsiItem(string, n2, n3, n4, byteBlock4, n6);
    }

    private SsiItem(String string, int n, int n2, int n3, ByteBlock byteBlock, int n4) {
        DefensiveTools.checkNull(string, "name");
        DefensiveTools.checkRange(n, "parentid", 0);
        DefensiveTools.checkRange(n2, "id", 0);
        DefensiveTools.checkRange(n3, "type", 0);
        DefensiveTools.checkRange(n4, "totalSize", -1);
        this.name = string;
        this.parentid = n;
        this.id = n2;
        this.type = n3;
        this.data = byteBlock;
        this.totalSize = n4;
    }

    public SsiItem(int n, int n2, int n3) {
        this("", n, n2, n3, null);
    }

    public SsiItem(String string, int n, int n2, int n3, ByteBlock byteBlock) {
        this(string, n, n2, n3, byteBlock, -1);
    }

    public final String getName() {
        return this.name;
    }

    public final int getParentId() {
        return this.parentid;
    }

    public final int getId() {
        return this.id;
    }

    public final int getItemType() {
        return this.type;
    }

    public final ByteBlock getData() {
        return this.data;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public void write(OutputStream outputStream) throws IOException {
        byte[] byArray = BinaryTools.getAsciiBytes(this.name);
        BinaryTools.writeUShort(outputStream, byArray.length);
        outputStream.write(byArray);
        BinaryTools.writeUShort(outputStream, this.parentid);
        BinaryTools.writeUShort(outputStream, this.id);
        BinaryTools.writeUShort(outputStream, this.type);
        int n = this.data == null ? 0 : this.data.getLength();
        BinaryTools.writeUShort(outputStream, n);
        if (this.data != null) {
            this.data.write(outputStream);
        }
    }

    public String toString() {
        return "SsiItem '" + this.name + "', type=0x" + Integer.toHexString(this.type) + ", parentid=0x" + Integer.toHexString(this.parentid) + ", id=0x" + Integer.toHexString(this.id);
    }
}

