/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.Collection;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.NioWritable;
import net.kano.joscar.Writable;
import net.kano.joscar.WritableLengthOwner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ByteBlock
implements Writable,
NioWritable,
Serializable {
    private static final byte[] BYTES_EMPTY = new byte[0];
    public static final ByteBlock EMPTY_BLOCK = new ByteBlock();
    private final byte[] bytes;
    private final int offset;
    private final int len;
    private int hashCode = 0;

    public static ByteBlock createFromUnsigned(int ... nArray) {
        byte[] byArray = new byte[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n < 0 || n > 255) {
                throw new IllegalArgumentException("bytes[" + i + "] is " + n + ", must be 0-255 inclusive");
            }
            byArray[i] = BinaryTools.getSingleUByte(n);
        }
        return ByteBlock.wrap(byArray);
    }

    public static ByteBlock wrap(byte[] byArray) throws IllegalArgumentException {
        return new ByteBlock(byArray, 0, byArray.length);
    }

    public static ByteBlock wrap(byte[] byArray, int n) throws IllegalArgumentException, IndexOutOfBoundsException {
        return new ByteBlock(byArray, n, byArray.length - n);
    }

    public static ByteBlock wrap(byte[] byArray, int n, int n2) throws IllegalArgumentException, IndexOutOfBoundsException {
        return new ByteBlock(byArray, n, n2);
    }

    public static ByteBlock createByteBlock(LiveWritable liveWritable) throws ArrayIndexOutOfBoundsException {
        int n;
        int n2;
        byte[] byArray;
        if (liveWritable instanceof ByteBlock) {
            ByteBlock byteBlock = (ByteBlock)liveWritable;
            byArray = byteBlock.bytes;
            n2 = byteBlock.offset;
            n = byteBlock.len;
        } else {
            ByteArrayOutputStream byteArrayOutputStream;
            if (liveWritable instanceof WritableLengthOwner) {
                long l = ((WritableLengthOwner)((Object)liveWritable)).getWritableLength();
                if (l > Integer.MAX_VALUE) {
                    throw new ArrayIndexOutOfBoundsException("writable length of " + liveWritable + " is " + l + ", must be <= Integer.MAX_VALUE (" + Integer.MAX_VALUE + ")");
                }
                byteArrayOutputStream = new ByteArrayOutputStream((int)l);
            } else {
                byteArrayOutputStream = new ByteArrayOutputStream();
            }
            try {
                liveWritable.write(byteArrayOutputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            byArray = byteArrayOutputStream.toByteArray();
            n2 = 0;
            n = byArray.length;
        }
        return ByteBlock.wrap(byArray, n2, n);
    }

    public static ByteBlock createByteBlock(Collection<? extends LiveWritable> collection) {
        if (collection.size() == 0) {
            return EMPTY_BLOCK;
        }
        if (collection.size() == 1) {
            return ByteBlock.createByteBlock(collection.iterator().next());
        }
        long l = 0L;
        boolean bl = true;
        for (LiveWritable object : collection) {
            if (!(object instanceof WritableLengthOwner)) {
                bl = false;
                break;
            }
            long liveWritable = ((WritableLengthOwner)((Object)object)).getWritableLength();
            l += liveWritable;
        }
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("sum of writable length of writables is " + l + ", must be <= " + "Integer.MAX_VALUE (" + Integer.MAX_VALUE + ")");
        }
        ByteArrayOutputStream byteArrayOutputStream = bl ? new ByteArrayOutputStream((int)l) : new ByteArrayOutputStream();
        try {
            for (LiveWritable liveWritable : collection) {
                liveWritable.write(byteArrayOutputStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ByteBlock.wrap(byteArrayOutputStream.toByteArray());
    }

    public static String createString(ByteBlock byteBlock, String string) throws UnsupportedEncodingException {
        return new String(byteBlock.bytes, byteBlock.offset, byteBlock.len, string);
    }

    public static InputStream createInputStream(ByteBlock byteBlock) {
        return new ByteArrayInputStream(byteBlock.bytes, byteBlock.offset, byteBlock.len);
    }

    private ByteBlock() {
        this.bytes = BYTES_EMPTY;
        this.offset = 0;
        this.len = 0;
    }

    private ByteBlock(byte[] byArray, int n, int n2) throws IllegalArgumentException, IndexOutOfBoundsException {
        DefensiveTools.checkNull(byArray, "bytes");
        if (n < 0) {
            throw new IndexOutOfBoundsException("offset (" + n + ") < 0");
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("length (" + n2 + ") < 0");
        }
        if (n2 + n > byArray.length) {
            throw new IndexOutOfBoundsException("len + offset (" + (n2 + n) + ") > data length (" + byArray.length + ")");
        }
        this.bytes = byArray;
        this.offset = n;
        this.len = n2;
    }

    public byte get(int n) throws IndexOutOfBoundsException {
        if (n < 0) {
            throw new IndexOutOfBoundsException("index (" + n + ") must be >= 0");
        }
        if (n >= this.len) {
            throw new IndexOutOfBoundsException("index (" + n + ") must be less than length (" + this.len + ")");
        }
        return this.bytes[this.offset + n];
    }

    public int getLength() {
        return this.len;
    }

    @Override
    public long getWritableLength() {
        return this.getLength();
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        DefensiveTools.checkNull(outputStream, "stream");
        outputStream.write(this.bytes, this.offset, this.len);
    }

    public byte[] toByteArray() {
        if (this.offset == 0 && this.len == this.bytes.length) {
            return (byte[])this.bytes.clone();
        }
        byte[] byArray = new byte[this.len];
        System.arraycopy(this.bytes, this.offset, byArray, 0, this.len);
        return byArray;
    }

    public ByteBlock subBlock(int n) throws IndexOutOfBoundsException {
        return this.subBlock(n, this.len - n);
    }

    public ByteBlock subBlock(int n, int n2) throws IndexOutOfBoundsException {
        if (n < 0) {
            throw new IndexOutOfBoundsException("offset (" + n + ") must be >= 0");
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("len (" + n2 + ") must be >= 0");
        }
        if (n2 + n > this.len) {
            throw new IndexOutOfBoundsException("length + offset (" + (n2 + n) + ") > length (" + this.len + ")");
        }
        return ByteBlock.wrap(this.bytes, this.offset + n, n2);
    }

    public int getOffset() {
        return this.offset;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("offset", 0);
        putField.put("len", this.len);
        byte[] byArray = this.offset == 0 && this.len == this.bytes.length ? this.bytes : this.toByteArray();
        putField.put("bytes", byArray);
        objectOutputStream.writeFields();
    }

    public void copyTo(byte[] byArray, int n) {
        System.arraycopy(this.bytes, this.offset, byArray, n, this.len);
    }

    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.bytes, this.offset, this.len).asReadOnlyBuffer();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ByteBlock)) {
            return false;
        }
        ByteBlock byteBlock = (ByteBlock)object;
        if (this.len != byteBlock.len) {
            return false;
        }
        int n = this.hashCode;
        int n2 = byteBlock.hashCode;
        if (n != 0 && n2 != 0 && n != n2) {
            return false;
        }
        if (this.offset == 0 && byteBlock.offset == 0 && this.len == this.bytes.length) {
            return Arrays.equals(this.bytes, byteBlock.bytes);
        }
        for (int i = 0; i < this.len; ++i) {
            if (this.get(i) == byteBlock.get(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = this.hashCode;
        if (n != 0) {
            return n;
        }
        int n2 = 0;
        int n3 = Math.max(1, this.len / 128);
        int n4 = this.offset + this.len;
        for (int i = this.offset; i < n4; i += n3) {
            n2 = n2 * 29 + this.bytes[i];
        }
        if (n2 == 0) {
            n2 = 1;
        }
        this.hashCode = n2;
        return n2;
    }

    public String toString() {
        return BinaryTools.describeData(this);
    }

    @Override
    public ReadableByteChannel getNioChannel() {
        return Channels.newChannel(new ByteArrayInputStream(this.bytes, this.offset, this.len));
    }
}

