/*
 * Decompiled with CFR 0.152.
 */
package ymsg.network;

import java.util.Vector;
import ymsg.network.Session;
import ymsg.network.UserStore;
import ymsg.network.YMSG9Packet;
import ymsg.network.YahooIdentity;
import ymsg.network.YahooUser;

public class YahooConference {
    protected Vector users;
    protected String room;
    private boolean closed;
    private Vector packetBuffer;
    private Session parent;
    private YahooIdentity identity;
    private UserStore userStore;

    YahooConference(UserStore userStore, YahooIdentity yahooIdentity, String string, Session session, boolean bl) {
        this.userStore = userStore;
        this.identity = yahooIdentity;
        this.users = new Vector();
        this.parent = session;
        this.room = string;
        this.closed = false;
        this.packetBuffer = bl ? new Vector() : null;
    }

    YahooConference(UserStore userStore, YahooIdentity yahooIdentity, String string, Session session) {
        this(userStore, yahooIdentity, string, session, true);
    }

    void closeConference() {
        this.closed = true;
    }

    public String getName() {
        return this.room;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Vector getMembers() {
        return (Vector)this.users.clone();
    }

    public YahooIdentity getIdentity() {
        return this.identity;
    }

    public String toString() {
        return "name=" + this.room + " users=" + this.users.size() + " id=" + this.identity.getId() + " closed?=" + this.closed;
    }

    boolean isInvited() {
        return this.packetBuffer == null;
    }

    Vector inviteReceived() {
        Vector vector = this.packetBuffer;
        this.packetBuffer = null;
        return vector;
    }

    void addPacket(YMSG9Packet yMSG9Packet) {
        if (this.packetBuffer == null) {
            throw new IllegalStateException("Cannot buffer packets, invite already received");
        }
        this.packetBuffer.addElement(yMSG9Packet);
    }

    Vector getUsers() {
        return this.users;
    }

    synchronized void addUsers(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addUser(stringArray[i]);
        }
    }

    synchronized void addUser(String string) {
        if (!this.exists(string) && !this.id(string)) {
            this.users.addElement(this.userStore.getOrCreate(string));
        }
    }

    synchronized void removeUser(String string) {
        for (int i = 0; i < this.users.size(); ++i) {
            if (!this._get(i).getId().equals(string)) continue;
            this.users.removeElementAt(i);
            return;
        }
    }

    private YahooUser _get(int n) {
        return (YahooUser)this.users.elementAt(n);
    }

    private boolean exists(String string) {
        for (int i = 0; i < this.users.size(); ++i) {
            if (!this._get(i).getId().equals(string)) continue;
            return true;
        }
        return false;
    }

    private boolean id(String string) {
        YahooIdentity[] yahooIdentityArray = this.parent.getIdentities();
        for (int i = 0; i < yahooIdentityArray.length; ++i) {
            if (!yahooIdentityArray[i].getId().equals(string)) continue;
            return true;
        }
        return false;
    }
}

