/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.partition;

import com.hazelcast.config.MemberGroupConfig;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.partition.DefaultMemberGroup;
import com.hazelcast.impl.partition.MemberGroup;
import com.hazelcast.impl.partition.MemberGroupFactory;
import com.hazelcast.util.AddressUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigMemberGroupFactory
implements MemberGroupFactory {
    private final Map<Integer, MemberGroupConfig> memberGroupConfigMap = new LinkedHashMap<Integer, MemberGroupConfig>();

    public ConfigMemberGroupFactory(Collection<MemberGroupConfig> memberGroupConfigs) {
        int key = 0;
        for (MemberGroupConfig groupConfig : memberGroupConfigs) {
            this.memberGroupConfigMap.put(key++, groupConfig);
        }
    }

    @Override
    public Collection<MemberGroup> createMemberGroups(Collection<MemberImpl> members) {
        HashMap<Integer, MemberGroup> memberGroups = new HashMap<Integer, MemberGroup>();
        block0: for (MemberImpl member : members) {
            if (member.isLiteMember()) continue;
            for (Map.Entry<Integer, MemberGroupConfig> groupConfigEntry : this.memberGroupConfigMap.entrySet()) {
                if (!AddressUtil.matchAnyInterface(member.getAddress().getHost(), groupConfigEntry.getValue().getInterfaces())) continue;
                MemberGroup group = (MemberGroup)memberGroups.get(groupConfigEntry.getKey());
                if (group == null) {
                    group = new DefaultMemberGroup();
                    memberGroups.put(groupConfigEntry.getKey(), group);
                }
                group.addMember(member);
                continue block0;
            }
        }
        return memberGroups.values();
    }
}

