/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snac;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.kano.joscar.snac.ClientSnacProcessor;
import net.kano.joscar.snac.SnacQueueManager;
import net.kano.joscar.snac.SnacRequest;

public class ImmediateSnacQueueManager
implements SnacQueueManager {
    private final Map<ClientSnacProcessor, SnacQueue> queues = new IdentityHashMap<ClientSnacProcessor, SnacQueue>();

    public synchronized void attached(ClientSnacProcessor processor) {
        this.queues.put(processor, new SnacQueue());
    }

    public synchronized void detached(ClientSnacProcessor processor) {
        this.queues.remove(processor);
    }

    private synchronized SnacQueue getQueue(ClientSnacProcessor processor) {
        return this.queues.get(processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause(ClientSnacProcessor processor) {
        SnacQueue queue;
        SnacQueue snacQueue = queue = this.getQueue(processor);
        synchronized (snacQueue) {
            queue.paused = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpause(ClientSnacProcessor processor) {
        ArrayList dequeued;
        SnacQueue queue;
        SnacQueue snacQueue = queue = this.getQueue(processor);
        synchronized (snacQueue) {
            queue.paused = false;
            dequeued = new ArrayList(queue.queue);
            queue.queue.clear();
        }
        Iterator it = dequeued.iterator();
        while (it.hasNext()) {
            SnacRequest req = (SnacRequest)it.next();
            it.remove();
            ImmediateSnacQueueManager.sendSnac(processor, req);
        }
    }

    protected static void sendSnac(ClientSnacProcessor processor, SnacRequest req) {
        processor.sendSnacImmediately(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueSnac(ClientSnacProcessor processor, SnacRequest request) {
        boolean paused;
        SnacQueue queue;
        SnacQueue snacQueue = queue = this.getQueue(processor);
        synchronized (snacQueue) {
            paused = queue.paused;
            if (paused) {
                queue.queue.addLast(request);
            }
        }
        if (!paused) {
            ImmediateSnacQueueManager.sendSnac(processor, request);
        }
    }

    public synchronized void clearQueue(ClientSnacProcessor processor) {
        this.queues.remove(processor);
    }

    public String toString() {
        return "ImmediateSnacQueueManager: queues=" + this.queues;
    }

    private static class SnacQueue {
        private boolean paused = false;
        private final LinkedList<SnacRequest> queue = new LinkedList();

        private SnacQueue() {
        }

        public String toString() {
            return "SnacQueue: paused=" + this.paused + ", queue=" + this.queue;
        }
    }
}

