/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import org.ice4j.socket.DelegatingSocket;
import org.ice4j.socket.IceSocketWrapper;

public class IceTcpSocketWrapper
extends IceSocketWrapper {
    private final InputStream inputStream;
    private final OutputStream outputStream;
    private final Socket socket;
    private final DelegatingSocket socketAsDelegatingSocket;

    public IceTcpSocketWrapper(Socket delegate) throws IOException {
        this.socket = delegate;
        if (delegate instanceof DelegatingSocket) {
            this.inputStream = null;
            this.outputStream = null;
            this.socketAsDelegatingSocket = (DelegatingSocket)delegate;
        } else {
            this.inputStream = delegate.getInputStream();
            this.outputStream = delegate.getOutputStream();
            this.socketAsDelegatingSocket = null;
        }
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.socket.getLocalSocketAddress();
    }

    public Socket getTCPSocket() {
        return this.socket;
    }

    public DatagramSocket getUDPSocket() {
        return null;
    }

    public void receive(DatagramPacket p) throws IOException {
        if (this.socketAsDelegatingSocket != null) {
            this.socketAsDelegatingSocket.receive(p);
        } else {
            DelegatingSocket.receiveFromInputStream(p, this.inputStream, this.getLocalAddress(), this.getLocalPort());
        }
    }

    public void send(DatagramPacket p) throws IOException {
        if (this.socketAsDelegatingSocket != null) {
            this.socketAsDelegatingSocket.send(p);
        } else {
            int len = p.getLength();
            int off = p.getOffset();
            byte[] data = new byte[len + 2];
            data[0] = (byte)(len >> 8 & 0xFF);
            data[1] = (byte)(len & 0xFF);
            System.arraycopy(p.getData(), off, data, 2, len);
            this.outputStream.write(data, 0, len + 2);
        }
    }
}

