/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.RootContactGroupJabberImpl;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresencePermissions;

public class OperationSetPersistentPresencePermissionsJabberImpl
implements OperationSetPersistentPresencePermissions {
    private static final String ALL_GROUPS_STR = "all";
    private static final String ROOT_GROUP_STR = "root";
    private List<String> readonlyGroups = new ArrayList<String>();
    private final ProtocolProviderServiceJabberImpl provider;

    OperationSetPersistentPresencePermissionsJabberImpl(ProtocolProviderServiceJabberImpl provider) {
        this.provider = provider;
        String readOnlyGroupsStr = provider.getAccountID().getAccountPropertyString((Object)"READ_ONLY_GROUPS");
        if (readOnlyGroupsStr == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(readOnlyGroupsStr, ",");
        while (tokenizer.hasMoreTokens()) {
            this.readonlyGroups.add(tokenizer.nextToken().trim());
        }
    }

    public boolean isReadOnly() {
        if (this.readonlyGroups.contains(ALL_GROUPS_STR)) {
            return true;
        }
        ArrayList<String> groupsList = new ArrayList<String>();
        groupsList.add(ROOT_GROUP_STR);
        Iterator groupsIter = ((OperationSetPersistentPresence)this.provider.getOperationSet(OperationSetPersistentPresence.class)).getServerStoredContactListRoot().subgroups();
        while (groupsIter.hasNext()) {
            groupsList.add(((ContactGroup)groupsIter.next()).getGroupName());
        }
        if (groupsList.size() > this.readonlyGroups.size()) {
            return false;
        }
        groupsList.removeAll(this.readonlyGroups);
        return groupsList.size() <= 0;
    }

    public boolean isReadOnly(Contact contact) {
        return this.isReadOnly(contact.getParentContactGroup());
    }

    public boolean isReadOnly(ContactGroup group) {
        if (this.isReadOnly()) {
            return true;
        }
        if (group instanceof RootContactGroupJabberImpl) {
            return this.readonlyGroups.contains(ROOT_GROUP_STR);
        }
        return this.readonlyGroups.contains(group.getGroupName());
    }
}

