/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.whack;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.XMLWriter;
import org.dom4j.io.XPPPacketReader;
import org.jivesoftware.whack.ExternalComponentManager;
import org.jivesoftware.whack.SocketReadThread;
import org.jivesoftware.whack.util.StringUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmpp.component.Component;
import org.xmpp.component.ComponentException;
import org.xmpp.component.ComponentManager;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.StreamError;

public class ExternalComponent
implements Component {
    private static String CHARSET = "UTF-8";
    private Component component;
    private ExternalComponentManager manager;
    private Socket socket;
    private XMLWriter xmlSerializer;
    private XmlPullParserFactory factory = null;
    private XPPPacketReader reader = null;
    private Writer writer = null;
    private String connectionID;
    private String domain;

    public ExternalComponent(Component component, ExternalComponentManager manager) {
        this.component = component;
        this.manager = manager;
    }

    public void connect(String host, int port, SocketFactory socketFactory, String domain) throws ComponentException {
        try {
            this.socket = socketFactory.createSocket(host, port);
            this.domain = domain;
            try {
                this.factory = XmlPullParserFactory.newInstance();
                this.reader = new XPPPacketReader();
                this.reader.setXPPFactory(this.factory);
                this.reader.getXPPParser().setInput((Reader)new InputStreamReader(this.socket.getInputStream(), CHARSET));
                this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), CHARSET));
                StringBuilder stream = new StringBuilder();
                stream.append("<stream:stream");
                stream.append(" xmlns=\"jabber:component:accept\"");
                stream.append(" xmlns:stream=\"http://etherx.jabber.org/streams\"");
                stream.append(" to=\"" + domain + "\">");
                this.writer.write(stream.toString());
                this.writer.flush();
                stream = null;
                XmlPullParser xpp = this.reader.getXPPParser();
                int eventType = xpp.getEventType();
                while (eventType != 2) {
                    eventType = xpp.next();
                }
                this.connectionID = xpp.getAttributeValue("", "id");
                this.xmlSerializer = new XMLWriter(this.writer);
                stream = new StringBuilder();
                stream.append("<handshake>");
                stream.append(StringUtils.hash(this.connectionID + this.manager.getSecretKey(domain)));
                stream.append("</handshake>");
                this.writer.write(stream.toString());
                this.writer.flush();
                stream = null;
                try {
                    Element doc = this.reader.parseDocument().getRootElement();
                    if (!"handshake".equals(doc.getName())) {
                        StreamError error = new StreamError(doc);
                        this.socket.close();
                        this.socket = null;
                        throw new ComponentException(error);
                    }
                    SocketReadThread readerThread = new SocketReadThread(this, this.reader);
                    readerThread.setDaemon(true);
                    readerThread.start();
                }
                catch (DocumentException e) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw new ComponentException(e);
                }
                catch (XmlPullParserException e) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw new ComponentException(e);
                }
            }
            catch (XmlPullParserException e) {
                try {
                    this.socket.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw new ComponentException(e);
            }
        }
        catch (UnknownHostException uhe) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            throw new ComponentException(uhe);
        }
        catch (IOException ioe) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            throw new ComponentException(ioe);
        }
    }

    public Component getComponent() {
        return this.component;
    }

    public String getName() {
        return this.component.getName();
    }

    public String getDescription() {
        return this.component.getDescription();
    }

    public void processPacket(Packet packet) {
        this.component.processPacket(packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Packet packet) {
        Writer writer = this.writer;
        synchronized (writer) {
            try {
                this.xmlSerializer.write(packet.getElement());
                this.xmlSerializer.flush();
            }
            catch (IOException e) {
                this.manager.getLog().error(e);
                try {
                    this.manager.removeComponent(this.domain);
                }
                catch (ComponentException e1) {
                    this.manager.getLog().error(e);
                }
            }
        }
    }

    public void initialize(JID jid, ComponentManager componentManager) {
        this.component.initialize(jid, componentManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.socket != null && !this.socket.isClosed()) {
            try {
                Writer writer = this.writer;
                synchronized (writer) {
                    try {
                        this.writer.write("</stream:stream>");
                        this.xmlSerializer.flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.socket.close();
            }
            catch (Exception e) {
                this.manager.getLog().error(e);
            }
        }
    }
}

