/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import gov.nist.core.GenericObject;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.Match;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public abstract class GenericObjectList
extends LinkedList
implements Serializable,
Cloneable {
    protected static final String SEMICOLON = ";";
    protected static final String COLON = ":";
    protected static final String COMMA = ",";
    protected static final String SLASH = "/";
    protected static final String SP = " ";
    protected static final String EQUALS = "=";
    protected static final String STAR = "*";
    protected static final String NEWLINE = "\r\n";
    protected static final String RETURN = "\n";
    protected static final String LESS_THAN = "<";
    protected static final String GREATER_THAN = ">";
    protected static final String AT = "@";
    protected static final String DOT = ".";
    protected static final String QUESTION = "?";
    protected static final String POUND = "#";
    protected static final String AND = "&";
    protected static final String LPAREN = "(";
    protected static final String RPAREN = ")";
    protected static final String DOUBLE_QUOTE = "\"";
    protected static final String QUOTE = "'";
    protected static final String HT = "\t";
    protected static final String PERCENT = "%";
    protected int indentation;
    protected String listName = null;
    private ListIterator myListIterator;
    private String stringRep = "";
    protected Class myClass;
    protected String separator = ";";

    protected String getIndentation() {
        char[] chars = new char[this.indentation];
        Arrays.fill(chars, ' ');
        return new String(chars);
    }

    protected static boolean isCloneable(Object obj) {
        return obj instanceof Cloneable;
    }

    public static boolean isMySubclass(Class other) {
        try {
            return GenericObjectList.class.isAssignableFrom(other);
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException(ex);
            return false;
        }
    }

    public Object clone() {
        GenericObjectList retval = (GenericObjectList)super.clone();
        ListIterator<GenericObject> iter = retval.listIterator();
        while (iter.hasNext()) {
            GenericObject obj = (GenericObject)((GenericObject)iter.next()).clone();
            iter.set(obj);
        }
        return retval;
    }

    public Class getMyClass() {
        return this.myClass;
    }

    public void setMyClass(Class cl) {
        this.myClass = cl;
    }

    protected GenericObjectList() {
    }

    protected GenericObjectList(String lname) {
        this();
        this.listName = lname;
    }

    protected GenericObjectList(String lname, String classname) {
        this(lname);
        try {
            this.myClass = Class.forName(classname);
        }
        catch (ClassNotFoundException ex) {
            InternalErrorHandler.handleException(ex);
        }
    }

    protected GenericObjectList(String lname, Class objclass) {
        this(lname);
        this.myClass = objclass;
    }

    protected GenericObject next(ListIterator iterator) {
        try {
            return (GenericObject)iterator.next();
        }
        catch (NoSuchElementException ex) {
            return null;
        }
    }

    protected GenericObject first() {
        this.myListIterator = this.listIterator(0);
        try {
            return (GenericObject)this.myListIterator.next();
        }
        catch (NoSuchElementException ex) {
            return null;
        }
    }

    protected GenericObject next() {
        if (this.myListIterator == null) {
            this.myListIterator = this.listIterator(0);
        }
        try {
            return (GenericObject)this.myListIterator.next();
        }
        catch (NoSuchElementException ex) {
            this.myListIterator = null;
            return null;
        }
    }

    protected void concatenate(GenericObjectList objList) {
        this.concatenate(objList, false);
    }

    protected void concatenate(GenericObjectList objList, boolean topFlag) {
        if (!topFlag) {
            this.addAll(objList);
        } else {
            this.addAll(0, objList);
        }
    }

    public Iterator getIterator() {
        return this.listIterator();
    }

    private void sprint(String s) {
        if (s == null) {
            this.stringRep = this.stringRep + this.getIndentation();
            this.stringRep = this.stringRep + "<null>\n";
            return;
        }
        if (s.compareTo("}") == 0 || s.compareTo("]") == 0) {
            --this.indentation;
        }
        this.stringRep = this.stringRep + this.getIndentation();
        this.stringRep = this.stringRep + s;
        this.stringRep = this.stringRep + RETURN;
        if (s.compareTo("{") == 0 || s.compareTo("[") == 0) {
            ++this.indentation;
        }
    }

    public String debugDump() {
        this.stringRep = "";
        GenericObject obj = this.first();
        if (obj == null) {
            return "<null>";
        }
        this.sprint("listName:");
        this.sprint(this.listName);
        this.sprint("{");
        while (obj != null) {
            this.sprint("[");
            try {
                if (Class.forName("gov.nist.core.GenericObjectList").isAssignableFrom(obj.getClass())) {
                    this.sprint(((GenericObjectList)((Object)obj)).debugDump(this.indentation));
                } else if (Class.forName("gov.nist.core.GenericObject").isAssignableFrom(obj.getClass())) {
                    this.sprint(obj.debugDump(this.indentation));
                }
            }
            catch (ClassNotFoundException ex) {
                InternalErrorHandler.handleException(ex);
            }
            obj = this.next();
            this.sprint("]");
        }
        this.sprint("}");
        return this.stringRep;
    }

    public String debugDump(int indent) {
        int save = this.indentation;
        this.indentation = indent;
        String retval = this.debugDump();
        this.indentation = save;
        return retval;
    }

    public boolean add(Object obj) {
        if (this.myClass == null) {
            this.myClass = obj.getClass();
            return super.add(obj);
        }
        Class<?> newclass = obj.getClass();
        if (!this.myClass.isAssignableFrom(newclass)) {
            throw new IllegalArgumentException("Class mismatch list insertion  " + this.listName + SP + newclass.getName() + SLASH + this.myClass.getName());
        }
        return super.add(obj);
    }

    public void addFirst(Object objToAdd) {
        if (this.myClass == null) {
            this.myClass = objToAdd.getClass();
        } else {
            Class<?> newclass = objToAdd.getClass();
            if (!this.myClass.isAssignableFrom(newclass)) {
                throw new IllegalArgumentException("Class mismatch list insertion  " + this.listName + SP + newclass.getName() + SLASH + this.myClass.getName());
            }
            super.addFirst(objToAdd);
        }
    }

    protected void add(GenericObject obj) {
        if (this.myClass == null) {
            this.myClass = obj.getClass();
            super.add(obj);
        } else {
            Class<?> newclass = obj.getClass();
            if (!this.myClass.isAssignableFrom(newclass)) {
                throw new IllegalArgumentException("Class mismatch list insertion  " + this.listName + SP + newclass.getName() + SLASH + this.myClass.getName());
            }
            super.add(obj);
        }
    }

    public void replace(String objectText, GenericObject replacementObject, boolean matchSubstring) throws IllegalArgumentException {
        if (objectText == null || replacementObject == null) {
            throw new IllegalArgumentException("null argument");
        }
        ListIterator listIterator = this.listIterator();
        LinkedList ll = new LinkedList();
        while (listIterator.hasNext()) {
            Cloneable gobj;
            Object obj = listIterator.next();
            if (GenericObject.isMySubclass(obj.getClass())) {
                gobj = (GenericObject)obj;
                if (!gobj.getClass().equals(replacementObject.getClass())) continue;
                if (!matchSubstring && ((GenericObject)gobj).encode().compareTo(objectText) == 0) {
                    ll.add(obj);
                    continue;
                }
                if (matchSubstring && ((GenericObject)gobj).encode().indexOf(objectText) >= 0) {
                    ll.add(obj);
                    continue;
                }
                ((GenericObject)gobj).replace(objectText, replacementObject, matchSubstring);
                continue;
            }
            if (!GenericObjectList.isMySubclass(obj.getClass()) || !(gobj = (GenericObjectList)obj).getClass().equals(replacementObject.getClass())) continue;
            if (!matchSubstring && ((GenericObjectList)gobj).encode().compareTo(objectText) == 0) {
                ll.add(obj);
                continue;
            }
            if (matchSubstring && ((GenericObjectList)gobj).encode().indexOf(objectText) >= 0) {
                ll.add(obj);
                continue;
            }
            ((GenericObjectList)gobj).replace(objectText, replacementObject, matchSubstring);
        }
        for (int i = 0; i < ll.size(); ++i) {
            Object obj = ll.get(i);
            this.remove(obj);
            this.add(i, replacementObject);
        }
    }

    public void replace(String objectText, GenericObjectList replacementObject, boolean matchSubstring) throws IllegalArgumentException {
        if (objectText == null || replacementObject == null) {
            throw new IllegalArgumentException("null argument");
        }
        ListIterator listIterator = this.listIterator();
        LinkedList ll = new LinkedList();
        while (listIterator.hasNext()) {
            Cloneable gobj;
            Object obj = listIterator.next();
            if (GenericObject.isMySubclass(obj.getClass())) {
                gobj = (GenericObject)obj;
                if (!gobj.getClass().equals(replacementObject.getClass())) continue;
                if (!matchSubstring && ((GenericObject)gobj).encode().compareTo(objectText) == 0) {
                    ll.add(obj);
                    continue;
                }
                if (matchSubstring && ((GenericObject)gobj).encode().indexOf(objectText) >= 0) {
                    ll.add(obj);
                    continue;
                }
                ((GenericObject)gobj).replace(objectText, replacementObject, matchSubstring);
                continue;
            }
            if (!GenericObjectList.isMySubclass(obj.getClass()) || !(gobj = (GenericObjectList)obj).getClass().equals(replacementObject.getClass())) continue;
            if (!matchSubstring && ((GenericObjectList)gobj).encode().compareTo(objectText) == 0) {
                ll.add(obj);
                continue;
            }
            if (matchSubstring && ((GenericObjectList)gobj).encode().indexOf(objectText) >= 0) {
                ll.add(obj);
                continue;
            }
            ((GenericObjectList)gobj).replace(objectText, replacementObject, matchSubstring);
        }
        for (int i = 0; i < ll.size(); ++i) {
            Object obj = ll.get(i);
            this.remove(obj);
            this.add(i, replacementObject);
        }
    }

    public void replace(Match regexp, GenericObjectList replacementObject) throws IllegalArgumentException {
        if (regexp == null || replacementObject == null) {
            throw new IllegalArgumentException("null argument");
        }
        ListIterator listIterator = this.listIterator();
        LinkedList ll = new LinkedList();
        while (listIterator.hasNext()) {
            Cloneable gobj;
            Object obj = listIterator.next();
            if (GenericObject.isMySubclass(obj.getClass())) {
                gobj = (GenericObject)obj;
                if (!gobj.getClass().equals(replacementObject.getClass())) continue;
                if (regexp.match(((GenericObject)gobj).encode())) {
                    ll.add(obj);
                    continue;
                }
                ((GenericObject)gobj).replace(regexp, replacementObject);
                continue;
            }
            if (!GenericObjectList.isMySubclass(obj.getClass()) || !(gobj = (GenericObjectList)obj).getClass().equals(replacementObject.getClass())) continue;
            if (regexp.match(((GenericObjectList)gobj).encode())) {
                ll.add(obj);
                continue;
            }
            ((GenericObjectList)gobj).replace(regexp, replacementObject);
        }
        for (int i = 0; i < ll.size(); ++i) {
            Object obj = ll.get(i);
            this.remove(obj);
            this.add(i, replacementObject);
        }
    }

    public void replace(Match regexp, GenericObject replacementObject) throws IllegalArgumentException {
        if (regexp == null || replacementObject == null) {
            throw new IllegalArgumentException("null argument");
        }
        ListIterator listIterator = this.listIterator();
        LinkedList ll = new LinkedList();
        while (listIterator.hasNext()) {
            Cloneable gobj;
            Object obj = listIterator.next();
            if (GenericObject.isMySubclass(obj.getClass())) {
                gobj = (GenericObject)obj;
                if (!gobj.getClass().equals(replacementObject.getClass())) continue;
                if (regexp.match(((GenericObject)gobj).encode())) {
                    ll.add(obj);
                    continue;
                }
                ((GenericObject)gobj).replace(regexp, replacementObject);
                continue;
            }
            if (!GenericObjectList.isMySubclass(obj.getClass()) || !(gobj = (GenericObjectList)obj).getClass().equals(replacementObject.getClass())) continue;
            if (regexp.match(((GenericObjectList)gobj).encode())) {
                ll.add(obj);
                continue;
            }
            ((GenericObjectList)gobj).replace(regexp, replacementObject);
        }
        for (int i = 0; i < ll.size(); ++i) {
            Object obj = ll.get(i);
            this.remove(obj);
            this.add(i, replacementObject);
        }
    }

    public void mergeObjects(GenericObjectList mergeList) {
        if (mergeList == null) {
            return;
        }
        ListIterator it1 = this.listIterator();
        ListIterator it2 = mergeList.listIterator();
        while (it1.hasNext()) {
            GenericObject outerObj = (GenericObject)it1.next();
            while (it2.hasNext()) {
                Object innerObj = it2.next();
                outerObj.merge(innerObj);
            }
        }
    }

    public String encode() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuffer encoding = new StringBuffer();
        ListIterator iterator = this.listIterator();
        if (iterator.hasNext()) {
            while (true) {
                Object obj;
                if ((obj = iterator.next()) instanceof GenericObject) {
                    GenericObject gobj = (GenericObject)obj;
                    encoding.append(gobj.encode());
                } else {
                    encoding.append(obj.toString());
                }
                if (!iterator.hasNext()) break;
                encoding.append(this.separator);
            }
        }
        return encoding.toString();
    }

    public String toString() {
        return this.encode();
    }

    public void setSeparator(String sep) {
        this.separator = sep;
    }

    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        GenericObjectList that = (GenericObjectList)other;
        if (this.size() != that.size()) {
            return false;
        }
        ListIterator myIterator = this.listIterator();
        while (myIterator.hasNext()) {
            Object myobj = myIterator.next();
            ListIterator hisIterator = that.listIterator();
            try {
                Object hisobj;
                while (!myobj.equals(hisobj = hisIterator.next())) {
                }
            }
            catch (NoSuchElementException ex) {
                return false;
            }
        }
        ListIterator hisIterator = that.listIterator();
        while (hisIterator.hasNext()) {
            Object hisobj = hisIterator.next();
            myIterator = this.listIterator();
            try {
                Object myobj;
                while (!hisobj.equals(myobj = myIterator.next())) {
                }
            }
            catch (NoSuchElementException ex) {
                return false;
            }
        }
        return true;
    }

    public boolean match(Object other) {
        block4: {
            if (!this.getClass().equals(other.getClass())) {
                return false;
            }
            GenericObjectList that = (GenericObjectList)other;
            ListIterator hisIterator = that.listIterator();
            if (hisIterator.hasNext()) {
                Object hisobj = hisIterator.next();
                Object myobj = null;
                ListIterator myIterator = this.listIterator();
                while (myIterator.hasNext()) {
                    myobj = myIterator.next();
                    if (myobj instanceof GenericObject) {
                        System.out.println("Trying to match  = " + ((GenericObject)myobj).encode());
                    }
                    if ((!GenericObject.isMySubclass(myobj.getClass()) || !((GenericObject)myobj).match(hisobj)) && (!GenericObjectList.isMySubclass(myobj.getClass()) || !((GenericObjectList)myobj).match(hisobj))) continue;
                    break block4;
                }
                System.out.println(((GenericObject)hisobj).encode());
                return false;
            }
        }
        return true;
    }
}

