/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.sysactivity;

import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusInterfaceName;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.exceptions.DBusException;

@DBusInterfaceName(value="org.freedesktop.NetworkManager")
public interface DBusNetworkManager
extends DBusInterface {
    public static final int NM_STATE_UNKNOWN = 0;
    public static final int NM_STATE_ASLEEP = 1;
    public static final int NM_STATE_CONNECTING = 2;
    public static final int NM_STATE_CONNECTED = 3;
    public static final int NM_STATE_DISCONNECTED = 4;
    public static final int NM9_STATE_UNKNOWN = 0;
    public static final int NM9_STATE_ASLEEP = 10;
    public static final int NM9_STATE_DISCONNECTED = 20;
    public static final int NM9_STATE_DISCONNECTING = 30;
    public static final int NM9_STATE_CONNECTING = 40;
    public static final int NM9_STATE_CONNECTED_LOCAL = 50;
    public static final int NM9_STATE_CONNECTED_SITE = 60;
    public static final int NM9_STATE_CONNECTED_GLOBAL = 70;

    public static class StateChanged
    extends StateChange {
        public StateChanged(String path, UInt32 status) throws DBusException {
            super(path, status);
        }

        @Override
        public String getStatusName() {
            switch (this.status.intValue()) {
                case 0: {
                    return "Unknown";
                }
                case 10: {
                    return "Asleep";
                }
                case 20: {
                    return "Disconnected";
                }
                case 30: {
                    return "Disconnecting";
                }
                case 40: {
                    return "Connecting";
                }
                case 50: {
                    return "LocalConnectivity";
                }
                case 60: {
                    return "SiteConnectivity";
                }
                case 70: {
                    return "GlobalConnectivity";
                }
            }
            return "Unknown";
        }
    }

    public static class StateChange
    extends DBusSignal {
        public final String name;
        public final UInt32 status;

        public StateChange(String path, UInt32 status) throws DBusException {
            super(path, status);
            this.name = path;
            this.status = status;
        }

        public int getStatus() {
            return this.status.intValue();
        }

        public String getStatusName() {
            switch (this.status.intValue()) {
                case 1: {
                    return "Asleep";
                }
                case 2: {
                    return "Connecting";
                }
                case 3: {
                    return "Connected";
                }
                case 4: {
                    return "Disconnected";
                }
            }
            return "Unknown";
        }
    }
}

