/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.URL;

public class FTPUtils {
    private Socket socket = null;
    private BufferedReader reader = null;
    private BufferedWriter writer = null;
    private final int DEFAULT_PORT = 21;
    private final int INVALID_FILE_SIZE = -1;
    private String user = null;
    private String pass = null;
    private String path = null;
    private String host = null;
    private int port = 21;

    public FTPUtils(String urlString) throws Exception {
        this.parseUrl(urlString);
        this.socket = new Socket(this.host, this.port);
        this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
        this.checkConnectionGreetings();
        this.login();
    }

    private void checkConnectionGreetings() throws Exception {
        String code = this.getResponseCode();
        if (!code.equals("220")) {
            throw new Exception("Connection Error.");
        }
    }

    private String getResponseCode() throws Exception {
        String line;
        while ((line = this.readLine()).charAt(3) != ' ') {
        }
        return line.substring(0, 3);
    }

    private void login() throws Exception {
        this.sendLine("USER " + this.user);
        String code = this.getResponseCode();
        if (code.equals("331") || code.equals("332")) {
            this.sendLine("PASS " + this.pass);
            code = this.getResponseCode();
            if (!code.equals("230")) {
                throw new Exception("Login error.");
            }
        } else if (!code.equals("230")) {
            throw new Exception("Login error.");
        }
    }

    public int getSize() throws Exception {
        this.sendLine("SIZE " + this.path);
        String line = this.readLine();
        if (!line.startsWith("213 ")) {
            throw new Exception("Size Error.");
        }
        String fileSizeStr = line.substring(4);
        int fileSize = -1;
        try {
            fileSize = Integer.parseInt(fileSizeStr);
        }
        catch (NumberFormatException e) {
            return -1;
        }
        return fileSize;
    }

    private void parseUrl(String urlString) throws Exception {
        int separatorIdx;
        String tmpUserInfo;
        URL url = new URL(urlString);
        this.host = url.getHost();
        this.port = url.getPort();
        if (this.port == -1) {
            this.port = 21;
        }
        if ((tmpUserInfo = url.getUserInfo()) != null && (separatorIdx = tmpUserInfo.lastIndexOf(58)) != -1) {
            this.pass = tmpUserInfo.substring(separatorIdx + 1);
            this.user = tmpUserInfo.substring(0, separatorIdx);
        }
        if (this.user == null) {
            this.user = "anonymus";
        }
        if (this.pass == null) {
            this.pass = "anonymus";
        }
        this.path = url.getPath();
        if (this.path == "") {
            throw new Exception("Not available path.");
        }
    }

    public void disconnect() throws IOException {
        this.sendLine("QUIT");
    }

    private void sendLine(String line) throws IOException {
        this.writer.write(line + "\r\n");
        this.writer.flush();
    }

    private String readLine() throws IOException {
        String line = this.reader.readLine();
        return line;
    }
}

