/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.UtilActivator;
import org.jitsi.service.fileaccess.FileAccessService;
import org.jitsi.service.fileaccess.FileCategory;

public class AvatarCacheUtils {
    private static final Logger logger = Logger.getLogger(AvatarCacheUtils.class);
    private static final String AVATAR_DIR = "avatarcache";
    private static final String[][] ESCAPE_SEQUENCES = new String[][]{{"&", "&_amp"}, {"/", "&_sl"}, {"\\\\", "&_bs"}, {":", "&_co"}, {"\\*", "&_as"}, {"\\?", "&_qm"}, {"\"", "&_pa"}, {"<", "&_lt"}, {">", "&_gt"}, {"\\|", "&_pp"}};

    public static byte[] getCachedAvatar(ProtocolProviderService protocolProvider) {
        String avatarPath = AvatarCacheUtils.getCachedAvatarPath(protocolProvider);
        byte[] cachedAvatar = AvatarCacheUtils.getLocallyStoredAvatar(avatarPath);
        if (cachedAvatar != null && cachedAvatar.length > 0) {
            return cachedAvatar;
        }
        return null;
    }

    public static byte[] getCachedAvatar(Contact protocolContact) {
        String avatarPath = AvatarCacheUtils.getCachedAvatarPath(protocolContact);
        byte[] cachedAvatar = AvatarCacheUtils.getLocallyStoredAvatar(avatarPath);
        if (cachedAvatar != null && cachedAvatar.length > 0) {
            return cachedAvatar;
        }
        return null;
    }

    public static String getCachedAvatarPath(ProtocolProviderService protocolProvider) {
        return AVATAR_DIR + File.separator + AvatarCacheUtils.escapeSpecialCharacters(protocolProvider.getAccountID().getAccountUniqueID()) + File.separator + AvatarCacheUtils.escapeSpecialCharacters(protocolProvider.getAccountID().getAccountUniqueID());
    }

    public static String getCachedAvatarPath(Contact protocolContact) {
        return AVATAR_DIR + File.separator + AvatarCacheUtils.escapeSpecialCharacters(protocolContact.getProtocolProvider().getAccountID().getAccountUniqueID()) + File.separator + AvatarCacheUtils.escapeSpecialCharacters(protocolContact.getAddress());
    }

    public static String getCachedAvatarPath(ProtocolProviderService protocolProvider, String contactAddress) {
        return AVATAR_DIR + File.separator + AvatarCacheUtils.escapeSpecialCharacters(protocolProvider.getAccountID().getAccountUniqueID()) + File.separator + AvatarCacheUtils.escapeSpecialCharacters(contactAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getLocallyStoredAvatar(String avatarPath) {
        block7: {
            try {
                File avatarFile = UtilActivator.getFileAccessService().getPrivatePersistentFile(avatarPath, FileCategory.CACHE);
                if (!avatarFile.exists()) break block7;
                FileInputStream avatarInputStream = new FileInputStream(avatarFile);
                byte[] bs = null;
                try {
                    int available = avatarInputStream.available();
                    if (available > 0) {
                        bs = new byte[available];
                        avatarInputStream.read(bs);
                    }
                }
                finally {
                    avatarInputStream.close();
                }
                if (bs != null) {
                    return bs;
                }
            }
            catch (Exception ex) {
                logger.error("Could not read avatar image from file " + avatarPath, ex);
            }
        }
        return null;
    }

    private static String escapeSpecialCharacters(String id) {
        String resultId = id;
        for (int j = 0; j < ESCAPE_SEQUENCES.length; ++j) {
            resultId = resultId.replaceAll(ESCAPE_SEQUENCES[j][0], ESCAPE_SEQUENCES[j][1]);
        }
        return resultId;
    }

    public static void cacheAvatar(Contact protoContact, byte[] avatarBytes) {
        String avatarDirPath = AVATAR_DIR + File.separator + AvatarCacheUtils.escapeSpecialCharacters(protoContact.getProtocolProvider().getAccountID().getAccountUniqueID());
        String avatarFileName = AvatarCacheUtils.escapeSpecialCharacters(protoContact.getAddress());
        AvatarCacheUtils.cacheAvatar(avatarDirPath, avatarFileName, avatarBytes);
    }

    public static void cacheAvatar(ProtocolProviderService protocolProvider, byte[] avatarBytes) {
        String accountUID = protocolProvider.getAccountID().getAccountUniqueID();
        String avatarDirPath = AVATAR_DIR + File.separator + AvatarCacheUtils.escapeSpecialCharacters(accountUID);
        String avatarFileName = AvatarCacheUtils.escapeSpecialCharacters(accountUID);
        AvatarCacheUtils.cacheAvatar(avatarDirPath, avatarFileName, avatarBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheAvatar(String avatarDirPath, String avatarFileName, byte[] avatarBytes) {
        File avatarDir = null;
        File avatarFile = null;
        try {
            FileAccessService fileAccessService = UtilActivator.getFileAccessService();
            avatarDir = fileAccessService.getPrivatePersistentDirectory(avatarDirPath, FileCategory.CACHE);
            avatarFile = fileAccessService.getPrivatePersistentFile(new File(avatarDirPath, avatarFileName).toString(), FileCategory.CACHE);
            if (!avatarFile.exists()) {
                if (!avatarDir.exists() && !avatarDir.mkdirs()) {
                    throw new IOException("Failed to create directory: " + avatarDir.getAbsolutePath());
                }
                if (!avatarFile.createNewFile()) {
                    throw new IOException("Failed to create file" + avatarFile.getAbsolutePath());
                }
            }
            FileOutputStream fileOutStream = new FileOutputStream(avatarFile);
            try {
                fileOutStream.write(avatarBytes);
                fileOutStream.flush();
            }
            finally {
                fileOutStream.close();
            }
        }
        catch (Exception ex) {
            logger.error("Failed to store avatar. dir =" + avatarDir + " file=" + avatarFile, ex);
        }
    }
}

