/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.theora_java;

import com.fluendo.jheora.Colorspace;
import com.fluendo.jheora.State;
import com.fluendo.jheora.YUVBuffer;
import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.ResourceUnavailableException;
import javax.media.Time;
import javax.media.Track;
import javax.media.format.AudioFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import net.sf.fmj.media.AbstractDemultiplexer;
import net.sf.fmj.media.AbstractTrack;
import net.sf.fmj.media.util.ImageToBuffer;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.theora_java.jheora.utils.YUVConverter;

public class JavaOggParser
extends AbstractDemultiplexer {
    private static final Logger logger = LoggerSingleton.logger;
    private static final boolean ENABLE_VIDEO = true;
    private static final boolean ENABLE_AUDIO = true;
    private final SyncState oy = new SyncState();
    private final Page og = new Page();
    private StreamState vo = new StreamState();
    private StreamState to = new StreamState();
    private final com.fluendo.jheora.Info ti = new com.fluendo.jheora.Info();
    private final com.fluendo.jheora.Comment tc = new com.fluendo.jheora.Comment();
    private final State td = new State();
    private final Info vi = new Info();
    private final DspState vd = new DspState();
    private final Block vb = new Block(this.vd);
    private Comment vc = new Comment();
    private int theora_p = 0;
    private int vorbis_p = 0;
    private int stateflag = 0;
    private int videobuf_ready = 0;
    private long videobuf_granulepos = -1L;
    private double videobuf_time = 0.0;
    private int audiobuf_fill = 0;
    private int audiobuf_ready = 0;
    private short[] audiobuf;
    private long audiobuf_granulepos = 0L;
    private int audiofd_fragsize;
    private final Packet op = new Packet();
    private final boolean USE_DATASOURCE_URL_ONLY = false;
    private ContentDescriptor[] supportedInputContentDescriptors = new ContentDescriptor[]{new ContentDescriptor("video.ogg"), new ContentDescriptor("audio.ogg"), new ContentDescriptor("application.ogg"), new ContentDescriptor("application.x_ogg")};
    private static final Object OGG_SYNC_OBJ = new Boolean(true);
    private PullDataSource source;
    private PullSourceStreamTrack[] tracks;
    private FileInputStream infile;
    private PullSourceStream instream;
    private boolean eomAudio;
    private boolean eomVideo;
    private int videoFrameNo = -1;

    public static AudioFormat convertCodecAudioFormat(Info info) {
        return new AudioFormat("LINEAR", info.rate, 16, info.channels, 0, 1);
    }

    public static VideoFormat convertCodecPixelFormat(com.fluendo.jheora.Info info) {
        Dimension dimension = new Dimension(info.width, info.height);
        int n = info.width * info.height;
        Class<int[]> clazz = int[].class;
        float f = (float)info.fps_numerator / (float)info.fps_denominator;
        int n2 = 0xFF0000;
        int n3 = 65280;
        int n4 = 255;
        return new RGBFormat(dimension, n, clazz, f, 32, n2, n3, n4);
    }

    private static int dump_comments(com.fluendo.jheora.Comment comment) {
        logger.info("Encoded by " + comment.vendor);
        if (comment.user_comments != null && comment.user_comments.length > 0) {
            logger.info("theora comment header:");
            for (int i = 0; i < comment.user_comments.length; ++i) {
                if (comment.user_comments[i] == null) continue;
                String string = comment.user_comments[i];
                logger.info("\t" + string);
            }
        }
        return 0;
    }

    static int getSerialNo(StreamState streamState) {
        return -1;
    }

    private static void report_colorspace(com.fluendo.jheora.Info info) {
        if (info.colorspace != Colorspace.UNSPECIFIED) {
            if (info.colorspace == Colorspace.ITU_REC_470M) {
                logger.info("  encoder specified ITU Rec 470M (NTSC) color.");
            } else if (info.colorspace == Colorspace.ITU_REC_470BG) {
                logger.info("  encoder specified ITU Rec 470BG (PAL) color.");
            } else {
                logger.warning("warning: encoder specified unknown colorspace (" + info.colorspace + ")");
            }
        }
    }

    private static final double secondsToNanos(double d) {
        return d * 1.0E9;
    }

    private int buffer_data(FileInputStream fileInputStream, SyncState syncState) throws IOException {
        byte[] byArray = syncState.data;
        int n = syncState.buffer(4096);
        int n2 = fileInputStream.read(byArray, n, 4096);
        if (n2 < 0) {
            return n2;
        }
        syncState.wrote(n2);
        return n2;
    }

    private int buffer_data(PullSourceStream pullSourceStream, SyncState syncState) throws IOException {
        byte[] byArray = syncState.data;
        int n = syncState.buffer(4096);
        int n2 = pullSourceStream.read(byArray, n, 4096);
        if (n2 < 0) {
            return n2;
        }
        syncState.wrote(n2);
        return n2;
    }

    private int buffer_data(SyncState syncState) throws IOException {
        return this.buffer_data(this.instream, syncState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = OGG_SYNC_OBJ;
        synchronized (object) {
            if (this.tracks != null) {
                for (int i = 0; i < this.tracks.length; ++i) {
                    if (this.tracks[i] == null) continue;
                    this.tracks[i].deallocate();
                    this.tracks[i] = null;
                }
                this.tracks = null;
            }
            if (this.vorbis_p != 0) {
                this.vo.clear();
                this.vb.clear();
                this.vd.clear();
                this.vi.clear();
            }
            if (this.theora_p != 0) {
                this.to.clear();
                this.td.clear();
                this.ti.clear();
            }
            this.oy.clear();
            try {
                if (this.infile != null) {
                    this.infile.close();
                }
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "" + iOException, iOException);
            }
            this.resetVars();
        }
        super.close();
    }

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return this.supportedInputContentDescriptors;
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        return this.tracks;
    }

    public boolean isPositionable() {
        return false;
    }

    public boolean isRandomAccess() {
        return super.isRandomAccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextAudioBuffer() throws IOException {
        Object object = OGG_SYNC_OBJ;
        synchronized (object) {
            int n;
            while (this.vorbis_p != 0 && this.audiobuf_ready == 0) {
                float[][][] fArrayArray = new float[1][][];
                int[] nArray = new int[this.vi.channels];
                n = this.vd.synthesis_pcmout((float[][][])fArrayArray, nArray);
                if (n > 0) {
                    int n2;
                    float[][] fArray = fArrayArray[0];
                    int n3 = this.audiobuf_fill / 2;
                    int n4 = (this.audiofd_fragsize - this.audiobuf_fill) / 2 / this.vi.channels;
                    for (n2 = 0; n2 < n && n2 < n4; ++n2) {
                        for (int i = 0; i < this.vi.channels; ++i) {
                            int n5 = Math.round(fArray[i][nArray[i] + n2] * 32767.0f);
                            if (n5 > Short.MAX_VALUE) {
                                n5 = Short.MAX_VALUE;
                            }
                            if (n5 < Short.MIN_VALUE) {
                                n5 = Short.MIN_VALUE;
                            }
                            this.audiobuf[n3++] = (short)n5;
                        }
                    }
                    this.vd.synthesis_read(n2);
                    this.audiobuf_fill += n2 * this.vi.channels * 2;
                    if (this.audiobuf_fill != this.audiofd_fragsize) continue;
                    this.audiobuf_ready = 1;
                    continue;
                }
                if (this.vo.packetout(this.op) <= 0) break;
                if (this.vb.synthesis(this.op) != 0) continue;
                this.vd.synthesis_blockin(this.vb);
            }
            if (this.audiobuf_ready == 0) {
                n = this.buffer_data(this.oy);
                if (n < 0) {
                    this.eomAudio = true;
                }
                while (this.oy.pageout(this.og) > 0) {
                    this.queue_page(this.og);
                }
            }
            if (this.vorbis_p == 0 || this.audiobuf_ready != 0) {
                this.stateflag = 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextVideoBuffer() throws IOException {
        Object object = OGG_SYNC_OBJ;
        synchronized (object) {
            int n;
            while (this.theora_p != 0 && this.videobuf_ready == 0 && this.to.packetout(this.op) > 0) {
                ++this.videoFrameNo;
                n = this.td.decodePacketin(this.op);
                if (n < 0) {
                    throw new IOException("decodePacketin failed: " + n);
                }
                this.videobuf_granulepos = this.td.granulepos;
                this.videobuf_time = this.td.granuleTime(this.videobuf_granulepos);
                if (this.videobuf_time == 0.0) {
                    this.videobuf_time = (double)this.videoFrameNo * (double)this.ti.fps_denominator / (double)this.ti.fps_numerator;
                }
                this.videobuf_ready = 1;
            }
            if (this.videobuf_ready == 0) {
                n = this.buffer_data(this.oy);
                if (n < 0) {
                    this.eomVideo = true;
                }
                while (this.oy.pageout(this.og) > 0) {
                    this.queue_page(this.og);
                }
            }
            if (this.theora_p == 0 || this.videobuf_ready != 0) {
                this.stateflag = 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws ResourceUnavailableException {
        Object object = OGG_SYNC_OBJ;
        synchronized (object) {
            this.resetVars();
            try {
                int n;
                this.source.connect();
                this.source.start();
                this.instream = this.source.getStreams()[0];
                this.oy.init();
                this.vi.init();
                this.vc.init();
                block5: while (this.stateflag == 0 && (n = this.buffer_data(this.oy)) > 0) {
                    while (this.oy.pageout(this.og) > 0) {
                        StreamState streamState = new StreamState();
                        if (this.og.bos() == 0) {
                            this.queue_page(this.og);
                            this.stateflag = 1;
                            continue block5;
                        }
                        streamState.init(this.og.serialno());
                        streamState.pagein(this.og);
                        streamState.packetout(this.op);
                        if (this.theora_p == 0 && this.ti.decodeHeader(this.tc, this.op) >= 0) {
                            this.to = streamState;
                            this.theora_p = 1;
                            continue;
                        }
                        if (this.vorbis_p == 0 && this.vi.synthesis_headerin(this.vc, this.op) >= 0) {
                            this.vo = streamState;
                            this.vorbis_p = 1;
                            continue;
                        }
                        streamState.clear();
                    }
                }
                while (this.theora_p != 0 && this.theora_p < 3 || this.vorbis_p != 0 && this.vorbis_p < 3) {
                    while (this.theora_p != 0 && this.theora_p < 3 && (n = this.to.packetout(this.op)) != 0) {
                        if (n < 0) {
                            throw new ResourceUnavailableException("Error parsing Theora stream headers; corrupt stream?");
                        }
                        if (this.ti.decodeHeader(this.tc, this.op) != 0) {
                            throw new ResourceUnavailableException("Error parsing Theora stream headers; corrupt stream?");
                        }
                        ++this.theora_p;
                        if (this.theora_p != 3) continue;
                    }
                    while (this.vorbis_p != 0 && this.vorbis_p < 3 && (n = this.vo.packetout(this.op)) != 0) {
                        if (n < 0) {
                            throw new ResourceUnavailableException("Error parsing Vorbis stream headers; corrupt stream?");
                        }
                        if (this.vi.synthesis_headerin(this.vc, this.op) != 0) {
                            throw new ResourceUnavailableException("Error parsing Vorbis stream headers; corrupt stream?");
                        }
                        ++this.vorbis_p;
                        if (this.vorbis_p != 3) continue;
                    }
                    if (this.oy.pageout(this.og) > 0) {
                        this.queue_page(this.og);
                        continue;
                    }
                    int n2 = this.buffer_data(this.oy);
                    if (n2 > 0) continue;
                    throw new ResourceUnavailableException("End of file while searching for codec headers.");
                }
                if (this.theora_p != 0) {
                    this.td.decodeInit(this.ti);
                    double d = (double)this.ti.fps_numerator / (double)this.ti.fps_denominator;
                    logger.info("Ogg logical stream " + Integer.toHexString(JavaOggParser.getSerialNo(this.to)) + " is Theora " + this.ti.width + "x" + this.ti.height + " " + d + " fps");
                    if (this.ti.width != this.ti.frame_width || this.ti.height != this.ti.frame_height) {
                        logger.warning("  Frame content is " + this.ti.frame_width + "x" + this.ti.frame_height + " with offset (" + this.ti.offset_x + "," + this.ti.offset_y + ").");
                    }
                    JavaOggParser.report_colorspace(this.ti);
                    JavaOggParser.dump_comments(this.tc);
                } else {
                    this.ti.clear();
                }
                if (this.vorbis_p != 0) {
                    this.vd.synthesis_init(this.vi);
                    this.vb.init(this.vd);
                    logger.info("Ogg logical stream " + Integer.toHexString(JavaOggParser.getSerialNo(this.vo)) + " is Vorbis " + this.vi.channels + " channel " + this.vi.rate + " Hz audio.");
                } else {
                    this.vi.clear();
                }
                this.stateflag = 0;
                VideoTrack videoTrack = null;
                AudioTrack audioTrack = null;
                if (this.theora_p != 0) {
                    videoTrack = new VideoTrack();
                }
                if (this.vorbis_p != 0) {
                    audioTrack = new AudioTrack();
                }
                if (audioTrack == null && videoTrack == null) {
                    throw new ResourceUnavailableException("No audio or video track found");
                }
                this.tracks = audioTrack != null && videoTrack != null ? new PullSourceStreamTrack[]{videoTrack, audioTrack} : (audioTrack != null ? new PullSourceStreamTrack[]{audioTrack} : new PullSourceStreamTrack[]{videoTrack});
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "" + iOException, iOException);
                throw new ResourceUnavailableException("" + iOException);
            }
        }
        super.open();
    }

    private int queue_page(Page page) {
        if (this.theora_p != 0) {
            this.to.pagein(this.og);
        }
        if (this.vorbis_p != 0) {
            this.vo.pagein(this.og);
        }
        return 0;
    }

    private void resetVars() {
        this.theora_p = 0;
        this.vorbis_p = 0;
        this.stateflag = 0;
        this.videobuf_ready = 0;
        this.videobuf_granulepos = -1L;
        this.videobuf_time = 0.0;
        this.audiobuf_fill = 0;
        this.audiobuf_ready = 0;
        this.audiobuf = null;
        this.audiobuf_granulepos = 0L;
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        String string = dataSource.getLocator().getProtocol();
        if (!(dataSource instanceof PullDataSource)) {
            throw new IncompatibleSourceException();
        }
        this.source = (PullDataSource)dataSource;
    }

    public void start() throws IOException {
    }

    static /* synthetic */ short[] access$202(JavaOggParser javaOggParser, short[] sArray) {
        javaOggParser.audiobuf = sArray;
        return sArray;
    }

    private class VideoTrack
    extends PullSourceStreamTrack {
        private final VideoFormat format;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public VideoTrack() throws ResourceUnavailableException {
            Object object = OGG_SYNC_OBJ;
            synchronized (object) {
                this.format = JavaOggParser.convertCodecPixelFormat(JavaOggParser.this.ti);
            }
        }

        public void deallocate() {
        }

        public Time getDuration() {
            return Duration.DURATION_UNKNOWN;
        }

        public Format getFormat() {
            return this.format;
        }

        public Time mapFrameToTime(int n) {
            return TIME_UNKNOWN;
        }

        public int mapTimeToFrame(Time time) {
            return Integer.MAX_VALUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFrame(Buffer buffer) {
            Object object = OGG_SYNC_OBJ;
            synchronized (object) {
                try {
                    JavaOggParser.this.nextVideoBuffer();
                }
                catch (IOException iOException) {
                    buffer.setLength(0);
                    buffer.setDiscard(true);
                    throw new RuntimeException(iOException);
                }
                if (JavaOggParser.this.stateflag != 0 && JavaOggParser.this.videobuf_ready != 0) {
                    YUVBuffer yUVBuffer = new YUVBuffer();
                    JavaOggParser.this.td.decodeYUVout(yUVBuffer);
                    BufferedImage bufferedImage = YUVConverter.toBufferedImage((YUVBuffer)yUVBuffer, (com.fluendo.jheora.Info)JavaOggParser.this.ti);
                    Buffer buffer2 = ImageToBuffer.createBuffer(bufferedImage, this.format.getFrameRate());
                    buffer.setData(buffer2.getData());
                    buffer.setLength(buffer2.getLength());
                    buffer.setOffset(buffer2.getOffset());
                    buffer.setEOM(false);
                    buffer.setDiscard(false);
                    buffer.setTimeStamp((long)JavaOggParser.secondsToNanos(JavaOggParser.this.videobuf_time));
                    JavaOggParser.this.videobuf_ready = 0;
                } else {
                    buffer.setEOM(JavaOggParser.this.eomVideo);
                    buffer.setLength(0);
                    if (!JavaOggParser.this.eomVideo) {
                        buffer.setDiscard(true);
                    }
                }
            }
        }
    }

    private abstract class PullSourceStreamTrack
    extends AbstractTrack {
        private PullSourceStreamTrack() {
        }

        public abstract void deallocate();
    }

    private class AudioTrack
    extends PullSourceStreamTrack {
        private final AudioFormat format;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AudioTrack() throws ResourceUnavailableException {
            JavaOggParser.this.audiofd_fragsize = 10000;
            JavaOggParser.access$202(JavaOggParser.this, new short[JavaOggParser.this.audiofd_fragsize / 2]);
            Object object = OGG_SYNC_OBJ;
            synchronized (object) {
                this.format = JavaOggParser.convertCodecAudioFormat(JavaOggParser.this.vi);
            }
        }

        public void deallocate() {
        }

        public Time getDuration() {
            return Duration.DURATION_UNKNOWN;
        }

        public Format getFormat() {
            return this.format;
        }

        public Time mapFrameToTime(int n) {
            return TIME_UNKNOWN;
        }

        public int mapTimeToFrame(Time time) {
            return Integer.MAX_VALUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFrame(Buffer buffer) {
            Object object = OGG_SYNC_OBJ;
            synchronized (object) {
                try {
                    JavaOggParser.this.nextAudioBuffer();
                }
                catch (IOException iOException) {
                    buffer.setLength(0);
                    buffer.setDiscard(true);
                    throw new RuntimeException(iOException);
                }
                if (JavaOggParser.this.stateflag == 0) {
                    buffer.setEOM(JavaOggParser.this.eomAudio);
                    buffer.setLength(0);
                    if (!JavaOggParser.this.eomAudio) {
                        buffer.setDiscard(true);
                    }
                    return;
                }
                if (JavaOggParser.this.audiobuf_ready == 0) {
                    buffer.setEOM(JavaOggParser.this.eomAudio);
                    buffer.setLength(0);
                    if (!JavaOggParser.this.eomAudio) {
                        buffer.setDiscard(true);
                    }
                    return;
                }
                byte[] byArray = new byte[JavaOggParser.this.audiobuf.length * 2];
                for (int i = 0; i < JavaOggParser.this.audiobuf.length; ++i) {
                    byArray[i * 2] = (byte)(JavaOggParser.this.audiobuf[i] & 0xFF);
                    byArray[i * 2 + 1] = (byte)(JavaOggParser.this.audiobuf[i] >> 8 & 0xFF);
                }
                buffer.setData(byArray);
                buffer.setLength(byArray.length);
                buffer.setOffset(0);
                buffer.setEOM(false);
                buffer.setDiscard(false);
                buffer.setTimeStamp(System.currentTimeMillis());
                JavaOggParser.this.audiobuf_fill = 0;
                JavaOggParser.this.audiobuf_ready = 0;
            }
        }
    }
}

