/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.registry;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Vector;
import net.sf.fmj.registry.RegistryContents;
import net.sf.fmj.registry.RegistryIO;

class PropertiesRegistryIO
implements RegistryIO {
    private final RegistryContents contents;
    final String[] PLUGIN_TYPE_STRINGS = new String[]{"demux", "codec", "effect", "renderer", "mux"};
    final String CONTENT_PREFIX_STRING = "content-prefix";
    final String PROTOCOL_PREFIX_STRING = "protocol-prefix";
    private static final int MAX = 100;

    public PropertiesRegistryIO(RegistryContents registryContents) {
        this.contents = registryContents;
    }

    private void fromProperties(Properties properties) {
        int n;
        Object object;
        for (int i = 0; i < this.contents.plugins.length; ++i) {
            String string = this.PLUGIN_TYPE_STRINGS[i];
            object = this.contents.plugins[i];
            for (int j = 0; j < 100; ++j) {
                String string2 = properties.getProperty(string + j);
                if (string2 == null || string2.equals("")) continue;
                ((Vector)object).add(string2);
            }
        }
        Vector<String> vector = this.contents.contentPrefixList;
        for (n = 0; n < 100; ++n) {
            object = properties.getProperty("content-prefix" + n);
            if (object == null || ((String)object).equals("")) continue;
            vector.add((String)object);
        }
        vector = this.contents.protocolPrefixList;
        for (n = 0; n < 100; ++n) {
            object = properties.getProperty("protocol-prefix" + n);
            if (object == null || ((String)object).equals("")) continue;
            vector.add((String)object);
        }
    }

    public void load(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        this.fromProperties(properties);
    }

    private Properties toProperties() {
        int n;
        Properties properties = new Properties();
        for (int i = 0; i < this.contents.plugins.length; ++i) {
            String string = this.PLUGIN_TYPE_STRINGS[i];
            Vector<String> vector = this.contents.plugins[i];
            for (int j = 0; j < vector.size(); ++j) {
                properties.setProperty(string + j, vector.get(j));
            }
        }
        Vector<String> vector = this.contents.contentPrefixList;
        for (n = 0; n < vector.size(); ++n) {
            properties.setProperty("content-prefix" + n, vector.get(n));
        }
        vector = this.contents.protocolPrefixList;
        for (n = 0; n < vector.size(); ++n) {
            properties.setProperty("protocol-prefix" + n, vector.get(n));
        }
        return properties;
    }

    public void write(OutputStream outputStream) throws IOException {
        Properties properties = this.toProperties();
        properties.store(outputStream, "FMJ registry");
    }
}

