/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.util;

import java.awt.Image;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public class BufferToImage {
    public BufferToImage(VideoFormat videoFormat) {
    }

    public BufferedImage createBufferedImage(Buffer buffer) {
        VideoFormat videoFormat = (VideoFormat)buffer.getFormat();
        int n = videoFormat.getSize().width;
        int n2 = videoFormat.getSize().height;
        Class<?> clazz = videoFormat.getDataType();
        if (videoFormat instanceof RGBFormat) {
            boolean bl;
            RGBFormat rGBFormat = (RGBFormat)videoFormat;
            int n3 = rGBFormat.getBitsPerPixel();
            int n4 = rGBFormat.getRedMask();
            int n5 = rGBFormat.getGreenMask();
            int n6 = rGBFormat.getBlueMask();
            int n7 = rGBFormat.getLineStride();
            int n8 = rGBFormat.getPixelStride();
            boolean bl2 = bl = rGBFormat.getFlipped() == 1;
            if (clazz == Format.byteArray) {
                byte[] byArray = (byte[])buffer.getData();
                if (n3 == 24) {
                    DataBufferByte dataBufferByte = new DataBufferByte(new byte[][]{byArray}, byArray.length);
                    ComponentSampleModel componentSampleModel = new ComponentSampleModel(0, n, n2, n8, n7, new int[]{n4 - 1, n5 - 1, n6 - 1});
                    WritableRaster writableRaster = Raster.createWritableRaster(componentSampleModel, dataBufferByte, new Point(0, 0));
                    ColorSpace colorSpace = ColorSpace.getInstance(1000);
                    int[] nArray = new int[]{8, 8, 8};
                    ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, nArray, false, false, 1, 0);
                    BufferedImage bufferedImage = new BufferedImage(componentColorModel, writableRaster, false, null);
                    return bufferedImage;
                }
                if (n3 == 32) {
                    DataBufferByte dataBufferByte = new DataBufferByte(new byte[][]{byArray}, byArray.length);
                    ComponentSampleModel componentSampleModel = new ComponentSampleModel(0, n, n2, n8, n7, new int[]{n4 - 1, n5 - 1, n6 - 1, 3});
                    WritableRaster writableRaster = Raster.createWritableRaster(componentSampleModel, dataBufferByte, new Point(0, 0));
                    ColorSpace colorSpace = ColorSpace.getInstance(1000);
                    int[] nArray = new int[]{8, 8, 8, 8};
                    ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, nArray, true, false, 3, 0);
                    BufferedImage bufferedImage = new BufferedImage(componentColorModel, writableRaster, false, null);
                    return bufferedImage;
                }
                if (n3 == 8) {
                    DataBufferByte dataBufferByte = new DataBufferByte(new byte[][]{byArray}, byArray.length);
                    SinglePixelPackedSampleModel singlePixelPackedSampleModel = new SinglePixelPackedSampleModel(0, n, n2, n7, new int[]{n4, n5, n6});
                    WritableRaster writableRaster = Raster.createWritableRaster(singlePixelPackedSampleModel, dataBufferByte, new Point(0, 0));
                    DirectColorModel directColorModel = new DirectColorModel(n3, n4, n5, n6);
                    BufferedImage bufferedImage = new BufferedImage(directColorModel, writableRaster, false, null);
                    return bufferedImage;
                }
                BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
                int[] nArray = new int[n * n2];
                int n9 = 0;
                int n10 = 0;
                if (bl) {
                    n10 = (n2 - 1) * n7;
                }
                for (int i = 0; i < n2; ++i) {
                    int n11 = n10;
                    for (int j = 0; j < n; ++j) {
                        byte by = byArray[n11 + n4 - 1];
                        byte by2 = byArray[n11 + n5 - 1];
                        byte by3 = byArray[n11 + n6 - 1];
                        int n12 = 0;
                        n12 += by & 0xFF;
                        n12 *= 256;
                        n12 += by2 & 0xFF;
                        n12 *= 256;
                        nArray[n9++] = n12 += by3 & 0xFF;
                        n11 += n8;
                    }
                    if (bl) {
                        n10 -= n7;
                        continue;
                    }
                    n10 += n7;
                }
                bufferedImage.setRGB(0, 0, n, n2, nArray, 0, n);
                return bufferedImage;
            }
            if (clazz == Format.shortArray) {
                short[] sArray = (short[])buffer.getData();
                if (n3 == 16) {
                    DataBufferUShort dataBufferUShort = new DataBufferUShort(new short[][]{sArray}, sArray.length);
                    SinglePixelPackedSampleModel singlePixelPackedSampleModel = new SinglePixelPackedSampleModel(1, n, n2, n7, new int[]{n4, n5, n6});
                    WritableRaster writableRaster = Raster.createWritableRaster(singlePixelPackedSampleModel, dataBufferUShort, new Point(0, 0));
                    DirectColorModel directColorModel = new DirectColorModel(n3, n4, n5, n6);
                    BufferedImage bufferedImage = new BufferedImage(directColorModel, writableRaster, false, null);
                    return bufferedImage;
                }
                throw new UnsupportedOperationException();
            }
            if (clazz == Format.intArray) {
                int[] nArray = (int[])buffer.getData();
                DataBufferInt dataBufferInt = new DataBufferInt(new int[][]{nArray}, nArray.length);
                SinglePixelPackedSampleModel singlePixelPackedSampleModel = new SinglePixelPackedSampleModel(3, n, n2, new int[]{n4, n5, n6});
                WritableRaster writableRaster = Raster.createWritableRaster(singlePixelPackedSampleModel, dataBufferInt, new Point(0, 0));
                DirectColorModel directColorModel = new DirectColorModel(24, n4, n5, n6, 0);
                BufferedImage bufferedImage = new BufferedImage(directColorModel, writableRaster, false, null);
                return bufferedImage;
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    public Image createImage(Buffer buffer) {
        return this.createBufferedImage(buffer);
    }
}

