/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.net.InetAddress;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.media.Format;
import javax.media.protocol.DataSource;
import javax.media.rtp.LocalParticipant;
import javax.media.rtp.Participant;
import javax.media.rtp.rtcp.Report;
import javax.media.rtp.rtcp.SourceDescription;
import net.sf.fmj.media.rtp.RTCPReportBlock;
import net.sf.fmj.media.rtp.RTCPReporter;
import net.sf.fmj.media.rtp.RTCPSDES;
import net.sf.fmj.media.rtp.RTPSinkStream;
import net.sf.fmj.media.rtp.RTPSourceInfo;
import net.sf.fmj.media.rtp.RTPSourceStream;
import net.sf.fmj.media.rtp.RTPStats;
import net.sf.fmj.media.rtp.SSRCCache;
import net.sf.fmj.media.rtp.util.SSRCTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SSRCInfo
implements Report {
    private SSRCCache cache;
    boolean alive = false;
    boolean payloadchange = false;
    boolean byeReceived = false;
    long byeTime = 0L;
    String byereason = null;
    RTPSourceInfo sourceInfo = null;
    SourceDescription name = null;
    SourceDescription email = null;
    SourceDescription phone = null;
    SourceDescription loc = null;
    SourceDescription tool = null;
    SourceDescription note = null;
    SourceDescription priv = null;
    public long lastSRntptimestamp;
    long lastSRrtptimestamp;
    long lastSRoctetcount;
    long lastSRpacketcount;
    long lastRTCPreceiptTime;
    public long lastSRreceiptTime;
    long lastHeardFrom;
    boolean quiet;
    boolean inactivesent;
    boolean aging;
    public boolean sender;
    public boolean ours;
    public int ssrc;
    boolean streamconnect;
    SSRCTable<RTCPReportBlock[]> reports;
    boolean active;
    boolean newrecvstream;
    boolean recvstrmap;
    boolean newpartsent;
    boolean lastsr;
    boolean wrapped;
    static final int INITIALPROBATION = 2;
    int probation;
    static final int PAYLOAD_UNASSIGNED = -1;
    boolean wassender;
    public int prevmaxseq;
    public int prevlost;
    long starttime;
    long rtptime;
    long systime;
    InetAddress address;
    int port;
    RTCPReporter reporter;
    Format currentformat;
    int payloadType;
    net.sf.fmj.media.protocol.rtp.DataSource dsource;
    DataSource pds;
    RTPSourceStream dstream;
    RTPSinkStream sinkstream;
    long lastRTPReceiptTime;
    public int maxseq;
    public int cycles;
    public int baseseq;
    int lastbadseq;
    public int received;
    long lasttimestamp;
    int lastPayloadType;
    public double jitter;
    int bytesreceived;
    RTPStats stats;
    int clockrate;

    SSRCInfo(SSRCCache sSRCCache, int n) {
        this.lastSRntptimestamp = 0L;
        this.lastSRrtptimestamp = 0L;
        this.lastSRoctetcount = 0L;
        this.lastSRpacketcount = 0L;
        this.lastRTCPreceiptTime = 0L;
        this.lastSRreceiptTime = 0L;
        this.lastHeardFrom = 0L;
        this.quiet = false;
        this.inactivesent = false;
        this.sender = false;
        this.ours = false;
        this.streamconnect = false;
        this.reports = new SSRCTable();
        this.active = false;
        this.newrecvstream = false;
        this.recvstrmap = false;
        this.newpartsent = false;
        this.lastsr = false;
        this.wrapped = false;
        this.probation = 2;
        this.wassender = false;
        this.currentformat = null;
        this.payloadType = -1;
        this.dsource = null;
        this.pds = null;
        this.dstream = null;
        this.sinkstream = null;
        this.maxseq = 0;
        this.cycles = 0;
        this.lasttimestamp = 0L;
        this.lastPayloadType = -1;
        this.jitter = 0.0;
        this.clockrate = 0;
        this.cache = sSRCCache;
        this.ssrc = n;
        this.stats = new RTPStats();
    }

    SSRCInfo(SSRCInfo sSRCInfo) {
        this.lastSRoctetcount = 0L;
        this.lastSRpacketcount = 0L;
        this.lastSRreceiptTime = 0L;
        this.lastHeardFrom = 0L;
        this.quiet = false;
        this.inactivesent = false;
        this.sender = false;
        this.ours = false;
        this.streamconnect = false;
        this.reports = new SSRCTable();
        this.active = false;
        this.newrecvstream = false;
        this.recvstrmap = false;
        this.newpartsent = false;
        this.lastsr = false;
        this.wrapped = false;
        this.probation = 2;
        this.wassender = false;
        this.currentformat = null;
        this.payloadType = -1;
        this.pds = null;
        this.sinkstream = null;
        this.maxseq = 0;
        this.cycles = 0;
        this.lasttimestamp = 0L;
        this.lastPayloadType = -1;
        this.jitter = 0.0;
        this.clockrate = 0;
        this.cache = sSRCInfo.cache;
        this.alive = sSRCInfo.alive;
        this.sourceInfo = sSRCInfo.sourceInfo;
        if (this.sourceInfo != null) {
            this.sourceInfo.addSSRC(this);
        }
        this.cache.remove(sSRCInfo.ssrc);
        this.name = sSRCInfo.name;
        this.email = sSRCInfo.email;
        this.phone = sSRCInfo.phone;
        this.loc = sSRCInfo.loc;
        this.tool = sSRCInfo.tool;
        this.note = sSRCInfo.note;
        this.priv = sSRCInfo.priv;
        this.lastSRntptimestamp = sSRCInfo.lastSRntptimestamp;
        this.lastSRrtptimestamp = sSRCInfo.lastSRrtptimestamp;
        this.lastSRoctetcount = sSRCInfo.lastSRoctetcount;
        this.lastSRpacketcount = sSRCInfo.lastSRpacketcount;
        this.lastRTCPreceiptTime = sSRCInfo.lastRTCPreceiptTime;
        this.lastSRreceiptTime = sSRCInfo.lastSRreceiptTime;
        this.lastHeardFrom = sSRCInfo.lastHeardFrom;
        this.quiet = sSRCInfo.quiet;
        this.inactivesent = sSRCInfo.inactivesent;
        this.aging = sSRCInfo.aging;
        this.reports = sSRCInfo.reports;
        this.ours = sSRCInfo.ours;
        this.ssrc = sSRCInfo.ssrc;
        this.streamconnect = sSRCInfo.streamconnect;
        this.newrecvstream = sSRCInfo.newrecvstream;
        this.recvstrmap = sSRCInfo.recvstrmap;
        this.newpartsent = sSRCInfo.newpartsent;
        this.lastsr = sSRCInfo.lastsr;
        this.probation = sSRCInfo.probation;
        this.wassender = sSRCInfo.wassender;
        this.prevmaxseq = sSRCInfo.prevmaxseq;
        this.prevlost = sSRCInfo.prevlost;
        this.starttime = sSRCInfo.starttime;
        this.reporter = sSRCInfo.reporter;
        if (sSRCInfo.reporter != null) {
            this.reporter.transmit.setSSRCInfo(this);
        }
        this.payloadType = sSRCInfo.payloadType;
        this.dsource = sSRCInfo.dsource;
        this.pds = sSRCInfo.pds;
        this.dstream = sSRCInfo.dstream;
        this.lastRTPReceiptTime = sSRCInfo.lastRTPReceiptTime;
        this.maxseq = sSRCInfo.maxseq;
        this.cycles = sSRCInfo.cycles;
        this.baseseq = sSRCInfo.baseseq;
        this.lastbadseq = sSRCInfo.lastbadseq;
        this.received = sSRCInfo.received;
        this.lasttimestamp = sSRCInfo.lasttimestamp;
        this.lastPayloadType = sSRCInfo.lastPayloadType;
        this.jitter = sSRCInfo.jitter;
        this.bytesreceived = sSRCInfo.bytesreceived;
        this.address = sSRCInfo.address;
        this.port = sSRCInfo.port;
        this.stats = sSRCInfo.stats;
        this.clockrate = sSRCInfo.clockrate;
        this.byeTime = sSRCInfo.byeTime;
        this.byeReceived = sSRCInfo.byeReceived;
    }

    void addSDESInfo(RTCPSDES rTCPSDES) {
        int n;
        for (n = 0; n < rTCPSDES.items.length && rTCPSDES.items[n].type != 1; ++n) {
        }
        String string = new String(rTCPSDES.items[n].data);
        String string2 = null;
        if (this.sourceInfo != null) {
            string2 = this.sourceInfo.getCNAME();
        }
        if (this.sourceInfo != null && !string.equals(string2)) {
            this.sourceInfo.removeSSRC(this);
            this.sourceInfo = null;
        }
        if (this.sourceInfo == null) {
            this.sourceInfo = this.cache.sourceInfoCache.get(string, this.ours);
            this.sourceInfo.addSSRC(this);
        }
        if (rTCPSDES.items.length > 1) {
            block10: for (int i = 0; i < rTCPSDES.items.length; ++i) {
                string = new String(rTCPSDES.items[i].data);
                switch (rTCPSDES.items[i].type) {
                    default: {
                        continue block10;
                    }
                    case 2: {
                        if (this.name == null) {
                            this.name = new SourceDescription(2, string, 0, false);
                            continue block10;
                        }
                        this.name.setDescription(string);
                        continue block10;
                    }
                    case 3: {
                        if (this.email == null) {
                            this.email = new SourceDescription(3, string, 0, false);
                            continue block10;
                        }
                        this.email.setDescription(string);
                        continue block10;
                    }
                    case 4: {
                        if (this.phone == null) {
                            this.phone = new SourceDescription(4, string, 0, false);
                            continue block10;
                        }
                        this.phone.setDescription(string);
                        continue block10;
                    }
                    case 5: {
                        if (this.loc == null) {
                            this.loc = new SourceDescription(5, string, 0, false);
                            continue block10;
                        }
                        this.loc.setDescription(string);
                        continue block10;
                    }
                    case 6: {
                        if (this.tool == null) {
                            this.tool = new SourceDescription(6, string, 0, false);
                            continue block10;
                        }
                        this.tool.setDescription(string);
                        continue block10;
                    }
                    case 7: {
                        if (this.note == null) {
                            this.note = new SourceDescription(7, string, 0, false);
                            continue block10;
                        }
                        this.note.setDescription(string);
                        continue block10;
                    }
                    case 8: {
                        if (this.priv == null) {
                            this.priv = new SourceDescription(8, string, 0, false);
                            continue block10;
                        }
                        this.priv.setDescription(string);
                    }
                }
            }
        }
    }

    void delete() {
        if (this.sourceInfo != null) {
            this.sourceInfo.removeSSRC(this);
        }
    }

    public String getCNAME() {
        return this.sourceInfo != null ? this.sourceInfo.getCNAME() : null;
    }

    @Override
    public Vector<RTCPReportBlock> getFeedbackReports() {
        Vector<RTCPReportBlock> vector = new Vector<RTCPReportBlock>(this.reports.size());
        if (this.reports.size() == 0) {
            return vector;
        }
        Enumeration<RTCPReportBlock[]> enumeration = this.reports.elements();
        try {
            while (enumeration.hasMoreElements()) {
                RTCPReportBlock[] rTCPReportBlockArray = enumeration.nextElement();
                RTCPReportBlock rTCPReportBlock = rTCPReportBlockArray[0];
                vector.addElement(rTCPReportBlock);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            System.err.println("No more elements");
        }
        vector.trimToSize();
        return vector;
    }

    @Override
    public Participant getParticipant() {
        if (this.sourceInfo instanceof LocalParticipant && this.cache.sm.IsNonParticipating()) {
            return null;
        }
        return this.sourceInfo;
    }

    int getPayloadType() {
        return this.payloadType;
    }

    RTPSourceInfo getRTPSourceInfo() {
        return this.sourceInfo;
    }

    @Override
    public Vector<SourceDescription> getSourceDescription() {
        Vector<SourceDescription> vector = new Vector<SourceDescription>();
        vector.addElement(this.sourceInfo.getCNAMESDES());
        if (this.name != null) {
            vector.addElement(this.name);
        }
        if (this.email != null) {
            vector.addElement(this.email);
        }
        if (this.phone != null) {
            vector.addElement(this.phone);
        }
        if (this.loc != null) {
            vector.addElement(this.loc);
        }
        if (this.tool != null) {
            vector.addElement(this.tool);
        }
        if (this.note != null) {
            vector.addElement(this.note);
        }
        if (this.priv != null) {
            vector.addElement(this.priv);
        }
        vector.trimToSize();
        return vector;
    }

    @Override
    public long getSSRC() {
        return this.ssrc;
    }

    public SSRCCache getSSRCCache() {
        return this.cache;
    }

    private void InitSDES() {
        this.name = new SourceDescription(2, null, 0, false);
        this.email = new SourceDescription(3, null, 0, false);
        this.phone = new SourceDescription(4, null, 0, false);
        this.loc = new SourceDescription(5, null, 0, false);
        this.tool = new SourceDescription(6, null, 0, false);
        this.note = new SourceDescription(7, null, 0, false);
        this.priv = new SourceDescription(8, null, 0, false);
    }

    void initsource(int n) {
        if (this.probation <= 0) {
            this.active = true;
            this.setSender(true);
        }
        this.baseseq = n;
        this.maxseq = n - 1;
        this.lastbadseq = -2;
        this.cycles = 0;
        this.received = 0;
        this.bytesreceived = 0;
        this.lastRTPReceiptTime = 0L;
        this.lasttimestamp = 0L;
        this.jitter = 0.0;
        this.prevmaxseq = this.maxseq;
        this.prevlost = 0;
    }

    boolean isActive() {
        return this.active;
    }

    void setAging(boolean bl) {
        if (this.aging == bl) {
            return;
        }
        this.aging = bl;
    }

    void setAlive(boolean bl) {
        this.setAging(false);
        if (this.alive == bl) {
            return;
        }
        if (bl) {
            this.reports.removeAll();
        } else {
            this.setSender(false);
        }
        this.alive = bl;
    }

    void setOurs(boolean bl) {
        if (this.ours == bl) {
            return;
        }
        if (bl) {
            this.setAlive(true);
        } else {
            this.setAlive(false);
        }
        this.ours = bl;
    }

    void setSender(boolean bl) {
        if (this.sender == bl) {
            return;
        }
        if (bl) {
            ++this.cache.sendercount;
            this.setAlive(true);
        } else {
            --this.cache.sendercount;
        }
        this.sender = bl;
    }

    void setSourceDescription(SourceDescription[] sourceDescriptionArray) {
        if (sourceDescriptionArray == null) {
            return;
        }
        String string = null;
        for (int i = 0; i < sourceDescriptionArray.length; ++i) {
            SourceDescription sourceDescription = sourceDescriptionArray[i];
            if (sourceDescription == null || sourceDescription.getType() != 1) continue;
            string = sourceDescriptionArray[i].getDescription();
            break;
        }
        String string2 = null;
        if (this.sourceInfo != null) {
            string2 = this.sourceInfo.getCNAME();
        }
        if (this.sourceInfo != null && string != null && !string.equals(string2)) {
            this.sourceInfo.removeSSRC(this);
            this.sourceInfo = null;
        }
        if (this.sourceInfo == null) {
            this.sourceInfo = this.cache.sourceInfoCache.get(string, true);
            this.sourceInfo.addSSRC(this);
        }
        block10: for (int i = 0; i < sourceDescriptionArray.length; ++i) {
            SourceDescription sourceDescription = sourceDescriptionArray[i];
            if (sourceDescription == null) continue;
            switch (sourceDescription.getType()) {
                default: {
                    continue block10;
                }
                case 2: {
                    if (this.name == null) {
                        this.name = new SourceDescription(2, sourceDescription.getDescription(), 0, false);
                        continue block10;
                    }
                    this.name.setDescription(sourceDescription.getDescription());
                    continue block10;
                }
                case 3: {
                    if (this.email == null) {
                        this.email = new SourceDescription(3, sourceDescription.getDescription(), 0, false);
                        continue block10;
                    }
                    this.email.setDescription(sourceDescription.getDescription());
                    continue block10;
                }
                case 4: {
                    if (this.phone == null) {
                        this.phone = new SourceDescription(4, sourceDescription.getDescription(), 0, false);
                        continue block10;
                    }
                    this.phone.setDescription(sourceDescription.getDescription());
                    continue block10;
                }
                case 5: {
                    if (this.loc == null) {
                        this.loc = new SourceDescription(5, sourceDescription.getDescription(), 0, false);
                        continue block10;
                    }
                    this.loc.setDescription(sourceDescription.getDescription());
                    continue block10;
                }
                case 6: {
                    if (this.tool == null) {
                        this.tool = new SourceDescription(6, sourceDescription.getDescription(), 0, false);
                        continue block10;
                    }
                    this.tool.setDescription(sourceDescription.getDescription());
                    continue block10;
                }
                case 7: {
                    if (this.note == null) {
                        this.note = new SourceDescription(7, sourceDescription.getDescription(), 0, false);
                        continue block10;
                    }
                    this.note.setDescription(sourceDescription.getDescription());
                    continue block10;
                }
                case 8: {
                    if (this.priv == null) {
                        this.priv = new SourceDescription(8, sourceDescription.getDescription(), 0, false);
                        continue block10;
                    }
                    this.priv.setDescription(sourceDescription.getDescription());
                }
            }
        }
    }

    public long getExpectedPacketCount() {
        long l = (long)this.maxseq & 0xFFFFL;
        long l2 = this.cycles;
        long l3 = (long)this.baseseq & 0xFFFFL;
        return l + l2 - l3 + 1L;
    }

    public RTCPReportBlock makeReceiverReport(long l) {
        double d;
        RTCPReportBlock rTCPReportBlock = new RTCPReportBlock();
        rTCPReportBlock.ssrc = this.ssrc;
        rTCPReportBlock.lastseq = this.maxseq + this.cycles;
        rTCPReportBlock.jitter = (int)this.jitter;
        rTCPReportBlock.lsr = (int)((this.lastSRntptimestamp & 0xFFFFFFFF0000L) >> 16);
        rTCPReportBlock.dlsr = (int)((double)(l - this.lastSRreceiptTime) * 65.536);
        rTCPReportBlock.packetslost = (int)(rTCPReportBlock.lastseq - (long)this.baseseq + 1L - (long)this.received);
        if (rTCPReportBlock.packetslost < 0) {
            rTCPReportBlock.packetslost = 0;
        }
        if ((d = (double)(rTCPReportBlock.packetslost - this.prevlost) / (double)(rTCPReportBlock.lastseq - (long)this.prevmaxseq)) < 0.0) {
            d = 0.0;
        }
        rTCPReportBlock.fractionlost = (int)(d * 256.0);
        this.prevmaxseq = (int)rTCPReportBlock.lastseq;
        this.prevlost = rTCPReportBlock.packetslost;
        return rTCPReportBlock;
    }
}

