/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.util.Vector;
import javax.media.protocol.DataSource;
import javax.media.rtp.LocalParticipant;
import javax.media.rtp.Participant;
import javax.media.rtp.RTPStream;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceptionStats;
import javax.media.rtp.rtcp.Feedback;
import javax.media.rtp.rtcp.ReceiverReport;
import javax.media.rtp.rtcp.Report;
import javax.media.rtp.rtcp.SenderReport;
import net.sf.fmj.media.rtp.SSRCCache;
import net.sf.fmj.media.rtp.SSRCInfo;

public class RecvSSRCInfo
extends SSRCInfo
implements ReceiveStream,
SenderReport,
ReceiverReport {
    RecvSSRCInfo(SSRCCache sSRCCache, int n) {
        super(sSRCCache, n);
    }

    RecvSSRCInfo(SSRCInfo sSRCInfo) {
        super(sSRCInfo);
    }

    public DataSource getDataSource() {
        return this.dsource;
    }

    public long getNTPTimeStampLSW() {
        return this.lastSRntptimestamp & 0xFFFFFFFFL;
    }

    public long getNTPTimeStampMSW() {
        return this.lastSRntptimestamp >> 32 & 0xFFFFFFFFL;
    }

    public Participant getParticipant() {
        SSRCCache sSRCCache = this.getSSRCCache();
        if (this.sourceInfo instanceof LocalParticipant && sSRCCache.sm.IsNonParticipating()) {
            return null;
        }
        return this.sourceInfo;
    }

    public long getRTPTimeStamp() {
        return this.lastSRrtptimestamp;
    }

    public long getSenderByteCount() {
        return this.lastSRoctetcount;
    }

    public Feedback getSenderFeedback() {
        SSRCCache sSRCCache = this.getSSRCCache();
        Report report = null;
        Vector vector = null;
        Vector vector2 = null;
        Feedback feedback = null;
        try {
            LocalParticipant localParticipant = sSRCCache.sm.getLocalParticipant();
            vector = localParticipant.getReports();
            for (int i = 0; i < vector.size(); ++i) {
                report = (Report)vector.elementAt(i);
                vector2 = report.getFeedbackReports();
                for (int j = 0; j < vector2.size(); ++j) {
                    feedback = (Feedback)vector2.elementAt(j);
                    long l = feedback.getSSRC();
                    if (l != this.getSSRC()) continue;
                    return feedback;
                }
            }
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public long getSenderPacketCount() {
        return this.lastSRpacketcount;
    }

    public SenderReport getSenderReport() {
        return this;
    }

    public ReceptionStats getSourceReceptionStats() {
        return this.stats;
    }

    public long getSSRC() {
        return this.ssrc;
    }

    public RTPStream getStream() {
        return this;
    }

    public int getRoundTripDelay(int n) {
        long l;
        Feedback feedback = null;
        for (Feedback feedback2 : this.getFeedbackReports()) {
            if (n != (int)feedback2.getSSRC()) continue;
            feedback = feedback2;
            break;
        }
        int n2 = 0;
        if (feedback != null && (l = this.lastRTCPreceiptTime) != 0L) {
            long l2 = feedback.getLSR();
            long l3 = feedback.getDLSR();
            n2 = RecvSSRCInfo.getRoundTripDelay(l, l2, l3);
        }
        return n2;
    }

    public static int getRoundTripDelay(long l, long l2, long l3) {
        int n = 0;
        if (l2 > 0L) {
            long l4 = l / 1000L;
            double d = (double)(l - l4 * 1000L) / 1000.0;
            long l5 = (int)(d * 4.294967296E9);
            long l6 = l4;
            long l7 = (l6 << 32) + l5;
            long l8 = (l7 = (l7 & 0xFFFFFFFF0000L) >> 16) - l2 - l3;
            if (l8 > 0L) {
                n = l8 > 4294967L ? 65536 : (int)(l8 * 1000L >> 16);
            }
        }
        return n;
    }
}

