/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.media.rtp.rtcp.SourceDescription;
import net.sf.fmj.media.rtp.AbstractRTCPReportBuilder;
import net.sf.fmj.media.rtp.RTCPPacket;
import net.sf.fmj.media.rtp.RTCPRRPacket;
import net.sf.fmj.media.rtp.RTCPReportBlock;
import net.sf.fmj.media.rtp.RTCPSDES;
import net.sf.fmj.media.rtp.RTCPSDESItem;
import net.sf.fmj.media.rtp.RTCPSDESPacket;
import net.sf.fmj.media.rtp.RTCPSRPacket;
import net.sf.fmj.media.rtp.RTCPTransmitter;
import net.sf.fmj.media.rtp.SSRCInfo;

public class DefaultRTCPReportBuilderImpl
extends AbstractRTCPReportBuilder {
    private int sdescounter;

    private RTCPReportBlock[] makeReceiverReports(RTCPTransmitter rTCPTransmitter, long l) {
        ArrayList<RTCPReportBlock> arrayList = new ArrayList<RTCPReportBlock>();
        Enumeration<SSRCInfo> enumeration = rTCPTransmitter.cache.cache.elements();
        while (enumeration.hasMoreElements()) {
            SSRCInfo sSRCInfo = enumeration.nextElement();
            if (sSRCInfo.ours || !sSRCInfo.sender) continue;
            arrayList.add(sSRCInfo.makeReceiverReport(l));
        }
        return arrayList.toArray(new RTCPReportBlock[arrayList.size()]);
    }

    public RTCPPacket[] makeReports(RTCPTransmitter rTCPTransmitter) {
        Object object;
        RTCPReportBlock[] rTCPReportBlockArray;
        long l = System.currentTimeMillis();
        ArrayList<RTCPPacket> arrayList = new ArrayList<RTCPPacket>();
        SSRCInfo sSRCInfo = rTCPTransmitter.ssrcInfo;
        boolean bl = sSRCInfo.sender;
        RTCPReportBlock[] rTCPReportBlockArray2 = rTCPReportBlockArray = this.makeReceiverReports(rTCPTransmitter, l);
        if (rTCPReportBlockArray.length > 31) {
            rTCPReportBlockArray2 = new RTCPReportBlock[31];
            System.arraycopy(rTCPReportBlockArray, 0, rTCPReportBlockArray2, 0, 31);
        }
        if (bl) {
            object = new RTCPSRPacket(sSRCInfo.ssrc, rTCPReportBlockArray2);
            arrayList.add((RTCPPacket)object);
            long l2 = sSRCInfo.systime == 0L ? System.currentTimeMillis() : sSRCInfo.systime;
            long l3 = l2 / 1000L;
            double d = (double)(l2 - l3 * 1000L) / 1000.0;
            ((RTCPSRPacket)object).ntptimestamplsw = (int)(d * 4.294967296E9);
            ((RTCPSRPacket)object).ntptimestampmsw = l3;
            ((RTCPSRPacket)object).rtptimestamp = (int)sSRCInfo.rtptime;
            ((RTCPSRPacket)object).packetcount = sSRCInfo.maxseq - sSRCInfo.baseseq;
            ((RTCPSRPacket)object).octetcount = sSRCInfo.bytesreceived;
        } else {
            arrayList.add(new RTCPRRPacket(sSRCInfo.ssrc, rTCPReportBlockArray2));
        }
        if (rTCPReportBlockArray2 != rTCPReportBlockArray) {
            for (int i = 31; i < rTCPReportBlockArray.length; i += 31) {
                if (rTCPReportBlockArray.length - i < 31) {
                    rTCPReportBlockArray2 = new RTCPReportBlock[rTCPReportBlockArray.length - i];
                }
                System.arraycopy(rTCPReportBlockArray, i, rTCPReportBlockArray2, 0, rTCPReportBlockArray2.length);
                arrayList.add(new RTCPRRPacket(sSRCInfo.ssrc, rTCPReportBlockArray2));
            }
        }
        object = new ArrayList(8);
        object.add(new RTCPSDESItem(1, sSRCInfo.getCNAME()));
        if (this.sdescounter % 3 == 0) {
            String string;
            SourceDescription sourceDescription = sSRCInfo.name;
            if (sourceDescription != null && (string = sourceDescription.getDescription()) != null) {
                object.add(new RTCPSDESItem(2, string));
            }
            if ((sourceDescription = sSRCInfo.email) != null && (string = sourceDescription.getDescription()) != null) {
                object.add(new RTCPSDESItem(3, string));
            }
            if ((sourceDescription = sSRCInfo.phone) != null && (string = sourceDescription.getDescription()) != null) {
                object.add(new RTCPSDESItem(4, string));
            }
            if ((sourceDescription = sSRCInfo.loc) != null && (string = sourceDescription.getDescription()) != null) {
                object.add(new RTCPSDESItem(5, string));
            }
            if ((sourceDescription = sSRCInfo.tool) != null && (string = sourceDescription.getDescription()) != null) {
                object.add(new RTCPSDESItem(6, string));
            }
            if ((sourceDescription = sSRCInfo.note) != null && (string = sourceDescription.getDescription()) != null) {
                object.add(new RTCPSDESItem(7, string));
            }
        }
        ++this.sdescounter;
        RTCPSDES rTCPSDES = new RTCPSDES();
        rTCPSDES.items = object.toArray(new RTCPSDESItem[object.size()]);
        rTCPSDES.ssrc = rTCPTransmitter.ssrcInfo.ssrc;
        arrayList.add(new RTCPSDESPacket(new RTCPSDES[]{rTCPSDES}));
        return arrayList.toArray(new RTCPPacket[arrayList.size()]);
    }

    public void reset() {
        this.sdescounter = 0;
    }
}

