/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.format;

import java.awt.Dimension;
import javax.media.Format;
import javax.media.format.VideoFormat;
import net.sf.fmj.codegen.FormatTraceUtils;
import net.sf.fmj.utility.FormatUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GIFFormat
extends VideoFormat {
    public GIFFormat() {
        super("gif");
        this.dataType = Format.byteArray;
    }

    public GIFFormat(Dimension dimension, int n, Class<?> clazz, float f) {
        super("gif", dimension, n, clazz, f);
    }

    @Override
    public Object clone() {
        return new GIFFormat(FormatUtils.clone(this.size), this.maxDataLength, this.dataType, this.frameRate);
    }

    @Override
    protected void copy(Format format) {
        super.copy(format);
        GIFFormat gIFFormat = (GIFFormat)format;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof GIFFormat)) {
            return false;
        }
        GIFFormat gIFFormat = (GIFFormat)object;
        return true;
    }

    @Override
    public Format intersects(Format format) {
        Format format2 = super.intersects(format);
        if (format instanceof GIFFormat) {
            GIFFormat gIFFormat = (GIFFormat)format2;
            GIFFormat gIFFormat2 = (GIFFormat)format;
            if (this.getClass().isAssignableFrom(format.getClass()) || format.getClass().isAssignableFrom(this.getClass())) {
                // empty if block
            }
        }
        FormatTraceUtils.traceIntersects(this, format, format2);
        return format2;
    }

    @Override
    public boolean matches(Format format) {
        if (!super.matches(format)) {
            FormatTraceUtils.traceMatches(this, format, false);
            return false;
        }
        if (!(format instanceof GIFFormat)) {
            FormatTraceUtils.traceMatches(this, format, true);
            return true;
        }
        GIFFormat gIFFormat = (GIFFormat)format;
        FormatTraceUtils.traceMatches(this, format, true);
        return true;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GIF video format:");
        if (FormatUtils.specified(this.size)) {
            stringBuffer.append(" size = " + this.size.width + "x" + this.size.height);
        }
        if (FormatUtils.specified(this.frameRate)) {
            stringBuffer.append(" FrameRate = " + this.frameRate);
        }
        if (FormatUtils.specified(this.maxDataLength)) {
            stringBuffer.append(" maxDataLength = " + this.maxDataLength);
        }
        if (FormatUtils.specified(this.dataType)) {
            stringBuffer.append(" dataType = " + this.dataType);
        }
        return stringBuffer.toString();
    }
}

