/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.datasink.render;

import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.CannotRealizeException;
import javax.media.IncompatibleSourceException;
import javax.media.Manager;
import javax.media.NoPlayerException;
import javax.media.Player;
import javax.media.protocol.DataSource;
import javax.swing.JFrame;
import net.sf.fmj.ejmf.toolkit.util.PlayerPanel;
import net.sf.fmj.media.AbstractDataSink;
import net.sf.fmj.utility.LoggerSingleton;

public class Handler
extends AbstractDataSink {
    private static final Logger logger = LoggerSingleton.logger;
    private DataSource source;
    private Player player;

    public void close() {
        try {
            this.stop();
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "" + iOException, iOException);
        }
    }

    public String getContentType() {
        if (this.source != null) {
            return this.source.getContentType();
        }
        return null;
    }

    public Object getControl(String string) {
        logger.warning("TODO: getControl " + string);
        return null;
    }

    public Object[] getControls() {
        logger.warning("TODO: getControls");
        return new Object[0];
    }

    public void open() throws IOException, SecurityException {
        try {
            this.player = Manager.createRealizedPlayer(this.source);
        }
        catch (NoPlayerException noPlayerException) {
            logger.log(Level.WARNING, "" + noPlayerException, noPlayerException);
            throw new IOException("" + noPlayerException);
        }
        catch (CannotRealizeException cannotRealizeException) {
            logger.log(Level.WARNING, "" + cannotRealizeException, cannotRealizeException);
            throw new IOException("" + cannotRealizeException);
        }
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        this.source = dataSource;
    }

    public void start() throws IOException {
        if (this.player.getVisualComponent() != null) {
            PlayerPanel playerPanel;
            try {
                playerPanel = new PlayerPanel(this.player);
            }
            catch (NoPlayerException noPlayerException) {
                logger.log(Level.WARNING, "" + noPlayerException, noPlayerException);
                throw new IOException("" + noPlayerException);
            }
            playerPanel.addVisualComponent();
            final JFrame jFrame = new JFrame("Renderer");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                }
            });
            playerPanel.getMediaPanel().addContainerListener(new ContainerListener(){

                public void componentAdded(ContainerEvent containerEvent) {
                    jFrame.pack();
                }

                public void componentRemoved(ContainerEvent containerEvent) {
                    jFrame.pack();
                }
            });
            jFrame.getContentPane().add(playerPanel);
            jFrame.pack();
            jFrame.setVisible(true);
        }
        this.player.start();
    }

    public void stop() throws IOException {
        if (this.player != null) {
            this.player.stop();
        }
    }
}

