/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.awt.Dimension;
import java.util.Vector;
import javax.media.Codec;
import javax.media.Format;
import javax.media.Multiplexer;
import javax.media.NotConfiguredError;
import javax.media.NotRealizedError;
import javax.media.Owned;
import javax.media.PlugIn;
import javax.media.PlugInManager;
import javax.media.Renderer;
import javax.media.Track;
import javax.media.UnsupportedPlugInException;
import javax.media.control.FrameRateControl;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import net.sf.fmj.filtergraph.GraphNode;
import net.sf.fmj.filtergraph.SimpleGraphBuilder;
import net.sf.fmj.media.BasicModule;
import net.sf.fmj.media.BasicMuxModule;
import net.sf.fmj.media.BasicProcessor;
import net.sf.fmj.media.BasicSinkModule;
import net.sf.fmj.media.BasicTrackControl;
import net.sf.fmj.media.InputConnector;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.OutputConnector;
import net.sf.fmj.media.PlaybackEngine;
import net.sf.fmj.media.SlowPlugIn;
import net.sf.fmj.media.codec.video.colorspace.RGBScaler;
import net.sf.fmj.media.control.ProgressControl;
import net.sf.fmj.media.util.Resource;

public class ProcessEngine
extends PlaybackEngine {
    protected BasicMuxModule muxModule;
    protected ContentDescriptor outputContentDes = null;
    String prefetchError = "Failed to prefetch: " + this;
    protected Vector targetMuxNames = null;
    protected GraphNode[] targetMuxes = null;
    protected GraphNode targetMux = null;
    protected Format[] targetMuxFormats = null;

    public ProcessEngine(BasicProcessor basicProcessor) {
        super(basicProcessor);
    }

    boolean connectMux() {
        int n;
        BasicTrackControl[] basicTrackControlArray = new BasicTrackControl[this.trackControls.length];
        int n2 = 0;
        Multiplexer multiplexer = (Multiplexer)this.targetMux.plugin;
        for (n = 0; n < this.trackControls.length; ++n) {
            if (!this.trackControls[n].isEnabled()) continue;
            basicTrackControlArray[n2++] = this.trackControls[n];
        }
        try {
            multiplexer.setContentDescriptor(this.outputContentDes);
        }
        catch (Exception exception) {
            Log.comment("Failed to set the output content descriptor on the multiplexer.");
            return false;
        }
        n = 0;
        if (multiplexer.setNumTracks(this.targetMuxFormats.length) != this.targetMuxFormats.length) {
            Log.comment("Failed  to set number of tracks on the multiplexer.");
            return false;
        }
        for (int i = 0; i < this.targetMuxFormats.length; ++i) {
            if (this.targetMuxFormats[i] != null && multiplexer.setInputFormat(this.targetMuxFormats[i], i) != null) continue;
            Log.comment("Failed to set input format on the multiplexer.");
            n = 1;
            break;
        }
        if (n != 0) {
            return false;
        }
        if (SimpleGraphBuilder.inspector != null && !SimpleGraphBuilder.inspector.verify(multiplexer, this.targetMuxFormats)) {
            return false;
        }
        BasicMuxModule basicMuxModule = new BasicMuxModule(multiplexer, this.targetMuxFormats);
        for (int i = 0; i < this.targetMuxFormats.length; ++i) {
            InputConnector inputConnector = basicMuxModule.getInputConnector(BasicMuxModule.ConnectorNamePrefix + i);
            if (inputConnector == null) {
                Log.comment("BasicMuxModule: connector mismatched.");
                return false;
            }
            inputConnector.setFormat(this.targetMuxFormats[i]);
            basicTrackControlArray[i].lastOC.setProtocol(inputConnector.getProtocol());
            basicTrackControlArray[i].lastOC.connectTo(inputConnector, this.targetMuxFormats[i]);
        }
        if (!basicMuxModule.doRealize()) {
            return false;
        }
        basicMuxModule.setModuleListener(this);
        basicMuxModule.setController(this);
        this.modules.addElement(basicMuxModule);
        this.sinks.addElement(basicMuxModule);
        this.muxModule = basicMuxModule;
        return true;
    }

    protected boolean doConfigure() {
        if (!this.doConfigure1()) {
            return false;
        }
        String[] stringArray = this.source.getOutputConnectorNames();
        this.trackControls = new BasicTrackControl[this.tracks.length];
        for (int i = 0; i < this.tracks.length; ++i) {
            this.trackControls[i] = new ProcTControl(this, this.tracks[i], this.source.getOutputConnector(stringArray[i]));
        }
        if (!this.doConfigure2()) {
            return false;
        }
        this.outputContentDes = new ContentDescriptor("raw");
        this.reenableHintTracks();
        return true;
    }

    protected synchronized boolean doPrefetch() {
        if (this.prefetched) {
            return true;
        }
        if (!this.doPrefetch1()) {
            return false;
        }
        if (this.muxModule != null && !this.muxModule.doPrefetch()) {
            Log.error(this.prefetchError);
            Log.error("  Cannot prefetch the multiplexer: " + this.muxModule.getMultiplexer() + "\n");
            return false;
        }
        return this.doPrefetch2();
    }

    protected synchronized boolean doRealize() {
        this.targetMuxes = null;
        if (!super.doRealize1()) {
            return false;
        }
        if (this.targetMux != null && !this.connectMux()) {
            Log.error(this.realizeError);
            Log.error("  Cannot connect the multiplexer\n");
            this.player.processError = this.genericProcessorError;
            return false;
        }
        return super.doRealize2();
    }

    protected synchronized void doStart() {
        if (this.started) {
            return;
        }
        this.doStart1();
        if (this.muxModule != null) {
            this.muxModule.doStart();
        }
        this.doStart2();
    }

    protected synchronized void doStop() {
        if (!this.started) {
            return;
        }
        this.doStop1();
        if (this.muxModule != null) {
            this.muxModule.doStop();
        }
        this.doStop2();
    }

    protected BasicSinkModule findMasterSink() {
        if (this.muxModule != null && this.muxModule.getClock() != null) {
            return this.muxModule;
        }
        return super.findMasterSink();
    }

    protected long getBitRate() {
        if (this.muxModule != null) {
            return this.muxModule.getBitsWritten();
        }
        return this.source.getBitsRead();
    }

    public ContentDescriptor getContentDescriptor() throws NotConfiguredError {
        if (this.getState() < 180) {
            this.throwError(new NotConfiguredError("getContentDescriptor " + NOT_CONFIGURED_ERROR));
        }
        return this.outputContentDes;
    }

    public DataSource getDataOutput() throws NotRealizedError {
        if (this.getState() < 300) {
            this.throwError(new NotRealizedError("getDataOutput " + NOT_REALIZED_ERROR));
        }
        if (this.muxModule != null) {
            return this.muxModule.getDataOutput();
        }
        return null;
    }

    BasicMuxModule getMuxModule() {
        return this.muxModule;
    }

    protected PlugIn getPlugIn(BasicModule basicModule) {
        if (basicModule instanceof BasicMuxModule) {
            return ((BasicMuxModule)basicModule).getMultiplexer();
        }
        return super.getPlugIn(basicModule);
    }

    public ContentDescriptor[] getSupportedContentDescriptors() throws NotConfiguredError {
        int n;
        if (this.getState() < 180) {
            this.throwError(new NotConfiguredError("getSupportedContentDescriptors " + NOT_CONFIGURED_ERROR));
        }
        Vector vector = PlugInManager.getPlugInList(null, null, 5);
        Vector<Format> vector2 = new Vector<Format>();
        for (n = 0; n < vector.size(); ++n) {
            Format[] formatArray = PlugInManager.getSupportedOutputFormats((String)vector.elementAt(n), 5);
            if (formatArray == null) continue;
            for (int i = 0; i < formatArray.length; ++i) {
                if (!(formatArray[i] instanceof ContentDescriptor)) continue;
                boolean bl = false;
                for (int j = 0; j < vector2.size(); ++j) {
                    if (!vector2.elementAt(j).equals(formatArray[i])) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                vector2.addElement(formatArray[i]);
            }
        }
        ContentDescriptor[] contentDescriptorArray = new ContentDescriptor[vector2.size()];
        for (n = 0; n < vector2.size(); ++n) {
            contentDescriptorArray[n] = (ContentDescriptor)vector2.elementAt(n);
        }
        return contentDescriptorArray;
    }

    public TrackControl[] getTrackControls() throws NotConfiguredError {
        if (this.getState() < 180) {
            this.throwError(new NotConfiguredError("getTrackControls " + NOT_CONFIGURED_ERROR));
        }
        return this.trackControls;
    }

    boolean isRTPFormat(Format format) {
        return format != null && format.getEncoding() != null && format.getEncoding().endsWith("rtp") || format.getEncoding().endsWith("RTP");
    }

    void reenableHintTracks() {
        for (int i = 0; i < this.trackControls.length; ++i) {
            if (!this.isRTPFormat(this.trackControls[i].getOriginalFormat())) continue;
            this.trackControls[i].setEnabled(true);
            break;
        }
    }

    protected void resetBitRate() {
        if (this.muxModule != null) {
            this.muxModule.resetBitsWritten();
        } else {
            this.source.resetBitsRead();
        }
    }

    public ContentDescriptor setContentDescriptor(ContentDescriptor contentDescriptor) throws NotConfiguredError {
        Vector vector;
        if (this.getState() < 180) {
            this.throwError(new NotConfiguredError("setContentDescriptor " + NOT_CONFIGURED_ERROR));
        }
        if (this.getState() > 180) {
            return null;
        }
        if (contentDescriptor != null && ((vector = PlugInManager.getPlugInList(null, contentDescriptor, 5)) == null || vector.size() == 0)) {
            return null;
        }
        this.outputContentDes = contentDescriptor;
        return this.outputContentDes;
    }

    class ProcTControl
    extends BasicTrackControl
    implements Owned {
        protected Format formatWanted;
        protected Codec[] codecChainWanted;
        protected Renderer rendererWanted;
        protected ProcGraphBuilder gb;
        protected Format[] supportedFormats;

        public ProcTControl(ProcessEngine processEngine2, Track track, OutputConnector outputConnector) {
            super(processEngine2, track, outputConnector);
            this.formatWanted = null;
            this.codecChainWanted = null;
            this.rendererWanted = null;
            this.supportedFormats = null;
        }

        public boolean buildTrack(int n, int n2) {
            if (this.gb == null) {
                this.gb = new ProcGraphBuilder((ProcessEngine)this.engine);
            } else {
                this.gb.reset();
            }
            boolean bl = this.gb.buildGraph(this, n, n2);
            this.gb = null;
            return bl;
        }

        private Format checkSize(Format format) {
            Format format2;
            if (!(format instanceof VideoFormat)) {
                return format;
            }
            VideoFormat videoFormat = (VideoFormat)format;
            Dimension dimension = ((VideoFormat)format).getSize();
            if (dimension == null && ((format2 = this.getOriginalFormat()) == null || (dimension = ((VideoFormat)format2).getSize()) == null)) {
                return format;
            }
            int n = dimension.width;
            int n2 = dimension.height;
            if (format.matches(new VideoFormat("jpeg/rtp")) || format.matches(new VideoFormat("jpeg"))) {
                if (dimension.width % 8 != 0) {
                    n = dimension.width / 8 * 8;
                }
                if (dimension.height % 8 != 0) {
                    n2 = dimension.height / 8 * 8;
                }
                if (n == 0 || n2 == 0) {
                    n = dimension.width;
                    n2 = dimension.height;
                }
            } else if (format.matches(new VideoFormat("h263/rtp")) || format.matches(new VideoFormat("h263-1998/rtp")) || format.matches(new VideoFormat("h263"))) {
                if (dimension.width >= 352) {
                    n = 352;
                    n2 = 288;
                } else if (dimension.width >= 160) {
                    n = 176;
                    n2 = 144;
                } else {
                    n = 128;
                    n2 = 96;
                }
            }
            if (n != dimension.width || n2 != dimension.height) {
                Log.comment("setFormat: " + format.getEncoding() + ": video aspect ratio mismatched.");
                Log.comment("  Scaled from " + dimension.width + "x" + dimension.height + " to " + n + "x" + n2 + ".\n");
                format = new VideoFormat(null, new Dimension(n, n2), -1, null, -1.0f).intersects(format);
            }
            return format;
        }

        protected FrameRateControl frameRateControl() {
            this.muxModule = ProcessEngine.this.getMuxModule();
            return ProcessEngine.this.frameRateControl;
        }

        public Format getFormat() {
            return this.formatWanted == null ? this.track.getFormat() : this.formatWanted;
        }

        public Object getOwner() {
            return ProcessEngine.this.player;
        }

        public Format[] getSupportedFormats() {
            if (this.supportedFormats == null && (this.supportedFormats = Resource.getDB(this.track.getFormat())) == null) {
                if (this.gb == null) {
                    this.gb = new ProcGraphBuilder((ProcessEngine)this.engine);
                } else {
                    this.gb.reset();
                }
                this.supportedFormats = this.gb.getSupportedOutputFormats(this.track.getFormat());
                this.supportedFormats = Resource.putDB(this.track.getFormat(), this.supportedFormats);
                PlaybackEngine.needSavingDB = true;
            }
            if (ProcessEngine.this.outputContentDes != null) {
                return this.verifyMuxInputs(ProcessEngine.this.outputContentDes, this.supportedFormats);
            }
            return this.supportedFormats;
        }

        public boolean isCustomized() {
            return this.formatWanted != null || this.codecChainWanted != null || this.rendererWanted != null;
        }

        public boolean isTimeBase() {
            for (int i = 0; i < this.modules.size(); ++i) {
                if (this.modules.elementAt(i) != ProcessEngine.this.masterSink) continue;
                return true;
            }
            return false;
        }

        public void prError() {
            if (!this.isCustomized()) {
                super.prError();
                return;
            }
            Log.error("  Cannot build a flow graph with the customized options:");
            if (this.formatWanted != null) {
                Log.error("    Unable to transcode format: " + this.getOriginalFormat());
                Log.error("      to: " + this.getFormat());
                if (ProcessEngine.this.outputContentDes != null) {
                    Log.error("      outputting to: " + ProcessEngine.this.outputContentDes);
                }
            }
            if (this.codecChainWanted != null) {
                Log.error("    Unable to add customed codecs: ");
                for (int i = 0; i < this.codecChainWanted.length; ++i) {
                    Log.error("      " + this.codecChainWanted[i]);
                }
            }
            if (this.rendererWanted != null) {
                Log.error("    Unable to add customed renderer: " + this.rendererWanted);
            }
            Log.write("\n");
        }

        protected ProgressControl progressControl() {
            return ProcessEngine.this.progressControl;
        }

        public void setCodecChain(Codec[] codecArray) throws NotConfiguredError, UnsupportedPlugInException {
            if (this.engine.getState() > 180) {
                ProcessEngine.this.throwError(new NotConfiguredError("Cannot set a PlugIn before reaching the configured state."));
            }
            if (codecArray.length < 1) {
                throw new UnsupportedPlugInException("No codec specified in the array.");
            }
            this.codecChainWanted = new Codec[codecArray.length];
            for (int i = 0; i < codecArray.length; ++i) {
                this.codecChainWanted[i] = codecArray[i];
            }
        }

        public Format setFormat(Format format) {
            if (this.engine.getState() > 180) {
                return this.getFormat();
            }
            if (format == null || format.matches(this.track.getFormat())) {
                return format;
            }
            this.formatWanted = this.checkSize(format);
            return this.formatWanted;
        }

        public void setRenderer(Renderer renderer) throws NotConfiguredError {
            if (this.engine.getState() > 180) {
                ProcessEngine.this.throwError(new NotConfiguredError("Cannot set a PlugIn before reaching the configured state."));
            }
            this.rendererWanted = renderer;
            if (renderer instanceof SlowPlugIn) {
                ((SlowPlugIn)((Object)renderer)).forceToUse();
            }
        }

        Format[] verifyMuxInputs(ContentDescriptor contentDescriptor, Format[] formatArray) {
            if (contentDescriptor == null || contentDescriptor.getEncoding() == "raw") {
                return formatArray;
            }
            Vector vector = PlugInManager.getPlugInList(null, contentDescriptor, 5);
            if (vector == null || vector.size() == 0) {
                return new Format[0];
            }
            Multiplexer[] multiplexerArray = new Multiplexer[vector.size()];
            int n = 0;
            for (int i = 0; i < vector.size(); ++i) {
                Multiplexer multiplexer = (Multiplexer)SimpleGraphBuilder.createPlugIn((String)vector.elementAt(i), 5);
                if (multiplexer == null) continue;
                try {
                    multiplexer.setContentDescriptor(ProcessEngine.this.outputContentDes);
                }
                catch (Exception exception) {
                    continue;
                }
                if (multiplexer.setNumTracks(1) < 1) continue;
                multiplexerArray[n++] = multiplexer;
            }
            Format[] formatArray2 = new Format[formatArray.length];
            int n2 = 0;
            block3: for (int i = 0; i < formatArray.length; ++i) {
                Format format;
                if (n == 1) {
                    format = multiplexerArray[0].setInputFormat(formatArray[i], 0);
                    if (format == null) continue;
                    formatArray2[n2++] = format;
                    continue;
                }
                for (int j = 0; j < n; ++j) {
                    format = multiplexerArray[j].setInputFormat(formatArray[i], 0);
                    if (format == null) continue;
                    formatArray2[n2++] = format;
                    continue block3;
                }
            }
            Format[] formatArray3 = new Format[n2];
            System.arraycopy(formatArray2, 0, formatArray3, 0, n2);
            return formatArray3;
        }
    }

    class ProcGraphBuilder
    extends SimpleGraphBuilder {
        protected ProcessEngine engine;
        protected Format targetFormat;
        protected int trackID = 0;
        protected int numTracks = 1;
        protected int nodesVisited = 0;
        Codec[] codecs = null;
        Renderer rend = null;
        Format format = null;

        ProcGraphBuilder(ProcessEngine processEngine2) {
            this.engine = processEngine2;
        }

        GraphNode buildCustomGraph(Format format) {
            Vector<GraphNode> vector = new Vector<GraphNode>();
            Object var4_3 = null;
            GraphNode graphNode = new GraphNode(null, null, format, null, 0);
            vector.addElement(graphNode);
            Log.comment("Custom options specified.");
            this.indent = 1;
            Log.setIndent(this.indent);
            if (this.codecs != null) {
                this.resetTargets();
                for (int i = 0; i < this.codecs.length; ++i) {
                    if (this.codecs[i] == null) continue;
                    Log.comment("A custom codec is specified: " + this.codecs[i]);
                    this.setTargetPlugin(this.codecs[i], 2);
                    graphNode = this.buildGraph(vector);
                    if (graphNode == null) {
                        Log.error("The input format is not compatible with the given codec plugin: " + this.codecs[i]);
                        this.indent = 0;
                        Log.setIndent(this.indent);
                        return null;
                    }
                    graphNode.level = 0;
                    vector = new Vector();
                    vector.addElement(graphNode);
                }
            }
            if (ProcessEngine.this.outputContentDes != null) {
                this.resetTargets();
                if (this.format != null) {
                    this.targetFormat = this.format;
                    Log.comment("An output format is specified: " + this.format);
                }
                if (!this.setDefaultTargetMux()) {
                    return null;
                }
                graphNode = this.buildGraph(vector);
                if (graphNode == null) {
                    Log.error("Failed to build a graph for the given custom options.");
                    this.indent = 0;
                    Log.setIndent(this.indent);
                    return null;
                }
            } else {
                if (this.format != null) {
                    this.resetTargets();
                    this.targetFormat = this.format;
                    Log.comment("An output format is specified: " + this.format);
                    graphNode = this.buildGraph(vector);
                    if (graphNode == null) {
                        Log.error("The input format cannot be transcoded to the specified target format.");
                        this.indent = 0;
                        Log.setIndent(this.indent);
                        return null;
                    }
                    graphNode.level = 0;
                    vector = new Vector();
                    vector.addElement(graphNode);
                    this.targetFormat = null;
                }
                if (this.rend != null) {
                    Log.comment("A custom renderer is specified: " + this.rend);
                    this.setTargetPlugin(this.rend, 4);
                    graphNode = this.buildGraph(vector);
                    if (graphNode == null) {
                        if (this.format != null) {
                            Log.error("The customed transocoded format is not compatible with the given renderer plugin: " + this.rend);
                        } else {
                            Log.error("The input format is not compatible with the given renderer plugin: " + this.rend);
                        }
                        this.indent = 0;
                        Log.setIndent(this.indent);
                        return null;
                    }
                } else {
                    if (!this.setDefaultTargetRenderer(this.format == null ? format : this.format)) {
                        return null;
                    }
                    graphNode = this.buildGraph(vector);
                    if (graphNode == null) {
                        if (this.format != null) {
                            Log.error("Failed to find a renderer that supports the customed transcoded format.");
                        } else {
                            Log.error("Failed to build a graph to render the input format with the given custom options.");
                        }
                        this.indent = 0;
                        Log.setIndent(this.indent);
                        return null;
                    }
                }
            }
            this.indent = 0;
            Log.setIndent(this.indent);
            return graphNode;
        }

        boolean buildCustomGraph(ProcTControl procTControl) {
            Object object;
            Object object2;
            this.codecs = procTControl.codecChainWanted;
            this.rend = procTControl.rendererWanted;
            this.format = procTControl.formatWanted;
            if (this.format instanceof VideoFormat && procTControl.getOriginalFormat() instanceof VideoFormat) {
                object2 = ((VideoFormat)procTControl.getOriginalFormat()).getSize();
                object = ((VideoFormat)this.format).getSize();
                if (object2 != null && object != null && !((Dimension)object2).equals(object)) {
                    RGBScaler rGBScaler = new RGBScaler((Dimension)object);
                    if (this.codecs == null || this.codecs.length == 0) {
                        this.codecs = new Codec[1];
                        this.codecs[0] = rGBScaler;
                    } else {
                        int n;
                        this.codecs = new Codec[procTControl.codecChainWanted.length + 1];
                        if (!PlaybackEngine.isRawVideo(this.format)) {
                            this.codecs[0] = rGBScaler;
                            n = 1;
                        } else {
                            this.codecs[procTControl.codecChainWanted.length] = rGBScaler;
                            n = 0;
                        }
                        for (int i = 0; i < procTControl.codecChainWanted.length; ++i) {
                            this.codecs[n++] = procTControl.codecChainWanted[i];
                        }
                    }
                }
            }
            return (object2 = this.buildCustomGraph(procTControl.getOriginalFormat())) != null && (object = this.buildTrackFromGraph(procTControl, (GraphNode)object2)) == null;
        }

        boolean buildGraph(BasicTrackControl basicTrackControl, int n, int n2) {
            this.trackID = n;
            this.numTracks = n2;
            if (basicTrackControl.isCustomized()) {
                Log.comment("Input: " + basicTrackControl.getOriginalFormat());
                return this.buildCustomGraph((ProcTControl)basicTrackControl);
            }
            return super.buildGraph(basicTrackControl);
        }

        protected GraphNode buildTrackFromGraph(BasicTrackControl basicTrackControl, GraphNode graphNode) {
            return this.engine.buildTrackFromGraph(basicTrackControl, graphNode);
        }

        void doGetSupportedOutputFormats(Vector vector, Vector vector2) {
            Format format;
            Format[] formatArray;
            GraphNode graphNode = (GraphNode)vector.firstElement();
            vector.removeElementAt(0);
            if (!(graphNode.input != null || graphNode.plugin != null && graphNode.plugin instanceof Codec)) {
                Log.error("Internal error: doGetSupportedOutputFormats");
                return;
            }
            if (graphNode.plugin != null && ProcGraphBuilder.verifyInput(graphNode.plugin, graphNode.input) == null) {
                return;
            }
            if (graphNode.plugin != null) {
                formatArray = graphNode.getSupportedOutputs(graphNode.input);
                if (formatArray == null || formatArray.length == 0) {
                    return;
                }
                for (int i = 0; i < formatArray.length; ++i) {
                    int n = vector2.size();
                    boolean bl = false;
                    for (int j = 0; j < n; ++j) {
                        Format format2 = (Format)vector2.elementAt(j);
                        if (format2 != formatArray[i] && !format2.equals(formatArray[i])) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    vector2.addElement(formatArray[i]);
                }
                format = graphNode.input;
            } else {
                formatArray = new Format[]{graphNode.input};
                format = null;
            }
            if (graphNode.level >= this.STAGES) {
                return;
            }
            for (int i = 0; i < formatArray.length; ++i) {
                Vector vector3;
                if (format != null && format.equals(formatArray[i]) || graphNode.plugin != null && ProcGraphBuilder.verifyOutput(graphNode.plugin, formatArray[i]) == null || (vector3 = PlugInManager.getPlugInList(formatArray[i], null, 2)) == null || vector3.size() == 0) continue;
                for (int j = 0; j < vector3.size(); ++j) {
                    Format[] formatArray2;
                    Format format3;
                    GraphNode graphNode2 = ProcGraphBuilder.getPlugInNode((String)vector3.elementAt(j), 2, this.plugIns);
                    if (graphNode2 == null || graphNode2.checkAttempted(formatArray[i]) || (format3 = ProcGraphBuilder.matches(formatArray[i], formatArray2 = graphNode2.getSupportedInputs(), null, graphNode2.plugin)) == null) continue;
                    GraphNode graphNode3 = new GraphNode(graphNode2, format3, graphNode, graphNode.level + 1);
                    vector.addElement(graphNode3);
                    ++this.nodesVisited;
                }
            }
        }

        protected GraphNode findTarget(GraphNode graphNode) {
            Object object;
            Format[] formatArray;
            if (graphNode.plugin == null) {
                formatArray = new Format[]{graphNode.input};
            } else if (graphNode.output != null) {
                formatArray = new Format[]{graphNode.output};
            } else {
                formatArray = graphNode.getSupportedOutputs(graphNode.input);
                if (formatArray == null || formatArray.length == 0) {
                    return null;
                }
            }
            if (this.targetFormat != null) {
                object = null;
                object = ProcGraphBuilder.matches(formatArray, this.targetFormat, graphNode.plugin, null);
                if (object == null) {
                    return null;
                }
                if (inspector != null && !inspector.verify((Codec)graphNode.plugin, graphNode.input, (Format)object)) {
                    return null;
                }
                if (this.targetPlugins == null && ProcessEngine.this.targetMuxes == null) {
                    graphNode.output = object;
                    return graphNode;
                }
                formatArray = new Format[]{object};
            }
            if (this.targetPlugins != null) {
                object = this.verifyTargetPlugins(graphNode, formatArray);
                if (object != null) {
                    return object;
                }
                return null;
            }
            if (ProcessEngine.this.targetMuxes != null && (object = this.verifyTargetMuxes(graphNode, formatArray)) != null) {
                return object;
            }
            return null;
        }

        public Format[] getSupportedOutputFormats(Format format) {
            long l = System.currentTimeMillis();
            Vector<Format> vector = new Vector<Format>();
            Vector<GraphNode> vector2 = new Vector<GraphNode>();
            GraphNode graphNode = new GraphNode(null, null, format, null, 0);
            vector2.addElement(graphNode);
            vector.addElement(format);
            ++this.nodesVisited;
            while (!vector2.isEmpty()) {
                this.doGetSupportedOutputFormats(vector2, vector);
            }
            Format[] formatArray = new Format[vector.size()];
            int n = 0;
            int n2 = formatArray.length - 1;
            AudioFormat audioFormat = new AudioFormat("mpegaudio/rtp");
            boolean bl = new AudioFormat("mpegaudio").matches(format) || new AudioFormat("mpeglayer3").matches(format) || new VideoFormat("mpeg").matches(format);
            for (int i = 0; i < formatArray.length; ++i) {
                Object e = vector.elementAt(i);
                if (!bl && ((Format)audioFormat).matches((Format)e)) {
                    formatArray[n2--] = (Format)e;
                    continue;
                }
                formatArray[n++] = (Format)e;
            }
            Log.comment("Getting the supported output formats for:");
            Log.comment("  " + format);
            Log.comment("  # of nodes visited: " + this.nodesVisited);
            Log.comment("  # of formats supported: " + formatArray.length + "\n");
            PlaybackEngine.profile("getSupportedOutputFormats", l);
            return formatArray;
        }

        public void reset() {
            super.reset();
            this.resetTargets();
        }

        void resetTargets() {
            this.targetFormat = null;
            this.targetPlugins = null;
        }

        boolean setDefaultTargetMux() {
            if (ProcessEngine.this.targetMuxes != null) {
                return true;
            }
            Log.comment("An output content type is specified: " + ProcessEngine.this.outputContentDes);
            ProcessEngine.this.targetMuxNames = PlugInManager.getPlugInList(null, ProcessEngine.this.outputContentDes, 5);
            if (ProcessEngine.this.targetMuxNames == null || ProcessEngine.this.targetMuxNames.size() == 0) {
                Log.error("No multiplexer is found for that content type: " + ProcessEngine.this.outputContentDes);
                return false;
            }
            ProcessEngine.this.targetMuxes = new GraphNode[ProcessEngine.this.targetMuxNames.size()];
            ProcessEngine.this.targetMux = null;
            ProcessEngine.this.targetMuxFormats = new Format[this.numTracks];
            this.targetPluginNames = null;
            this.targetPlugins = null;
            return true;
        }

        protected boolean setDefaultTargetRenderer(Format format) {
            if (!super.setDefaultTargetRenderer(format)) {
                return false;
            }
            ProcessEngine.this.targetMuxes = null;
            return true;
        }

        protected boolean setDefaultTargets(Format format) {
            if (ProcessEngine.this.outputContentDes != null) {
                return this.setDefaultTargetMux();
            }
            return this.setDefaultTargetRenderer(format);
        }

        void setTargetPlugin(PlugIn plugIn, int n) {
            this.targetPlugins = new GraphNode[1];
            this.targetPlugins[0] = new GraphNode(plugIn, null, null, 0);
            this.targetPlugins[0].custom = true;
            this.targetPlugins[0].type = n;
        }

        GraphNode verifyTargetMuxes(GraphNode graphNode, Format[] formatArray) {
            for (int i = 0; i < ProcessEngine.this.targetMuxes.length; ++i) {
                GraphNode graphNode2 = ProcessEngine.this.targetMuxes[i];
                if (graphNode2 == null) {
                    String string = (String)ProcessEngine.this.targetMuxNames.elementAt(i);
                    if (string == null) continue;
                    graphNode2 = ProcGraphBuilder.getPlugInNode(string, 5, this.plugIns);
                    if (graphNode2 == null) {
                        ProcessEngine.this.targetMuxNames.setElementAt(null, i);
                        continue;
                    }
                    Multiplexer multiplexer = (Multiplexer)graphNode2.plugin;
                    if (multiplexer.setContentDescriptor(ProcessEngine.this.outputContentDes) == null) {
                        ProcessEngine.this.targetMuxNames.setElementAt(null, i);
                        continue;
                    }
                    if (multiplexer.setNumTracks(this.numTracks) != this.numTracks) {
                        ProcessEngine.this.targetMuxNames.setElementAt(null, i);
                        continue;
                    }
                    ProcessEngine.this.targetMuxes[i] = graphNode2;
                }
                if (ProcessEngine.this.targetMux != null && graphNode2 != ProcessEngine.this.targetMux) continue;
                for (int j = 0; j < formatArray.length; ++j) {
                    Format format = ((Multiplexer)graphNode2.plugin).setInputFormat(formatArray[j], this.trackID);
                    if (format == null || inspector != null && graphNode.plugin != null && !inspector.verify((Codec)graphNode.plugin, graphNode.input, format)) continue;
                    ProcessEngine.this.targetMux = graphNode2;
                    ProcessEngine.this.targetMuxFormats[this.trackID] = format;
                    graphNode.output = format;
                    return graphNode;
                }
            }
            return null;
        }
    }
}

