/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;
import net.sf.fmj.ejmf.toolkit.util.SourcedTimerEvent;
import net.sf.fmj.ejmf.toolkit.util.SourcedTimerListener;
import net.sf.fmj.ejmf.toolkit.util.TimeSource;

public class SourcedTimer
implements ActionListener {
    protected static int _defaultGran = 1000;
    private TimeSource source;
    private Timer baseTimer;
    private EventListenerList listenerList = null;
    private SourcedTimerEvent event;
    private boolean started = false;
    private Object[] listeners;

    public SourcedTimer(TimeSource timeSource) {
        this(timeSource, _defaultGran);
    }

    public SourcedTimer(TimeSource timeSource, int n) {
        this.source = timeSource;
        this.event = new SourcedTimerEvent(this, 0L);
        this.baseTimer = new Timer(n, this);
        this.baseTimer.setInitialDelay(0);
    }

    public SourcedTimer(TimeSource timeSource, Timer timer) {
        this.source = timeSource;
        this.event = new SourcedTimerEvent(this, 0L);
        this.baseTimer = timer;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.runNotifyThread(this.source.getTime());
    }

    public void addSourcedTimerListener(SourcedTimerListener sourcedTimerListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(SourcedTimerListener.class, sourcedTimerListener);
    }

    public long getConversionDivisor() {
        return this.source.getConversionDivisor();
    }

    private void runNotifyThread(long l) {
        this.event.setTime(l);
        this.listeners = this.listenerList.getListenerList();
        Thread thread = new Thread("SourcedTimer Notify Thread"){

            public void run() {
                for (int i = SourcedTimer.this.listeners.length - 2; i >= 0; i -= 2) {
                    if (SourcedTimer.this.listeners[i] != SourcedTimerListener.class) continue;
                    ((SourcedTimerListener)SourcedTimer.this.listeners[i + 1]).timerUpdate(SourcedTimer.this.event);
                }
            }
        };
        thread.start();
    }

    public void start() {
        if (!this.started) {
            this.baseTimer.start();
            this.runNotifyThread(0L);
        }
    }

    public void stop() {
        this.started = false;
        this.baseTimer.stop();
        this.runNotifyThread(this.source.getTime());
    }
}

