/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.gui.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.media.Control;
import javax.media.Controller;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.StartEvent;
import javax.media.StopEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import net.sf.fmj.ejmf.toolkit.util.SourcedTimer;
import net.sf.fmj.ejmf.toolkit.util.SourcedTimerEvent;
import net.sf.fmj.ejmf.toolkit.util.SourcedTimerListener;
import net.sf.fmj.ejmf.toolkit.util.TimeSource;

public class TimeDisplayControl
implements Control,
SourcedTimerListener,
TimeSource,
ControllerListener {
    private JLabel timerField = new JLabel("0:00:00", 4);
    private JPanel controlComponent = new JPanel();
    private String timeVal;
    private SourcedTimer timer;
    private Controller controller;
    private long divisor;

    public TimeDisplayControl(Controller controller) {
        this.controller = controller;
        this.timer = new SourcedTimer(this);
        this.timer.addSourcedTimerListener(this);
        this.divisor = this.timer.getConversionDivisor();
        controller.addControllerListener(this);
        this.setUpControlComponent();
        this.timeVal = this.convertTime(this.getTime(), this.divisor);
        this.loadTime();
    }

    public TimeDisplayControl(Controller controller, SourcedTimer sourcedTimer) {
        this.controller = controller;
        this.timer = sourcedTimer;
        sourcedTimer.addSourcedTimerListener(this);
        this.divisor = sourcedTimer.getConversionDivisor();
        controller.addControllerListener(this);
        this.setUpControlComponent();
        this.timeVal = this.convertTime(this.getTime(), this.divisor);
        this.loadTime();
    }

    public void controllerUpdate(ControllerEvent controllerEvent) {
        if (controllerEvent instanceof StopEvent || controllerEvent instanceof ControllerErrorEvent) {
            this.timer.stop();
        } else if (controllerEvent instanceof StartEvent) {
            this.timer.start();
        }
    }

    private String convertTime(long l, long l2) {
        int n = 0;
        int n2 = 0;
        long l3 = l / l2;
        n2 = (int)(l3 / 60L);
        if (n2 > 0) {
            if (n2 > 60) {
                n = n2 / 60;
                n2 %= 60;
            }
            l3 %= 60L;
        }
        String string = n + ":";
        string = n2 < 10 ? string + 0 + n2 + ":" : string + n2 + ":";
        string = l3 < 10L ? string + 0 + l3 : string + l3;
        return string;
    }

    public Component getControlComponent() {
        return this.controlComponent;
    }

    public long getConversionDivisor() {
        return 1000000000L;
    }

    public long getTime() {
        return this.controller.getMediaNanoseconds();
    }

    private void loadTime() {
        this.timerField.setText(this.timeVal);
    }

    private void setUpControlComponent() {
        JLabel jLabel = new JLabel("Media Time:", 4);
        JPanel jPanel = new JPanel();
        int n = 10;
        EmptyBorder emptyBorder = new EmptyBorder(n, n, n, n);
        CompoundBorder compoundBorder = new CompoundBorder(new EtchedBorder(), emptyBorder);
        TitledBorder titledBorder = new TitledBorder(compoundBorder, "Time Display Control");
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new BorderLayout(n, n));
        jPanel.add((Component)jLabel, "Center");
        jPanel.add((Component)this.timerField, "East");
        this.controlComponent.add(jPanel);
    }

    public void timerUpdate(SourcedTimerEvent sourcedTimerEvent) {
        this.timeVal = this.convertTime(this.getTime(), this.divisor);
        SwingUtilities.invokeLater(new LoadTimeThread());
    }

    class LoadTimeThread
    implements Runnable {
        LoadTimeThread() {
        }

        public void run() {
            TimeDisplayControl.this.loadTime();
        }
    }
}

