/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.apps.mediaserver;

import fi.iki.elonen.nanohttpd.NanoHTTPD;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.DataSink;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Processor;
import javax.media.ProcessorModel;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.FileTypeDescriptor;
import net.sf.fmj.apps.mediaserver.StreamDataSink;
import net.sf.fmj.utility.FormatArgUtils;
import net.sf.fmj.utility.LoggerSingleton;

public class MediaHTTPD
extends NanoHTTPD {
    private static final Logger logger = LoggerSingleton.logger;

    public MediaHTTPD(int n) throws IOException {
        super(n);
    }

    private InputStream getInputStream(String string, Format format, ContentDescriptor contentDescriptor) throws Exception {
        Format[] formatArray;
        MediaLocator mediaLocator = new MediaLocator(string);
        if (format == null) {
            formatArray = null;
        } else {
            Format[] formatArray2 = new Format[1];
            formatArray = formatArray2;
            formatArray2[0] = format;
        }
        ProcessorModel processorModel = new ProcessorModel(mediaLocator, formatArray, contentDescriptor);
        final Processor processor = Manager.createRealizedProcessor(processorModel);
        DataSource dataSource = processor.getDataOutput();
        final DataSink[] dataSinkArray = new DataSink[]{null};
        PipedInputStream pipedInputStream = new PipedInputStream(){

            public void close() throws IOException {
                super.close();
                logger.fine("Closed input stream");
                logger.fine("Stopping processor");
                processor.stop();
                logger.fine("Closing processor");
                processor.close();
                logger.fine("Deallocating processor");
                processor.deallocate();
                if (dataSinkArray[0] != null) {
                    logger.fine("Closing StreamDataSink");
                    dataSinkArray[0].close();
                }
            }
        };
        PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
        StreamDataSink streamDataSink = new StreamDataSink(pipedOutputStream);
        dataSinkArray[0] = streamDataSink;
        streamDataSink.setSource(dataSource);
        streamDataSink.open();
        streamDataSink.start();
        logger.info("Starting processor");
        processor.start();
        return pipedInputStream;
    }

    public NanoHTTPD.Response serve(String string, String string2, Properties properties, Properties properties2) {
        InputStream inputStream;
        Format format;
        String string3;
        if (!string.equals("/mediaserver")) {
            return super.serve(string, string2, properties, properties2);
        }
        logger.fine(string2 + " '" + string + "' ");
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            logger.fine("  HDR: '" + string3 + "' = '" + properties.getProperty(string3) + "'");
        }
        enumeration = properties2.propertyNames();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            logger.fine("  PRM: '" + string3 + "' = '" + properties2.getProperty(string3) + "'");
        }
        string3 = properties2.getProperty("media");
        String string4 = properties2.getProperty("format");
        String string5 = properties2.getProperty("mime");
        logger.info("requested media: " + string3);
        logger.info("requested mime type: " + string5);
        if (string3 == null) {
            return (NanoHTTPD)this.new NanoHTTPD.Response("403 Forbidden", "text/plain", "mediaPath parameter not specified");
        }
        if (string5 == null) {
            return (NanoHTTPD)this.new NanoHTTPD.Response("403 Forbidden", "text/plain", "mimeType parameter not specified");
        }
        String string6 = string3;
        FileTypeDescriptor fileTypeDescriptor = new FileTypeDescriptor(ContentDescriptor.mimeTypeToPackageName(string5));
        if (string4 == null) {
            format = null;
        } else {
            try {
                format = FormatArgUtils.parse(string4);
            }
            catch (ParseException parseException) {
                logger.log(Level.WARNING, "" + parseException, parseException);
                return (NanoHTTPD)this.new NanoHTTPD.Response("403 Forbidden", "text/plain", "" + parseException);
            }
        }
        logger.info("serverSideUrlStr: " + string6);
        logger.info("outputContentDescriptor: " + fileTypeDescriptor);
        logger.info("outputFormat: " + format);
        try {
            inputStream = this.getInputStream(string6, format, fileTypeDescriptor);
        }
        catch (Exception exception) {
            return (NanoHTTPD)this.new NanoHTTPD.Response("403 Forbidden", "text/plain", "" + exception);
        }
        String string7 = string5.equals("multipart/x-mixed-replace") ? string5 + ";boundary=" + "--ssBoundaryFMJ" : string5;
        logger.info("Response mime type: " + string7);
        return (NanoHTTPD)this.new NanoHTTPD.Response("200 OK", string7, inputStream);
    }
}

