/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import net.java.sip.communicator.impl.protocol.jabber.JingleNodesCandidate;
import net.java.sip.communicator.util.Logger;
import org.ice4j.TransportAddress;
import org.ice4j.socket.StunDatagramPacketFilter;
import org.ice4j.stack.StunStack;

public class JingleNodesCandidateDatagramSocket
extends DatagramSocket {
    private static final Logger logger = Logger.getLogger(JingleNodesCandidateDatagramSocket.class);
    private TransportAddress localEndPoint = null;
    private JingleNodesCandidate jingleNodesCandidate;
    private long nbReceivedRtpPackets = 0L;
    private long nbSentRtpPackets = 0L;
    private long nbLostRtpPackets = 0L;
    private long lastRtpSequenceNumber = -1L;
    private long lastLostPacketLogTime = 0L;

    private static boolean logPacket(long numOfPacket) {
        return numOfPacket == 1L || numOfPacket == 300L || numOfPacket == 500L || numOfPacket == 1000L || numOfPacket % 5000L == 0L;
    }

    private static long logRtpLosses(long totalNbLost, long totalNbReceived, long lastLogTime) {
        long currentTime;
        double percentLost = (double)totalNbLost / (double)(totalNbLost + totalNbReceived);
        if (percentLost > 0.05 && (currentTime = System.currentTimeMillis()) - lastLogTime >= 5000L) {
            logger.info((Object)("RTP lost > 5%: " + percentLost));
            return currentTime;
        }
        return lastLogTime;
    }

    private static long getNbLost(long lastRtpSequenceNumber, long newSeq) {
        long newNbLost = 0L;
        newNbLost = lastRtpSequenceNumber <= newSeq ? newSeq - lastRtpSequenceNumber : 65535L - lastRtpSequenceNumber + newSeq;
        if (newNbLost > 1L) {
            if (newNbLost < 255L) {
                return newNbLost - 1L;
            }
            return 1L;
        }
        return 0L;
    }

    private static long getRtpSequenceNumber(DatagramPacket p) {
        byte[] data = p.getData();
        int offset = p.getOffset();
        long seq_high = data[offset + 2] & 0xFF;
        long seq_low = data[offset + 3] & 0xFF;
        return seq_high << 8 | seq_low;
    }

    public JingleNodesCandidateDatagramSocket(JingleNodesCandidate jingleNodesCandidate, TransportAddress localEndPoint) throws SocketException {
        super((SocketAddress)null);
        this.jingleNodesCandidate = jingleNodesCandidate;
        this.localEndPoint = localEndPoint;
    }

    @Override
    public void send(DatagramPacket p) throws IOException {
        byte[] data = p.getData();
        int dataLen = p.getLength();
        int dataOffset = p.getOffset();
        DatagramPacket packet = new DatagramPacket(data, dataOffset, dataLen, new InetSocketAddress(this.localEndPoint.getAddress(), this.localEndPoint.getPort()));
        super.send(packet);
        if (JingleNodesCandidateDatagramSocket.logPacket(++this.nbSentRtpPackets)) {
            StunStack.logPacketToPcap((DatagramPacket)packet, (boolean)true, (InetAddress)super.getLocalAddress(), (int)super.getLocalPort());
        }
    }

    @Override
    public void receive(DatagramPacket p) throws IOException {
        super.receive(p);
        if (JingleNodesCandidateDatagramSocket.logPacket(++this.nbReceivedRtpPackets)) {
            StunStack.logPacketToPcap((DatagramPacket)p, (boolean)false, (InetAddress)super.getLocalAddress(), (int)super.getLocalPort());
        }
        this.updateRtpLosses(p);
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.getLocalSocketAddress().getAddress();
    }

    @Override
    public int getLocalPort() {
        return this.getLocalSocketAddress().getPort();
    }

    @Override
    public InetSocketAddress getLocalSocketAddress() {
        return this.jingleNodesCandidate.getTransportAddress();
    }

    private void updateRtpLosses(DatagramPacket p) {
        if (!StunDatagramPacketFilter.isStunPacket((DatagramPacket)p)) {
            long newSeq = JingleNodesCandidateDatagramSocket.getRtpSequenceNumber(p);
            if (this.lastRtpSequenceNumber != -1L) {
                this.nbLostRtpPackets += JingleNodesCandidateDatagramSocket.getNbLost(this.lastRtpSequenceNumber, newSeq);
            }
            this.lastRtpSequenceNumber = newSeq;
            this.lastLostPacketLogTime = JingleNodesCandidateDatagramSocket.logRtpLosses(this.nbLostRtpPackets, this.nbReceivedRtpPackets, this.lastLostPacketLogTime);
        }
    }
}

