/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.rest;

import java.io.File;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.util.ConfigUtils;
import org.jitsi.videobridge.rest.MuxServerConnector;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJettyBundleActivator
implements BundleActivator {
    private static final String JETTY_HOST_PNAME = ".jetty.host";
    private static final String JETTY_PORT_PNAME = ".jetty.port";
    private static final String JETTY_SSLCONTEXTFACTORY_KEYSTOREPASSWORD = ".jetty.sslContextFactory.keyStorePassword";
    private static final String JETTY_SSLCONTEXTFACTORY_KEYSTOREPATH = ".jetty.sslContextFactory.keyStorePath";
    private static final String JETTY_SSLCONTEXTFACTORY_NEEDCLIENTAUTH = ".jetty.sslContextFactory.needClientAuth";
    private static final String JETTY_TLS_PORT_PNAME = ".jetty.tls.port";
    private static final Logger logger = Logger.getLogger(AbstractJettyBundleActivator.class);
    protected ConfigurationService cfg;
    protected final String propertyPrefix;
    protected Server server;

    protected static Handler initializeHandlerList(List<Handler> handlers) {
        int handlerCount = handlers.size();
        if (handlerCount == 1) {
            return handlers.get(0);
        }
        HandlerList handlerList = new HandlerList();
        handlerList.setHandlers(handlers.toArray(new Handler[handlerCount]));
        return handlerList;
    }

    protected AbstractJettyBundleActivator(String propertyPrefix) {
        this.propertyPrefix = propertyPrefix;
    }

    protected void didStart(BundleContext bundleContext) throws Exception {
    }

    protected void didStop(BundleContext bundleContext) throws Exception {
    }

    protected void doStart(BundleContext bundleContext) throws Exception {
        try {
            Server server = this.initializeServer(bundleContext);
            server.start();
            this.server = server;
        }
        catch (Throwable t) {
            logger.error((Object)"Failed to initialize and/or start a new Jetty HTTP(S) server instance.", t);
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new UndeclaredThrowableException(t);
        }
    }

    protected void doStop(BundleContext bundleContext) throws Exception {
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
    }

    protected boolean getCfgBoolean(String property, boolean defaultValue) {
        String s;
        property = this.prefixProperty(property);
        ConfigurationService cfg = this.cfg;
        boolean b = cfg == null ? ((s = System.getProperty(property)) == null || s.length() == 0 ? defaultValue : Boolean.parseBoolean(s)) : cfg.getBoolean(property, defaultValue);
        return b;
    }

    protected int getCfgInt(String property, int defaultValue) {
        int i;
        property = this.prefixProperty(property);
        ConfigurationService cfg = this.cfg;
        if (cfg == null) {
            String s = System.getProperty(property);
            if (s == null || s.length() == 0) {
                i = defaultValue;
            } else {
                try {
                    i = Integer.parseInt(s);
                }
                catch (NumberFormatException nfe) {
                    i = defaultValue;
                }
            }
        } else {
            i = cfg.getInt(property, defaultValue);
        }
        return i;
    }

    protected String getCfgString(String property, String defaultValue) {
        property = this.prefixProperty(property);
        ConfigurationService cfg = this.cfg;
        String s = cfg == null ? System.getProperty(property, defaultValue) : cfg.getString(property, defaultValue);
        return s;
    }

    protected int getDefaultPort() {
        return 8080;
    }

    protected int getDefaultTlsPort() {
        return 8443;
    }

    protected Handler initializeHandler(BundleContext bundleContext, Server server) throws Exception {
        return this.initializeHandlerList(bundleContext, server);
    }

    protected abstract Handler initializeHandlerList(BundleContext var1, Server var2) throws Exception;

    protected Server initializeServer(BundleContext bundleContext) throws Exception {
        MuxServerConnector connector;
        Server server = new Server();
        HttpConfiguration httpCfg = new HttpConfiguration();
        int tlsPort = this.getCfgInt(JETTY_TLS_PORT_PNAME, this.getDefaultTlsPort());
        httpCfg.setSecurePort(tlsPort);
        httpCfg.setSecureScheme("https");
        String sslContextFactoryKeyStorePath = this.getCfgString(JETTY_SSLCONTEXTFACTORY_KEYSTOREPATH, null);
        if (sslContextFactoryKeyStorePath == null) {
            connector = new MuxServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpCfg)});
            connector.setPort(this.getCfgInt(JETTY_PORT_PNAME, this.getDefaultPort()));
        } else {
            File sslContextFactoryKeyStoreFile = ConfigUtils.getAbsoluteFile((String)sslContextFactoryKeyStorePath, (ConfigurationService)this.cfg);
            SslContextFactory sslContextFactory = new SslContextFactory();
            String sslContextFactoryKeyStorePassword = this.getCfgString(JETTY_SSLCONTEXTFACTORY_KEYSTOREPASSWORD, null);
            boolean sslContextFactoryNeedClientAuth = this.getCfgBoolean(JETTY_SSLCONTEXTFACTORY_NEEDCLIENTAUTH, false);
            sslContextFactory.setExcludeCipherSuites(new String[]{"SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", ".*NULL.*", ".*RC4.*", ".*MD5.*", ".*DES.*", ".*DSS.*"});
            sslContextFactory.setIncludeCipherSuites(new String[]{"TLS_DHE_RSA.*", "TLS_ECDHE.*"});
            sslContextFactory.setExcludeProtocols(new String[]{"SSLv3"});
            sslContextFactory.setRenegotiationAllowed(false);
            if (sslContextFactoryKeyStorePassword != null) {
                sslContextFactory.setKeyStorePassword(sslContextFactoryKeyStorePassword);
            }
            sslContextFactory.setKeyStorePath(sslContextFactoryKeyStoreFile.getPath());
            sslContextFactory.setNeedClientAuth(sslContextFactoryNeedClientAuth);
            HttpConfiguration httpsCfg = new HttpConfiguration(httpCfg);
            httpsCfg.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            connector = new MuxServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(httpsCfg)});
            connector.setPort(tlsPort);
        }
        String host = this.getCfgString(JETTY_HOST_PNAME, null);
        if (host != null) {
            connector.setHost(host);
        }
        server.addConnector((Connector)connector);
        Handler handler = this.initializeHandler(bundleContext, server);
        if (handler != null) {
            server.setHandler(handler);
        }
        return server;
    }

    protected String prefixProperty(String property) {
        if (this.propertyPrefix != null && property != null && property.startsWith(".")) {
            property = this.propertyPrefix + property;
        }
        return property;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext bundleContext) throws Exception {
        this.cfg = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
        boolean started = false;
        try {
            if (this.willStart(bundleContext)) {
                this.doStart(bundleContext);
                this.didStart(bundleContext);
                started = true;
            }
            Object var4_3 = null;
            if (!started) {
                this.cfg = null;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!started) {
                this.cfg = null;
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext bundleContext) throws Exception {
        try {
            if (this.willStop(bundleContext)) {
                this.doStop(bundleContext);
                this.didStop(bundleContext);
            }
            Object var3_2 = null;
            this.cfg = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.cfg = null;
            throw throwable;
        }
    }

    protected boolean willStart(BundleContext bundleContext) throws Exception {
        return true;
    }

    protected boolean willStop(BundleContext bundleContext) throws Exception {
        return true;
    }
}

