/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.ratecontrol;

import java.util.HashMap;
import org.jitsi.util.Logger;
import org.jitsi.util.StringCompiler;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.VideoChannel;
import org.jitsi.videobridge.ratecontrol.BitrateAdaptor;
import org.jitsi.videobridge.ratecontrol.BitrateController;
import org.jitsi.videobridge.simulcast.SimulcastManager;

public class SimulcastAdaptor
implements BitrateAdaptor {
    private final BitrateController bitrateController;
    private static final Logger logger = Logger.getLogger(SimulcastAdaptor.class);

    public SimulcastAdaptor(BitrateController bitrateController) {
        this.bitrateController = bitrateController;
    }

    public boolean touch() {
        return true;
    }

    public boolean increase() {
        VideoChannel channel = this.bitrateController.getChannel();
        SimulcastManager mySM = channel.getSimulcastManager();
        if (mySM != null && mySM.override(-1)) {
            if (logger.isDebugEnabled()) {
                int numEndpointsThatFitIn = this.bitrateController.calcNumEndpointsThatFitIn();
                Endpoint self = channel.getEndpoint();
                HashMap<String, Object> map = new HashMap<String, Object>(2);
                map.put("self", self);
                map.put("numEndpointsThatFitIn", numEndpointsThatFitIn);
                StringCompiler sc = new StringCompiler(map);
                logger.debug((Object)sc.c("The uplink between the bridge and {self.id} can support {numEndpointsThatFitIn}. Allow streaming of high quality layers."));
            }
            return true;
        }
        return false;
    }

    public boolean decrease() {
        VideoChannel channel = this.bitrateController.getChannel();
        SimulcastManager mySM = channel.getSimulcastManager();
        if (mySM != null && mySM.override(0)) {
            if (logger.isDebugEnabled()) {
                Endpoint self = channel.getEndpoint();
                int numEndpointsThatFitIn = this.bitrateController.calcNumEndpointsThatFitIn();
                HashMap<String, Object> map = new HashMap<String, Object>(2);
                map.put("self", self);
                map.put("numEndpointsThatFitIn", numEndpointsThatFitIn);
                StringCompiler sc = new StringCompiler(map);
                logger.debug((Object)sc.c("The uplink between the bridge and {self.id} can only support {numEndpointsThatFitIn}. Make sure we only stream low quality layers."));
            }
            return true;
        }
        return false;
    }
}

