/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.util.Logger;
import org.jitsi.util.StringCompiler;
import org.jitsi.util.StringUtils;
import org.jitsi.util.event.PropertyChangeNotifier;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.videobridge.SctpConnection;
import org.jitsi.videobridge.WebRtcDataStream;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Endpoint
extends PropertyChangeNotifier
implements WebRtcDataStream.DataCallback {
    public static final String CHANNELS_PROPERTY_NAME = Endpoint.class.getName() + ".channels";
    private static final Logger logger = Logger.getLogger(Endpoint.class);
    public static final String SCTP_CONNECTION_PROPERTY_NAME = Endpoint.class.getName() + ".sctpConnection";
    public static final String SELECTED_ENDPOINT_PROPERTY_NAME = Endpoint.class.getName() + ".selectedEndpoint";
    public static final String PINNED_ENDPOINT_PROPERTY_NAME = Endpoint.class.getName() + ".pinnedEndpoint";
    private final List<WeakReference<RtpChannel>> channels = new LinkedList<WeakReference<RtpChannel>>();
    private final WeakReference<Conference> weakConference;
    private boolean expired = false;
    private String displayName;
    private final String id;
    private WeakReference<SctpConnection> sctpConnection = new WeakReference<Object>(null);
    private WeakReference<Endpoint> weakSelectedEndpoint;
    private final Object selectedEndpointSyncRoot = new Object();
    private WeakReference<Endpoint> weakPinnedEndpoint;
    private final Object pinnedEndpointSyncRoot = new Object();

    public Endpoint(String id, Conference conference) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        this.weakConference = new WeakReference<Conference>(conference);
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addChannel(RtpChannel channel) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        if (channel.isExpired()) {
            return false;
        }
        boolean added = false;
        boolean removed = false;
        List<WeakReference<RtpChannel>> list = this.channels;
        synchronized (list) {
            boolean add = true;
            Iterator<WeakReference<RtpChannel>> i = this.channels.iterator();
            while (i.hasNext()) {
                RtpChannel c = (RtpChannel)i.next().get();
                if (c == null) {
                    i.remove();
                    removed = true;
                    continue;
                }
                if (c.equals(channel)) {
                    add = false;
                    continue;
                }
                if (!c.isExpired()) continue;
                i.remove();
                removed = true;
            }
            if (add) {
                this.channels.add(new WeakReference<RtpChannel>(channel));
                added = true;
            }
        }
        if (added || removed) {
            this.firePropertyChange(CHANNELS_PROPERTY_NAME, null, null);
        }
        return added;
    }

    void audioLevelChanged(Channel channel, long ssrc, int audioLevel) {
    }

    public int getChannelCount(MediaType mediaType) {
        return this.getChannels(mediaType).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RtpChannel> getChannels(MediaType mediaType) {
        boolean removed = false;
        LinkedList<RtpChannel> channels = new LinkedList<RtpChannel>();
        List<WeakReference<RtpChannel>> list = this.channels;
        synchronized (list) {
            Iterator<WeakReference<RtpChannel>> i = this.channels.iterator();
            while (i.hasNext()) {
                RtpChannel c = (RtpChannel)i.next().get();
                if (c == null || c.isExpired()) {
                    i.remove();
                    removed = true;
                    continue;
                }
                if (mediaType != null && !mediaType.equals((Object)c.getContent().getMediaType())) continue;
                channels.add(c);
            }
        }
        if (removed) {
            this.firePropertyChange(CHANNELS_PROPERTY_NAME, null, null);
        }
        return channels;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public final String getID() {
        return this.id;
    }

    public SctpConnection getSctpConnection() {
        return (SctpConnection)((Object)this.sctpConnection.get());
    }

    public Endpoint getEffectivelySelectedEndpoint() {
        Endpoint pinned = this.getPinnedEndpoint();
        if (pinned == null) {
            WeakReference<Endpoint> wr = this.weakSelectedEndpoint;
            Endpoint e = wr == null ? null : (Endpoint)wr.get();
            return e == null || e.expired ? null : e;
        }
        return pinned;
    }

    private Endpoint getSelectedEndpoint() {
        WeakReference<Endpoint> wr = this.weakSelectedEndpoint;
        Endpoint e = wr == null ? null : (Endpoint)wr.get();
        return e == null || e.expired ? null : e;
    }

    public Endpoint getPinnedEndpoint() {
        WeakReference<Endpoint> wr = this.weakPinnedEndpoint;
        Endpoint e = wr == null ? null : (Endpoint)wr.get();
        return e == null || e.expired ? null : e;
    }

    public Conference getConference() {
        WeakReference<Conference> wr = this.weakConference;
        return wr == null ? null : (Conference)wr.get();
    }

    @Override
    public void onBinaryData(WebRtcDataStream src, byte[] data) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStringData(WebRtcDataStream src, String msg) {
        JSONObject jsonObject;
        JSONParser parser = new JSONParser();
        try {
            Object obj = parser.parse(msg);
            if (!(obj instanceof JSONObject)) {
                return;
            }
            jsonObject = (JSONObject)obj;
        }
        catch (ParseException e) {
            logger.warn((Object)("Malformed JSON received from endpoint " + this.getID()), (Throwable)e);
            return;
        }
        Object colibriClass = jsonObject.get((Object)"colibriClass");
        if (colibriClass != null) {
            if ("SelectedEndpointChangedEvent".equals(colibriClass)) {
                boolean changed;
                String newSelectedEndpointID = (String)jsonObject.get((Object)"selectedEndpoint");
                if (logger.isDebugEnabled()) {
                    StringCompiler sc = new StringCompiler();
                    sc.bind("selectedId", (Object)newSelectedEndpointID);
                    sc.bind("this", (Object)this);
                    logger.debug((Object)sc.c("Endpoint {this.id} notified us that its big screen displays endpoint {selectedId}."));
                }
                Conference conference = (Conference)this.weakConference.get();
                Endpoint newSelectedEndpoint = !StringUtils.isNullOrEmpty((String)newSelectedEndpointID) && conference != null ? conference.getEndpoint(newSelectedEndpointID) : null;
                Endpoint oldSelectedEndpoint = this.getSelectedEndpoint();
                Object object = this.selectedEndpointSyncRoot;
                synchronized (object) {
                    boolean bl = changed = newSelectedEndpoint != oldSelectedEndpoint;
                    if (changed) {
                        this.weakSelectedEndpoint = newSelectedEndpoint == null ? null : new WeakReference<Endpoint>(newSelectedEndpoint);
                    }
                }
                if (changed) {
                    if (logger.isDebugEnabled()) {
                        StringCompiler sc = new StringCompiler();
                        sc.bind("selected", (Object)newSelectedEndpoint);
                        sc.bind("this", (Object)this);
                        logger.debug((Object)sc.c("Endpoint {this.id} selected {selected.id}."));
                    }
                    this.firePropertyChange(SELECTED_ENDPOINT_PROPERTY_NAME, oldSelectedEndpoint, newSelectedEndpoint);
                }
            } else if ("PinnedEndpointChangedEvent".equals(colibriClass)) {
                boolean changed;
                String newPinnedEndpointID = (String)jsonObject.get((Object)"pinnedEndpoint");
                if (logger.isDebugEnabled()) {
                    StringCompiler sc = new StringCompiler();
                    sc.bind("pinnedId", (Object)newPinnedEndpointID);
                    sc.bind("this", (Object)this);
                    logger.debug((Object)sc.c("Endpoint {this.id} notified us that it has pinned {pinnedId}."));
                }
                Conference conference = (Conference)this.weakConference.get();
                Endpoint newPinnedEndpoint = !StringUtils.isNullOrEmpty((String)newPinnedEndpointID) && conference != null ? conference.getEndpoint(newPinnedEndpointID) : null;
                Endpoint oldPinnedEndpoint = this.getPinnedEndpoint();
                Object sc = this.pinnedEndpointSyncRoot;
                synchronized (sc) {
                    boolean bl = changed = newPinnedEndpoint != oldPinnedEndpoint;
                    if (changed) {
                        this.weakPinnedEndpoint = newPinnedEndpoint == null ? null : new WeakReference<Endpoint>(newPinnedEndpoint);
                    }
                }
                if (changed) {
                    if (logger.isDebugEnabled()) {
                        sc = new StringCompiler();
                        sc.bind("pinned", (Object)newPinnedEndpoint);
                        sc.bind("this", (Object)this);
                        logger.debug((Object)sc.c("Endpoint {this.id} pinned {pinned.id}."));
                    }
                    this.firePropertyChange(PINNED_ENDPOINT_PROPERTY_NAME, oldPinnedEndpoint, newPinnedEndpoint);
                }
            }
        } else {
            logger.warn((Object)("Malformed JSON received from endpoint " + this.getID() + ". JSON object does not contain the colibriClass" + " field."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChannel(RtpChannel channel) {
        if (channel == null) {
            return false;
        }
        boolean removed = false;
        List<WeakReference<RtpChannel>> list = this.channels;
        synchronized (list) {
            Iterator<WeakReference<RtpChannel>> i = this.channels.iterator();
            while (i.hasNext()) {
                Channel c = (Channel)((Object)i.next().get());
                if (c != null && !((Object)((Object)c)).equals(channel) && !c.isExpired()) continue;
                i.remove();
                removed = true;
            }
        }
        if (removed) {
            this.firePropertyChange(CHANNELS_PROPERTY_NAME, null, null);
        }
        return removed;
    }

    void sctpConnectionReady(SctpConnection sctpConnection) {
        if (((Object)((Object)sctpConnection)).equals((Object)this.getSctpConnection()) && !sctpConnection.isExpired() && sctpConnection.isReady()) {
            for (RtpChannel channel : this.getChannels(null)) {
                channel.sctpConnectionReady(this);
            }
            try {
                WebRtcDataStream dataStream = sctpConnection.getDefaultDataStream();
                dataStream.setDataCallback(this);
            }
            catch (IOException e) {
                logger.error((Object)"Could not get the default data stream.", (Throwable)e);
            }
        }
    }

    public void sendMessageOnDataChannel(String msg) throws IOException {
        SctpConnection sctpConnection = this.getSctpConnection();
        String endpointId = this.getID();
        if (sctpConnection == null) {
            logger.warn((Object)("No SCTP connection with " + endpointId + "."));
        } else if (sctpConnection.isReady()) {
            WebRtcDataStream dataStream = sctpConnection.getDefaultDataStream();
            if (dataStream == null) {
                logger.warn((Object)("WebRtc data channel with " + endpointId + " not opened yet."));
            }
            dataStream.sendString(msg);
        } else {
            logger.warn((Object)("SCTP connection with " + endpointId + " not ready yet."));
        }
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setSctpConnection(SctpConnection sctpConnection) {
        SctpConnection oldValue = this.getSctpConnection();
        if (sctpConnection == null ? oldValue != null : !((Object)((Object)sctpConnection)).equals((Object)oldValue)) {
            this.sctpConnection = new WeakReference<SctpConnection>(sctpConnection);
            this.firePropertyChange(SCTP_CONNECTION_PROPERTY_NAME, (Object)oldValue, (Object)this.getSctpConnection());
        }
    }

    public String toString() {
        return this.getClass().getName() + " " + this.getID();
    }

    public void expire() {
        this.expired = true;
    }
}

