/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.zrtp.packets;

import gnu.java.zrtp.packets.ZrtpPacketBase;
import gnu.java.zrtp.utils.ZrtpUtils;

public class ZrtpPacketConfirm
extends ZrtpPacketBase {
    private static final int ZRTP_CONFIRM_FIXED_LENGTH = 16;
    private static final int HMAC_OFFSET = 12;
    private static final int IV_OFFSET = 20;
    private static final int HASH_H0_OFFSET = 36;
    private static final int FILLER_OFFSET = 68;
    private static final int SIG_LENGTH_OFFSET = 70;
    private static final int FLAGS_OFFSET = 71;
    private static final int EXP_TIME_OFFSET = 72;
    private static final int SIG_DATA_OFFSET = 76;
    private static final int CONFIRM_FIXED_LENGTH = 80;
    private int signatureLength;

    public ZrtpPacketConfirm() {
        super(null);
        this.setSignatureLength(0);
    }

    public ZrtpPacketConfirm(int sl) {
        super(null);
        this.setSignatureLength(sl);
    }

    public final boolean setSignatureLength(int sl) {
        if (sl > 512) {
            return false;
        }
        this.signatureLength = sl;
        int length = 80 + sl * 4;
        if (this.packetBuffer == null) {
            this.packetBuffer = new byte[length];
        } else {
            byte[] tmp = new byte[length];
            System.arraycopy(this.packetBuffer, 0, tmp, 0, 76);
            this.packetBuffer = tmp;
        }
        this.packetBuffer[70] = (byte)sl;
        if (sl > 255) {
            this.packetBuffer[69] = 1;
        }
        this.setLength((length - 4) / 4);
        this.setZrtpId();
        return true;
    }

    public ZrtpPacketConfirm(byte[] data) {
        super(data);
    }

    public final boolean isSASFlag() {
        return (this.packetBuffer[71] & 4) == 4;
    }

    public final boolean isPBXEnrollment() {
        return (this.packetBuffer[71] & 8) == 8;
    }

    public final byte[] getIv() {
        return ZrtpUtils.readRegion(this.packetBuffer, 20, 16);
    }

    public final byte[] getHmac() {
        return ZrtpUtils.readRegion(this.packetBuffer, 12, 8);
    }

    public final int getExpTime() {
        return ZrtpUtils.readInt(this.packetBuffer, 72);
    }

    public final byte[] getDataToSecure() {
        int length = (this.getLength() - 9) * 4;
        return ZrtpUtils.readRegion(this.packetBuffer, 36, length);
    }

    public final byte[] getHashH0() {
        return ZrtpUtils.readRegion(this.packetBuffer, 36, 32);
    }

    public final byte[] getSignatureData() {
        return ZrtpUtils.readRegion(this.packetBuffer, 76, this.signatureLength * 4);
    }

    public final int getSignatureLength() {
        this.signatureLength = this.packetBuffer[70] & 0xFF;
        if (this.packetBuffer[69] == 1) {
            this.signatureLength |= 0x100;
        }
        return this.signatureLength;
    }

    public final boolean isLengthOk() {
        return this.getLength() >= 19;
    }

    public final void setSASFlag() {
        this.packetBuffer[71] = (byte)(this.packetBuffer[71] | 4);
    }

    public final void setPBXEnrollment() {
        this.packetBuffer[71] = (byte)(this.packetBuffer[71] | 8);
    }

    public final void setHmac(byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, 12, 8);
    }

    public final void setIv(byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, 20, 16);
    }

    public final void setExpTime(int t) {
        ZrtpUtils.int32ToArrayInPlace(t, this.packetBuffer, 72);
    }

    public final void setDataToSecure(byte[] data) {
        int length = (this.getLength() - 9) * 4;
        System.arraycopy(data, 0, this.packetBuffer, 36, length);
    }

    public final void setHashH0(byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, 36, 32);
    }

    public final boolean setSignatureData(byte[] data) {
        if (data.length / 4 > this.signatureLength) {
            return false;
        }
        System.arraycopy(data, 0, this.packetBuffer, 76, data.length);
        return true;
    }
}

