/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.zrtp;

import gnu.java.zrtp.ZRtp;
import gnu.java.zrtp.ZrtpCallback;
import gnu.java.zrtp.ZrtpCodes;
import gnu.java.zrtp.packets.ZrtpPacketBase;
import gnu.java.zrtp.packets.ZrtpPacketCommit;
import gnu.java.zrtp.packets.ZrtpPacketConf2Ack;
import gnu.java.zrtp.packets.ZrtpPacketConfirm;
import gnu.java.zrtp.packets.ZrtpPacketDHPart;
import gnu.java.zrtp.packets.ZrtpPacketError;
import gnu.java.zrtp.packets.ZrtpPacketErrorAck;
import gnu.java.zrtp.packets.ZrtpPacketHello;
import gnu.java.zrtp.packets.ZrtpPacketHelloAck;
import gnu.java.zrtp.packets.ZrtpPacketPing;
import gnu.java.zrtp.packets.ZrtpPacketPingAck;
import gnu.java.zrtp.packets.ZrtpPacketRelayAck;
import gnu.java.zrtp.packets.ZrtpPacketSASRelay;
import java.util.EnumSet;

public class ZrtpStateClass {
    private ZRtp parent;
    private Event event;
    private ZrtpPacketBase sentPacket = null;
    private ZrtpPacketCommit commitPkt = null;
    private ZrtpTimer t1;
    private ZrtpTimer t2;
    private boolean multiStream = false;
    private ZrtpStates inState;
    private SecureSubStates secSubstate = SecureSubStates.Normal;
    private static final int MESSAGE_OFFSET = 4;
    private int sentVersion;

    protected ZrtpStateClass(ZRtp p) {
        this.parent = p;
        this.t1 = new ZrtpTimer(50, 20, 200);
        this.t2 = new ZrtpTimer(150, 10, 600);
        this.inState = ZrtpStates.Initial;
    }

    public long getTimeoutValue() {
        long res = 0L;
        int counter = 0;
        int time = this.t1.start;
        do {
            res += (long)time;
            int n = time = (time += time) > this.t1.capping ? this.t1.capping : time;
        } while (++counter < this.t1.maxResend);
        return res;
    }

    protected synchronized void processEvent(Event ev) {
        this.event = ev;
        if (this.event.type == EventDataType.ZrtpPacket) {
            byte[] pkt = this.event.packet;
            char first = (char)pkt[4];
            first = Character.toLowerCase(first);
            char middle = (char)pkt[8];
            middle = Character.toLowerCase(middle);
            char last = (char)pkt[11];
            last = Character.toLowerCase(last);
            if (first == 'e' && middle == 'r' && last == ' ') {
                this.cancelTimer();
                ZrtpPacketError epkt = new ZrtpPacketError(pkt);
                ZrtpPacketErrorAck eapkt = this.parent.prepareErrorAck(epkt);
                this.parent.sendPacketZRTP(eapkt);
                this.event.type = EventDataType.ErrorPkt;
            } else {
                if (first == 'p' && middle == ' ' && last == ' ') {
                    ZrtpPacketPing ppkt = new ZrtpPacketPing(pkt);
                    ZrtpPacketPingAck ppktAck = this.parent.preparePingAck(ppkt);
                    if (ppktAck != null) {
                        this.parent.sendPacketZRTP(ppktAck);
                    }
                    return;
                }
                if (first == 's' && last == 'y') {
                    ZrtpCodes.ZrtpErrorCodes[] errorCode = new ZrtpCodes.ZrtpErrorCodes[1];
                    ZrtpPacketSASRelay srly = new ZrtpPacketSASRelay(pkt);
                    ZrtpPacketRelayAck rapkt = this.parent.prepareRelayAck(srly, errorCode);
                    this.parent.sendPacketZRTP(rapkt);
                    return;
                }
            }
        } else if (this.event.type == EventDataType.ZrtpClose) {
            this.cancelTimer();
        }
        this.dispatchEvent();
    }

    protected void stopZrtpStates() {
        if (this.inState != ZrtpStates.Initial) {
            this.cancelTimer();
            this.event = new Event(EventDataType.ZrtpClose, null);
            this.dispatchEvent();
        }
    }

    protected void dispatchEvent() {
        switch (this.inState) {
            case Initial: {
                this.evInitial();
                break;
            }
            case Detect: {
                this.evDetect();
                break;
            }
            case AckDetected: {
                this.evAckDetected();
                break;
            }
            case AckSent: {
                this.evAckSent();
                break;
            }
            case WaitCommit: {
                this.evWaitCommit();
                break;
            }
            case CommitSent: {
                this.evCommitSent();
                break;
            }
            case WaitDHPart2: {
                this.evWaitDHPart2();
                break;
            }
            case WaitConfirm1: {
                this.evWaitConfirm1();
                break;
            }
            case WaitConfirm2: {
                this.evWaitConfirm2();
                break;
            }
            case WaitConfAck: {
                this.evWaitConfAck();
                break;
            }
            case WaitClearAck: {
                this.evWaitClearAck();
                break;
            }
            case SecureState: {
                this.evSecureState();
                break;
            }
            case WaitErrorAck: {
                this.evWaitErrorAck();
                break;
            }
        }
    }

    protected void evInitial() {
        if (this.event.type == EventDataType.ZrtpInitial) {
            ZrtpPacketHello hello = this.parent.prepareHello();
            this.sentVersion = hello.getVersionInt();
            this.sentPacket = hello;
            if (!this.parent.sendPacketZRTP(this.sentPacket)) {
                this.sendFailed();
                return;
            }
            if (this.startTimer(this.t1) <= 0) {
                this.timerFailed(ZrtpCodes.SevereCodes.SevereNoTimer);
                return;
            }
            this.inState = ZrtpStates.Detect;
        }
    }

    private void evDetect() {
        ZrtpCodes.ZrtpErrorCodes[] errorCode = new ZrtpCodes.ZrtpErrorCodes[1];
        switch (this.event.type) {
            case ZrtpPacket: {
                byte[] pkt = this.event.packet;
                char first = (char)pkt[4];
                first = Character.toLowerCase(first);
                char last = (char)pkt[11];
                last = Character.toLowerCase(last);
                if (first == 'h' && last == 'k') {
                    this.cancelTimer();
                    this.sentPacket = null;
                    this.inState = ZrtpStates.AckDetected;
                    return;
                }
                if (first != 'h' || last != ' ') break;
                ZrtpPacketHello hpkt = new ZrtpPacketHello(pkt);
                this.cancelTimer();
                int recvVersion = hpkt.getVersionInt();
                if (recvVersion > this.sentVersion) {
                    if (this.startTimer(this.t1) <= 0) {
                        this.timerFailed(ZrtpCodes.SevereCodes.SevereNoTimer);
                    }
                    return;
                }
                if (recvVersion != this.sentVersion) {
                    int index;
                    ZRtp.HelloPacketVersion[] hpv = this.parent.helloPackets;
                    for (index = 0; index < 2 && hpv[index].packet != this.parent.currentHelloPacket; ++index) {
                    }
                    while (index >= 0 && hpv[index].version > recvVersion) {
                        --index;
                    }
                    if (index < 0) {
                        this.sendErrorPacket(ZrtpCodes.ZrtpErrorCodes.UnsuppZRTPVersion);
                        return;
                    }
                    this.parent.currentHelloPacket = hpv[index].packet;
                    this.sentVersion = this.parent.currentHelloPacket.getVersionInt();
                    this.sentPacket = this.parent.currentHelloPacket;
                    if (!this.parent.sendPacketZRTP(this.sentPacket)) {
                        this.sendFailed();
                        return;
                    }
                    if (this.startTimer(this.t1) <= 0) {
                        this.timerFailed(ZrtpCodes.SevereCodes.SevereNoTimer);
                        return;
                    }
                    return;
                }
                ZrtpPacketHelloAck helloAck = this.parent.prepareHelloAck();
                if (!this.parent.sendPacketZRTP(helloAck)) {
                    this.parent.zrtpNegotiationFailed(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereCannotSend));
                    return;
                }
                this.commitPkt = this.parent.prepareCommit(hpkt, errorCode);
                this.inState = ZrtpStates.AckSent;
                if (this.commitPkt == null) {
                    this.sendErrorPacket(errorCode[0]);
                    return;
                }
                if (this.startTimer(this.t1) <= 0) {
                    this.timerFailed(ZrtpCodes.SevereCodes.SevereNoTimer);
                }
                this.t1.setMaxResend(60);
                break;
            }
            case Timer: {
                if (!this.parent.sendPacketZRTP(this.sentPacket)) {
                    this.sendFailed();
                    return;
                }
                if (this.nextTimer(this.t1) > 0) break;
                this.commitPkt = null;
                this.parent.zrtpNotSuppOther();
                this.inState = ZrtpStates.Detect;
                break;
            }
            case ZrtpInitial: {
                this.cancelTimer();
                if (!this.parent.sendPacketZRTP(this.sentPacket)) {
                    this.sendFailed();
                    return;
                }
                if (this.startTimer(this.t1) > 0) break;
                this.timerFailed(ZrtpCodes.SevereCodes.SevereNoTimer);
                break;
            }
            default: {
                if (this.event.type != EventDataType.ZrtpClose) {
                    this.parent.zrtpNegotiationFailed(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereProtocolError));
                }
                this.sentPacket = null;
                this.inState = ZrtpStates.Initial;
            }
        }
    }

    protected void evAckDetected() {
        ZrtpCodes.ZrtpErrorCodes[] errorCode = new ZrtpCodes.ZrtpErrorCodes[1];
        switch (this.event.type) {
            case ZrtpPacket: {
                byte[] pkt = this.event.packet;
                char first = (char)pkt[4];
                first = Character.toLowerCase(first);
                char last = (char)pkt[11];
                last = Character.toLowerCase(last);
                if (first != 'h' || last != ' ') break;
                ZrtpPacketHello hpkt = new ZrtpPacketHello(pkt);
                ZrtpPacketCommit commit = this.parent.prepareCommit(hpkt, errorCode);
                if (commit == null) {
                    this.sendErrorPacket(errorCode[0]);
                    return;
                }
                ZrtpPacketHelloAck helloAck = this.parent.prepareHelloAck();
                this.inState = ZrtpStates.WaitCommit;
                this.sentPacket = helloAck;
                if (this.parent.sendPacketZRTP(helloAck)) break;
                this.sendFailed();
                break;
            }
            default: {
                if (this.event.type != EventDataType.ZrtpClose) {
                    this.parent.zrtpNegotiationFailed(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereProtocolError));
                }
                this.inState = ZrtpStates.Initial;
            }
        }
    }

    protected void evAckSent() {
        ZrtpCodes.ZrtpErrorCodes[] errorCode = new ZrtpCodes.ZrtpErrorCodes[1];
        switch (this.event.type) {
            case ZrtpPacket: {
                byte[] pkt = this.event.packet;
                char first = (char)pkt[4];
                first = Character.toLowerCase(first);
                char last = (char)pkt[11];
                last = Character.toLowerCase(last);
                if (first == 'h' && last == 'k') {
                    this.cancelTimer();
                    this.sentPacket = this.commitPkt;
                    this.commitPkt = null;
                    this.inState = ZrtpStates.CommitSent;
                    if (!this.parent.sendPacketZRTP(this.sentPacket)) {
                        this.sendFailed();
                        return;
                    }
                    if (this.startTimer(this.t2) <= 0) {
                        this.timerFailed(ZrtpCodes.SevereCodes.SevereNoTimer);
                    }
                    return;
                }
                if (first == 'h' && last == ' ') {
                    ZrtpPacketHelloAck helloAck = this.parent.prepareHelloAck();
                    if (!this.parent.sendPacketZRTP(helloAck)) {
                        this.inState = ZrtpStates.Detect;
                        this.parent.zrtpNegotiationFailed(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereCannotSend));
                    }
                    return;
                }
                if (first != 'c') break;
                this.cancelTimer();
                ZrtpPacketCommit cpkt = new ZrtpPacketCommit(pkt);
                if (!this.multiStream) {
                    ZrtpPacketDHPart dhPart1 = this.parent.prepareDHPart1(cpkt, errorCode);
                    if (dhPart1 == null) {
                        if (errorCode[0] != ZrtpCodes.ZrtpErrorCodes.IgnorePacket) {
                            this.sendErrorPacket(errorCode[0]);
                        }
                        return;
                    }
                    this.commitPkt = null;
                    this.inState = ZrtpStates.WaitDHPart2;
                    this.sentPacket = dhPart1;
                } else {
                    ZrtpPacketConfirm confirm = this.parent.prepareConfirm1MultiStream(cpkt, errorCode);
                    if (confirm == null) {
                        if (errorCode[0] != ZrtpCodes.ZrtpErrorCodes.IgnorePacket) {
                            this.sendErrorPacket(errorCode[0]);
                        }
                        return;
                    }
                    this.sentPacket = confirm;
                    this.inState = ZrtpStates.WaitConfirm2;
                }
                if (this.parent.sendPacketZRTP(this.sentPacket)) break;
                this.sendFailed();
                break;
            }
            case Timer: {
                if (!this.parent.sendPacketZRTP(this.sentPacket)) {
                    this.sendFailed();
                    return;
                }
                if (this.nextTimer(this.t1) > 0) break;
                this.parent.zrtpNotSuppOther();
                this.commitPkt = null;
                this.inState = ZrtpStates.Detect;
                break;
            }
            default: {
                if (this.event.type != EventDataType.ZrtpClose) {
                    this.parent.zrtpNegotiationFailed(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereProtocolError));
                }
                this.commitPkt = null;
                this.sentPacket = null;
                this.inState = ZrtpStates.Initial;
            }
        }
    }

    protected void evWaitCommit() {
        ZrtpCodes.ZrtpErrorCodes[] errorCode = new ZrtpCodes.ZrtpErrorCodes[1];
        switch (this.event.type) {
            case ZrtpPacket: {
                byte[] pkt = this.event.packet;
                char first = (char)pkt[4];
                first = Character.toLowerCase(first);
                char last = (char)pkt[8];
                last = Character.toLowerCase(last);
                if (first == 'h') {
                    if (!this.parent.sendPacketZRTP(this.sentPacket)) {
                        this.sendFailed();
                    }
                    return;
                }
                if (first != 'c') break;
                ZrtpPacketCommit cpkt = new ZrtpPacketCommit(pkt);
                if (!this.multiStream) {
                    ZrtpPacketDHPart dhPart1 = this.parent.prepareDHPart1(cpkt, errorCode);
                    if (dhPart1 == null) {
                        if (errorCode[0] != ZrtpCodes.ZrtpErrorCodes.IgnorePacket) {
                            this.sendErrorPacket(errorCode[0]);
                        }
                        return;
                    }
                    this.sentPacket = dhPart1;
                    this.inState = ZrtpStates.WaitDHPart2;
                } else {
                    ZrtpPacketConfirm confirm = this.parent.prepareConfirm1MultiStream(cpkt, errorCode);
                    if (confirm == null) {
                        if (errorCode[0] != ZrtpCodes.ZrtpErrorCodes.IgnorePacket) {
                            this.sendErrorPacket(errorCode[0]);
                        }
                        return;
                    }
                    this.sentPacket = confirm;
                    this.inState = ZrtpStates.WaitConfirm2;
                }
                if (this.parent.sendPacketZRTP(this.sentPacket)) break;
                this.sendFailed();
                break;
            }
            default: {
                if (this.event.type != EventDataType.ZrtpClose) {
                    this.parent.zrtpNegotiationFailed(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereProtocolError));
                }
                this.commitPkt = null;
                this.sentPacket = null;
                this.inState = ZrtpStates.Initial;
            }
        }
    }

    protected void evCommitSent() {
        ZrtpCodes.ZrtpErrorCodes[] errorCode = new ZrtpCodes.ZrtpErrorCodes[1];
        switch (this.event.type) {
            case ZrtpPacket: {
                byte[] pkt = this.event.packet;
                char first = (char)pkt[4];
                first = Character.toLowerCase(first);
                char last = (char)pkt[11];
                last = Character.toLowerCase(last);
                if (first == 'h' && (last == 'k' || last == ' ')) {
                    return;
                }
                if (first == 'c' && last == ' ') {
                    ZrtpPacketCommit zpCo = new ZrtpPacketCommit(pkt);
                    if (!this.parent.verifyH2(zpCo)) {
                        return;
                    }
                    this.cancelTimer();
                    if (this.parent.compareCommit(zpCo) < 0) {
                        if (!this.multiStream) {
                            ZrtpPacketDHPart dhPart1 = this.parent.prepareDHPart1(zpCo, errorCode);
                            if (dhPart1 == null) {
                                if (errorCode[0] != ZrtpCodes.ZrtpErrorCodes.IgnorePacket) {
                                    this.sendErrorPacket(errorCode[0]);
                                }
                                return;
                            }
                            this.inState = ZrtpStates.WaitDHPart2;
                            this.sentPacket = dhPart1;
                        } else {
                            ZrtpPacketConfirm confirm = this.parent.prepareConfirm1MultiStream(zpCo, errorCode);
                            if (confirm == null) {
                                if (errorCode[0] != ZrtpCodes.ZrtpErrorCodes.IgnorePacket) {
                                    this.sendErrorPacket(errorCode[0]);
                                }
                                return;
                            }
                            this.sentPacket = confirm;
                            this.inState = ZrtpStates.WaitConfirm2;
                        }
                        if (!this.parent.sendPacketZRTP(this.sentPacket)) {
                            this.sendFailed();
                        }
                    } else if (this.startTimer(this.t2) <= 0) {
                        this.timerFailed(ZrtpCodes.SevereCodes.SevereNoTimer);
                    }
                    return;
                }
                if (first == 'd') {
                    ZrtpPacketDHPart dpkt = new ZrtpPacketDHPart(pkt);
                    ZrtpPacketDHPart dhPart2 = this.parent.prepareDHPart2(dpkt, errorCode);
                    if (dhPart2 == null) {
                        if (errorCode[0] != ZrtpCodes.ZrtpErrorCodes.IgnorePacket) {
                            this.sendErrorPacket(errorCode[0]);
                        }
                        return;
                    }
                    this.cancelTimer();
                    this.sentPacket = dhPart2;
                    this.inState = ZrtpStates.WaitConfirm1;
                    if (!this.parent.sendPacketZRTP(this.sentPacket)) {
                        this.sendFailed();
                        return;
                    }
                    if (this.startTimer(this.t2) <= 0) {
                        this.timerFailed(ZrtpCodes.SevereCodes.SevereNoTimer);
                    }
                }
                if (!this.multiStream || first != 'c' || last != '1') break;
                this.cancelTimer();
                ZrtpPacketConfirm cpkt = new ZrtpPacketConfirm(pkt);
                ZrtpPacketConfirm confirm = this.parent.prepareConfirm2MultiStream(cpkt, errorCode);
                if (confirm == null) {
                    this.sendErrorPacket(errorCode[0]);
                    return;
                }
                this.inState = ZrtpStates.WaitConfAck;
                this.sentPacket = confirm;
                if (!this.parent.sendPacketZRTP(this.sentPacket)) {
                    this.sendFailed();
                    return;
                }
                if (this.startTimer(this.t2) <= 0) {
                    this.timerFailed(ZrtpCodes.SevereCodes.SevereNoTimer);
                }
                if (this.parent.srtpSecretsReady(ZrtpCallback.EnableSecurity.ForReceiver)) break;
                this.parent.sendInfo(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereSecurityException));
                this.sendErrorPacket(ZrtpCodes.ZrtpErrorCodes.CriticalSWError);
                return;
            }
            case Timer: {
                if (!this.parent.sendPacketZRTP(this.sentPacket)) {
                    this.sendFailed();
                    return;
                }
                if (this.nextTimer(this.t2) > 0) break;
                this.timerFailed(ZrtpCodes.SevereCodes.SevereTooMuchRetries);
                break;
            }
            default: {
                if (this.event.type != EventDataType.ZrtpClose) {
                    this.parent.zrtpNegotiationFailed(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereProtocolError));
                }
                this.sentPacket = null;
                this.inState = ZrtpStates.Initial;
            }
        }
    }

    protected void evWaitDHPart2() {
        ZrtpCodes.ZrtpErrorCodes[] errorCode = new ZrtpCodes.ZrtpErrorCodes[1];
        switch (this.event.type) {
            case ZrtpPacket: {
                byte[] pkt = this.event.packet;
                char first = (char)pkt[4];
                first = Character.toLowerCase(first);
                char last = (char)pkt[11];
                last = Character.toLowerCase(last);
                if (first == 'c') {
                    if (!this.parent.sendPacketZRTP(this.sentPacket)) {
                        this.sendFailed();
                    }
                    return;
                }
                if (first != 'd') break;
                ZrtpPacketDHPart dpkt = new ZrtpPacketDHPart(pkt);
                ZrtpPacketConfirm confirm = this.parent.prepareConfirm1(dpkt, errorCode);
                if (confirm == null) {
                    if (errorCode[0] != ZrtpCodes.ZrtpErrorCodes.IgnorePacket) {
                        this.sendErrorPacket(errorCode[0]);
                    }
                    return;
                }
                this.inState = ZrtpStates.WaitConfirm2;
                this.sentPacket = confirm;
                if (this.parent.sendPacketZRTP(this.sentPacket)) break;
                this.sendFailed();
                break;
            }
            default: {
                if (this.event.type != EventDataType.ZrtpClose) {
                    this.parent.zrtpNegotiationFailed(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereProtocolError));
                }
                this.sentPacket = null;
                this.inState = ZrtpStates.Initial;
            }
        }
    }

    protected void evWaitConfirm1() {
        ZrtpCodes.ZrtpErrorCodes[] errorCode = new ZrtpCodes.ZrtpErrorCodes[1];
        switch (this.event.type) {
            case ZrtpPacket: {
                byte[] pkt = this.event.packet;
                char first = (char)pkt[4];
                first = Character.toLowerCase(first);
                char last = (char)pkt[11];
                last = Character.toLowerCase(last);
                if (first != 'c' || last != '1') break;
                this.cancelTimer();
                ZrtpPacketConfirm cpkt = new ZrtpPacketConfirm(pkt);
                ZrtpPacketConfirm confirm = this.parent.prepareConfirm2(cpkt, errorCode);
                if (confirm == null) {
                    this.sendErrorPacket(errorCode[0]);
                    return;
                }
                this.inState = ZrtpStates.WaitConfAck;
                this.sentPacket = confirm;
                if (!this.parent.sendPacketZRTP(this.sentPacket)) {
                    this.sendFailed();
                    return;
                }
                if (this.startTimer(this.t2) <= 0) {
                    this.timerFailed(ZrtpCodes.SevereCodes.SevereNoTimer);
                    return;
                }
                if (this.parent.srtpSecretsReady(ZrtpCallback.EnableSecurity.ForReceiver)) break;
                this.parent.sendInfo(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereSecurityException));
                this.sendErrorPacket(ZrtpCodes.ZrtpErrorCodes.CriticalSWError);
                return;
            }
            case Timer: {
                if (!this.parent.sendPacketZRTP(this.sentPacket)) {
                    this.sendFailed();
                    return;
                }
                if (this.nextTimer(this.t2) > 0) break;
                this.timerFailed(ZrtpCodes.SevereCodes.SevereTooMuchRetries);
                break;
            }
            default: {
                if (this.event.type != EventDataType.ZrtpClose) {
                    this.parent.zrtpNegotiationFailed(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereProtocolError));
                }
                this.sentPacket = null;
                this.inState = ZrtpStates.Initial;
            }
        }
    }

    protected void evWaitConfirm2() {
        ZrtpCodes.ZrtpErrorCodes[] errorCode = new ZrtpCodes.ZrtpErrorCodes[1];
        switch (this.event.type) {
            case ZrtpPacket: {
                byte[] pkt = this.event.packet;
                char first = (char)pkt[4];
                first = Character.toLowerCase(first);
                char last = (char)pkt[11];
                last = Character.toLowerCase(last);
                if (first == 'd' || this.multiStream && first == 'c' && last == ' ') {
                    if (!this.parent.sendPacketZRTP(this.sentPacket)) {
                        this.sendFailed();
                    }
                    return;
                }
                if (first != 'c' || last != '2') break;
                ZrtpPacketConfirm cpkt = new ZrtpPacketConfirm(pkt);
                ZrtpPacketConf2Ack confack = this.parent.prepareConf2Ack(cpkt, errorCode);
                if (confack == null) {
                    this.sendErrorPacket(errorCode[0]);
                    return;
                }
                this.sentPacket = confack;
                if (!this.parent.sendPacketZRTP(this.sentPacket)) {
                    this.sendFailed();
                    return;
                }
                if (!this.parent.srtpSecretsReady(ZrtpCallback.EnableSecurity.ForSender) || !this.parent.srtpSecretsReady(ZrtpCallback.EnableSecurity.ForReceiver)) {
                    this.parent.sendInfo(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereSecurityException));
                    this.sendErrorPacket(ZrtpCodes.ZrtpErrorCodes.CriticalSWError);
                    return;
                }
                this.inState = ZrtpStates.SecureState;
                this.parent.sendInfo(ZrtpCodes.MessageSeverity.Info, EnumSet.of(ZrtpCodes.InfoCodes.InfoSecureStateOn));
                break;
            }
            default: {
                if (this.event.type != EventDataType.ZrtpClose) {
                    this.parent.zrtpNegotiationFailed(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereProtocolError));
                }
                this.sentPacket = null;
                this.inState = ZrtpStates.Initial;
            }
        }
    }

    protected void evWaitConfAck() {
        switch (this.event.type) {
            case ZrtpPacket: {
                byte[] pkt = this.event.packet;
                char first = (char)pkt[4];
                first = Character.toLowerCase(first);
                char last = (char)pkt[11];
                last = Character.toLowerCase(last);
                if (first != 'c') break;
                this.cancelTimer();
                this.sentPacket = null;
                if (!this.parent.srtpSecretsReady(ZrtpCallback.EnableSecurity.ForSender)) {
                    this.parent.sendInfo(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereSecurityException));
                    this.sendErrorPacket(ZrtpCodes.ZrtpErrorCodes.CriticalSWError);
                    return;
                }
                this.inState = ZrtpStates.SecureState;
                this.parent.sendInfo(ZrtpCodes.MessageSeverity.Info, EnumSet.of(ZrtpCodes.InfoCodes.InfoSecureStateOn));
                break;
            }
            case Timer: {
                if (!this.parent.sendPacketZRTP(this.sentPacket)) {
                    this.sendFailed();
                    return;
                }
                if (this.nextTimer(this.t2) > 0) break;
                this.timerFailed(ZrtpCodes.SevereCodes.SevereTooMuchRetries);
                break;
            }
            default: {
                if (this.event.type != EventDataType.ZrtpClose) {
                    this.parent.zrtpNegotiationFailed(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereProtocolError));
                }
                this.sentPacket = null;
                this.inState = ZrtpStates.Initial;
                this.parent.srtpSecretsOff(ZrtpCallback.EnableSecurity.ForReceiver);
            }
        }
    }

    protected void evWaitClearAck() {
    }

    protected void evSecureState() {
        if (this.secSubstate == SecureSubStates.WaitSasRelayAck && this.subEvWaitRelayAck()) {
            return;
        }
        switch (this.event.type) {
            case ZrtpPacket: {
                byte[] pkt = this.event.packet;
                char first = (char)pkt[4];
                first = Character.toLowerCase(first);
                char last = (char)pkt[11];
                last = Character.toLowerCase(last);
                if (first != 'c' || last != '2') break;
                if (this.sentPacket != null && !this.parent.sendPacketZRTP(this.sentPacket)) {
                    this.sentPacket = null;
                    this.inState = ZrtpStates.Initial;
                    this.parent.srtpSecretsOff(ZrtpCallback.EnableSecurity.ForSender);
                    this.parent.srtpSecretsOff(ZrtpCallback.EnableSecurity.ForReceiver);
                    this.parent.zrtpNegotiationFailed(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereCannotSend));
                }
                return;
            }
            case Timer: {
                break;
            }
            default: {
                if (this.event.type == EventDataType.ErrorPkt) {
                    return;
                }
                this.sentPacket = null;
                this.inState = ZrtpStates.Initial;
                this.parent.srtpSecretsOff(ZrtpCallback.EnableSecurity.ForSender);
                this.parent.srtpSecretsOff(ZrtpCallback.EnableSecurity.ForReceiver);
                if (this.event.type != EventDataType.ZrtpClose) {
                    this.parent.zrtpNegotiationFailed(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereProtocolError));
                }
                this.parent.sendInfo(ZrtpCodes.MessageSeverity.Info, EnumSet.of(ZrtpCodes.InfoCodes.InfoSecureStateOff));
            }
        }
    }

    protected boolean subEvWaitRelayAck() {
        switch (this.event.type) {
            case ZrtpPacket: {
                byte[] pkt = this.event.packet;
                char first = (char)pkt[4];
                first = Character.toLowerCase(first);
                char last = (char)pkt[11];
                last = Character.toLowerCase(last);
                if (first == 'r' && last == 'k') {
                    this.cancelTimer();
                    this.secSubstate = SecureSubStates.Normal;
                    this.sentPacket = null;
                }
                return true;
            }
            case Timer: {
                if (!this.parent.sendPacketZRTP(this.sentPacket)) {
                    this.sendFailed();
                    return false;
                }
                return this.nextTimer(this.t2) > 0;
            }
        }
        return false;
    }

    protected void evWaitErrorAck() {
        switch (this.event.type) {
            case ZrtpPacket: {
                byte[] pkt = this.event.packet;
                char first = (char)pkt[4];
                first = Character.toLowerCase(first);
                char last = (char)pkt[11];
                last = Character.toLowerCase(last);
                if (first != 'e' || last != 'k') break;
                this.cancelTimer();
                this.inState = ZrtpStates.Initial;
                this.sentPacket = null;
                break;
            }
            case Timer: {
                if (!this.parent.sendPacketZRTP(this.sentPacket)) {
                    this.sendFailed();
                    return;
                }
                if (this.nextTimer(this.t2) > 0) break;
                this.timerFailed(ZrtpCodes.SevereCodes.SevereTooMuchRetries);
                break;
            }
            default: {
                if (this.event.type != EventDataType.ZrtpClose) {
                    this.parent.zrtpNegotiationFailed(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereProtocolError));
                }
                this.sentPacket = null;
                this.inState = ZrtpStates.Initial;
            }
        }
    }

    private int startTimer(ZrtpTimer t) {
        return this.parent.activateTimer(t.startTimer());
    }

    private int nextTimer(ZrtpTimer t) {
        int time = t.nextTimer();
        return time < 0 ? time : this.parent.activateTimer(time);
    }

    private int cancelTimer() {
        return this.parent.cancelTimer();
    }

    private void sendFailed() {
        this.sentPacket = null;
        this.inState = ZrtpStates.Initial;
        this.parent.zrtpNegotiationFailed(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(ZrtpCodes.SevereCodes.SevereCannotSend));
    }

    private void timerFailed(ZrtpCodes.SevereCodes subCode) {
        this.sentPacket = null;
        this.inState = ZrtpStates.Initial;
        this.parent.zrtpNegotiationFailed(ZrtpCodes.MessageSeverity.Severe, EnumSet.of(subCode));
    }

    private void sendErrorPacket(ZrtpCodes.ZrtpErrorCodes errorCode) {
        this.cancelTimer();
        ZrtpPacketError err = this.parent.prepareError(errorCode);
        this.parent.zrtpNegotiationFailed(ZrtpCodes.MessageSeverity.ZrtpError, EnumSet.of(errorCode));
        this.sentPacket = err;
        this.inState = ZrtpStates.WaitErrorAck;
        if (!this.parent.sendPacketZRTP(err) || this.startTimer(this.t2) <= 0) {
            this.sendFailed();
        }
    }

    protected void sendSASRelay(ZrtpPacketSASRelay relay) {
        this.cancelTimer();
        this.sentPacket = relay;
        this.secSubstate = SecureSubStates.WaitSasRelayAck;
        if (!this.parent.sendPacketZRTP(relay) || this.startTimer(this.t2) <= 0) {
            this.sendFailed();
        }
    }

    protected boolean isMultiStream() {
        return this.multiStream;
    }

    protected void setMultiStream(boolean multiStream) {
        this.multiStream = multiStream;
    }

    protected boolean isInState(ZrtpStates state) {
        return state == this.inState;
    }

    private class ZrtpTimer {
        int time;
        int start;
        int capping;
        int counter;
        int maxResend;

        ZrtpTimer(int s, int r, int c) {
            this.start = s;
            this.capping = c;
            this.maxResend = r;
        }

        int startTimer() {
            this.time = this.start;
            this.counter = 0;
            return this.time;
        }

        int nextTimer() {
            this.time += this.time;
            this.time = this.time > this.capping ? this.capping : this.time;
            ++this.counter;
            if (this.counter > this.maxResend) {
                return -1;
            }
            return this.time;
        }

        void setMaxResend(int newResend) {
            this.maxResend = newResend;
        }
    }

    protected class Event {
        private EventDataType type;
        private byte[] packet;

        public Event(EventDataType evt, byte[] pckt) {
            this.type = evt;
            this.packet = pckt;
        }

        protected byte[] getPacket() {
            return this.packet;
        }

        protected EventDataType getType() {
            return this.type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum EventDataType {
        ZrtpInitial,
        ZrtpClose,
        ZrtpPacket,
        Timer,
        ErrorPkt;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SecureSubStates {
        Normal,
        WaitSasRelayAck,
        numberofSecureSubStates;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ZrtpStates {
        Initial,
        Detect,
        AckDetected,
        AckSent,
        WaitCommit,
        CommitSent,
        WaitDHPart2,
        WaitConfirm1,
        WaitConfirm2,
        WaitConfAck,
        WaitClearAck,
        SecureState,
        WaitErrorAck,
        numberOfStates;

    }
}

