/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform;

import java.net.DatagramPacket;
import org.jitsi.impl.neomedia.RTPConnectorInputStream;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.PacketTransformer;

public abstract class TransformInputStream<T>
extends RTPConnectorInputStream<T> {
    private PacketTransformer transformer;

    protected TransformInputStream(T socket) {
        super(socket);
    }

    @Override
    protected RawPacket[] createRawPacket(DatagramPacket datagramPacket) {
        RawPacket[] pkts = super.createRawPacket(datagramPacket);
        for (int i = 0; i < pkts.length; ++i) {
            RawPacket pkt = pkts[i];
            if (pkt == null || !pkt.isInvalid()) continue;
            pkts[i] = null;
        }
        PacketTransformer transformer = this.getTransformer();
        return transformer == null ? pkts : transformer.reverseTransform(pkts);
    }

    public PacketTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(PacketTransformer transformer) {
        this.transformer = transformer;
    }
}

