/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtcp.termination.strategies;

import java.util.Vector;
import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import net.sf.fmj.media.rtp.RTCPPacket;
import net.sf.fmj.media.rtp.RTCPRRPacket;
import net.sf.fmj.media.rtp.RTCPReportBlock;
import net.sf.fmj.media.rtp.RTCPSRPacket;
import org.jitsi.impl.neomedia.rtcp.RTCPFBPacket;
import org.jitsi.service.neomedia.Transformer;

public class ReceiverFeedbackFilter
implements Transformer<RTCPCompoundPacket> {
    private static RTCPReportBlock[] NO_RTCP_REPORT_BLOCKS = new RTCPReportBlock[0];

    @Override
    public RTCPCompoundPacket reverseTransform(RTCPCompoundPacket inPacket) {
        if (inPacket == null || inPacket.packets == null || inPacket.packets.length == 0) {
            return inPacket;
        }
        Vector<RTCPPacket> outPackets = new Vector<RTCPPacket>(inPacket.packets.length);
        block8: for (RTCPPacket p : inPacket.packets) {
            switch (p.type) {
                case 201: {
                    RTCPRRPacket rr = (RTCPRRPacket)p;
                    outPackets.add(rr);
                    rr.reports = NO_RTCP_REPORT_BLOCKS;
                    continue block8;
                }
                case 200: {
                    RTCPSRPacket sr = (RTCPSRPacket)p;
                    outPackets.add(sr);
                    sr.reports = NO_RTCP_REPORT_BLOCKS;
                    continue block8;
                }
                case 206: {
                    RTCPFBPacket psfb = (RTCPFBPacket)p;
                    switch (psfb.fmt) {
                        case 15: {
                            continue block8;
                        }
                    }
                    outPackets.add(psfb);
                    continue block8;
                }
                default: {
                    outPackets.add(p);
                }
            }
        }
        Object[] outarr = new RTCPPacket[outPackets.size()];
        outPackets.copyInto(outarr);
        RTCPCompoundPacket outPacket = new RTCPCompoundPacket((RTCPPacket[])outarr);
        return outPacket;
    }

    @Override
    public void close() {
    }

    @Override
    public RTCPCompoundPacket transform(RTCPCompoundPacket inPacket) {
        return inPacket;
    }
}

