/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.recording;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.recording.RecorderEvent;
import org.jitsi.service.neomedia.recording.RecorderEventHandler;
import org.jitsi.util.Logger;
import org.json.simple.JSONObject;

public class RecorderEventHandlerJSONImpl
implements RecorderEventHandler {
    private static final Logger logger = Logger.getLogger(RecorderEventHandlerJSONImpl.class);
    private static final Comparator<RecorderEvent> eventComparator = new Comparator<RecorderEvent>(){

        @Override
        public int compare(RecorderEvent a, RecorderEvent b) {
            return Long.valueOf(a.getInstant()).compareTo(b.getInstant());
        }
    };
    File file;
    private boolean closed = false;
    private final List<RecorderEvent> audioEvents = new LinkedList<RecorderEvent>();
    private final List<RecorderEvent> videoEvents = new LinkedList<RecorderEvent>();

    public RecorderEventHandlerJSONImpl(String filename) throws IOException {
        this.file = new File(filename);
        if (!this.file.createNewFile()) {
            throw new IOException("File exists or cannot be created: " + this.file);
        }
        if (!this.file.canWrite()) {
            throw new IOException("Cannot write to file: " + this.file);
        }
    }

    @Override
    public synchronized boolean handleEvent(RecorderEvent ev) {
        if (this.closed) {
            return false;
        }
        MediaType mediaType = ev.getMediaType();
        RecorderEvent.Type type = ev.getType();
        long duration = ev.getDuration();
        long ssrc = ev.getSsrc();
        if (RecorderEvent.Type.RECORDING_ENDED.equals((Object)type) && ev.getInstant() == -1L && duration != -1L) {
            List<RecorderEvent> events = MediaType.AUDIO.equals((Object)mediaType) ? this.audioEvents : this.videoEvents;
            RecorderEvent start = null;
            for (RecorderEvent e : events) {
                if (!RecorderEvent.Type.RECORDING_STARTED.equals((Object)e.getType()) || e.getSsrc() != ssrc) continue;
                start = e;
                break;
            }
            if (start != null) {
                ev.setInstant(start.getInstant() + duration);
            }
        }
        if (MediaType.AUDIO.equals((Object)mediaType)) {
            this.audioEvents.add(ev);
        } else if (MediaType.VIDEO.equals((Object)mediaType)) {
            this.videoEvents.add(ev);
        }
        try {
            this.writeAllEvents();
        }
        catch (IOException ioe) {
            logger.warn("Failed to write recorder events to file: ", ioe);
            return false;
        }
        return true;
    }

    @Override
    public synchronized void close() {
        try {
            this.writeAllEvents();
        }
        catch (IOException ioe) {
            logger.warn("Failed to write recorder events to file: " + ioe);
        }
        finally {
            this.closed = true;
        }
    }

    private void writeAllEvents() throws IOException {
        Collections.sort(this.audioEvents, eventComparator);
        Collections.sort(this.videoEvents, eventComparator);
        int nbAudio = this.audioEvents.size();
        int nbVideo = this.videoEvents.size();
        if (nbAudio + nbVideo > 0) {
            FileWriter writer = new FileWriter(this.file, false);
            writer.write("{\n");
            if (nbAudio > 0) {
                writer.write("  \"audio\" : [\n");
                this.writeEvents(this.audioEvents, writer);
                if (nbVideo > 0) {
                    writer.write("  ],\n\n");
                } else {
                    writer.write("  ]\n\n");
                }
            }
            if (nbVideo > 0) {
                writer.write("  \"video\" : [\n");
                this.writeEvents(this.videoEvents, writer);
                writer.write("  ]\n");
            }
            writer.write("}\n");
            writer.close();
        }
    }

    private void writeEvents(List<RecorderEvent> events, FileWriter writer) throws IOException {
        int idx = 0;
        int size = events.size();
        for (RecorderEvent ev : events) {
            if (++idx == size) {
                writer.write("    " + this.getJSON(ev) + "\n");
                continue;
            }
            writer.write("    " + this.getJSON(ev) + ",\n");
        }
    }

    private String getJSON(RecorderEvent ev) {
        String filename;
        String endpointId;
        long rtpTimestamp;
        RecorderEvent.AspectRatio aspectRatio;
        JSONObject json = new JSONObject();
        json.put((Object)"instant", (Object)ev.getInstant());
        json.put((Object)"type", (Object)ev.getType().toString());
        MediaType mediaType = ev.getMediaType();
        if (mediaType != null) {
            json.put((Object)"mediaType", (Object)mediaType.toString());
        }
        json.put((Object)"ssrc", (Object)ev.getSsrc());
        long audioSsrc = ev.getAudioSsrc();
        if (audioSsrc != -1L) {
            json.put((Object)"audioSsrc", (Object)audioSsrc);
        }
        if ((aspectRatio = ev.getAspectRatio()) != RecorderEvent.AspectRatio.ASPECT_RATIO_UNKNOWN) {
            json.put((Object)"aspectRatio", (Object)aspectRatio.toString());
        }
        if ((rtpTimestamp = ev.getRtpTimestamp()) != -1L) {
            json.put((Object)"rtpTimestamp", (Object)rtpTimestamp);
        }
        if ((endpointId = ev.getEndpointId()) != null) {
            json.put((Object)"endpointId", (Object)endpointId);
        }
        if ((filename = ev.getFilename()) != null) {
            String bareFilename = filename;
            int idx = filename.lastIndexOf(47);
            int len = filename.length();
            if (idx != -1 && idx != len - 1) {
                bareFilename = filename.substring(1 + idx, len);
            }
            json.put((Object)"filename", (Object)bareFilename);
        }
        return json.toJSONString();
    }
}

