/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.g722;

import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.codec.audio.g722.JNIDecoderImpl;
import org.jitsi.impl.neomedia.codec.audio.g722.JNIEncoder;

public class JNIEncoderImpl
extends AbstractCodec2 {
    private long encoder;

    public JNIEncoderImpl() {
        super("G.722 JNI Encoder", AudioFormat.class, JNIDecoderImpl.SUPPORTED_INPUT_FORMATS);
        this.inputFormats = JNIDecoderImpl.SUPPORTED_OUTPUT_FORMATS;
    }

    private long computeDuration(long length) {
        return length * 1000000L / 8L;
    }

    @Override
    protected void doClose() {
        JNIEncoder.g722_encoder_close(this.encoder);
    }

    @Override
    protected void doOpen() throws ResourceUnavailableException {
        this.encoder = JNIEncoder.g722_encoder_open();
        if (this.encoder == 0L) {
            throw new ResourceUnavailableException("g722_encoder_open");
        }
    }

    @Override
    protected int doProcess(Buffer inputBuffer, Buffer outputBuffer) {
        int inputOffset = inputBuffer.getOffset();
        int inputLength = inputBuffer.getLength();
        byte[] input = (byte[])inputBuffer.getData();
        int outputOffset = outputBuffer.getOffset();
        int outputLength = inputLength / 4;
        byte[] output = JNIEncoderImpl.validateByteArraySize(outputBuffer, outputOffset + outputLength, true);
        JNIEncoder.g722_encoder_process(this.encoder, input, inputOffset, output, outputOffset, outputLength);
        outputBuffer.setDuration(this.computeDuration(outputLength));
        outputBuffer.setFormat(this.getOutputFormat());
        outputBuffer.setLength(outputLength);
        return 0;
    }

    @Override
    public Format getOutputFormat() {
        Format outputFormat = super.getOutputFormat();
        if (outputFormat != null && outputFormat.getClass() == AudioFormat.class) {
            AudioFormat outputAudioFormat = (AudioFormat)outputFormat;
            this.setOutputFormat(new AudioFormat(outputAudioFormat.getEncoding(), outputAudioFormat.getSampleRate(), outputAudioFormat.getSampleSizeInBits(), outputAudioFormat.getChannels(), outputAudioFormat.getEndian(), outputAudioFormat.getSigned(), outputAudioFormat.getFrameSizeInBits(), outputAudioFormat.getFrameRate(), outputAudioFormat.getDataType()){
                private static final long serialVersionUID = 0L;

                @Override
                public long computeDuration(long length) {
                    return JNIEncoderImpl.this.computeDuration(length);
                }
            });
        }
        return outputFormat;
    }
}

