/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import com.sun.media.util.Registry;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.control.BufferControl;
import javax.media.format.AudioFormat;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.rtp.BasicJitterBufferBehaviour;
import net.sf.fmj.media.rtp.RTPRawReceiver;
import net.sf.fmj.media.rtp.RTPSourceStream;

class AudioJitterBufferBehaviour
extends BasicJitterBufferBehaviour {
    private static final int DEFAULT_AUD_PKT_SIZE = 256;
    private static final int DEFAULT_MS_PER_PKT = 20;
    private static final int INITIAL_PACKETS = 300;
    private static final AudioFormat MPEG = new AudioFormat("mpegaudio/rtp");
    private final boolean AJB_ENABLED = Registry.getBoolean("adaptive_jitter_buffer_ENABLE", true);
    private final int AJB_GROW_INCREMENT = Registry.getInt("adaptive_jitter_buffer_GROW_INCREMENT", 2);
    private final int AJB_GROW_INTERVAL = Registry.getInt("adaptive_jitter_buffer_GROW_INTERVAL", 30);
    private final int AJB_GROW_THRESHOLD = Registry.getInt("adaptive_jitter_buffer_GROW_THRESHOLD", 3);
    private final int AJB_MAX_SIZE = Registry.getInt("adaptive_jitter_buffer_MAX_SIZE", 16);
    private final int AJB_MIN_SIZE = Registry.getInt("adaptive_jitter_buffer_MIN_SIZE", 4);
    private final int AJB_SHRINK_DECREMENT = Registry.getInt("adaptive_jitter_buffer_SHRINK_DECREMENT", 1);
    private final int AJB_SHRINK_INTERVAL = Registry.getInt("adaptive_jitter_buffer_SHRINK_INTERVAL", 120);
    private final int AJB_SHRINK_THRESHOLD = Registry.getInt("adaptive_jitter_buffer_SHRINK_THRESHOLD", 1);
    private int growCount;
    private byte[] history;
    private int historyLength;
    private int historyTail;
    private long msPerPkt = 20L;
    private boolean replenish = true;
    private int shrinkCount = 0;
    private boolean skipFec = false;

    public AudioJitterBufferBehaviour(RTPSourceStream stream) {
        super(stream);
        this.initHistory();
    }

    public void dropPkt() {
        super.dropPkt();
        this.skipFec = true;
        if (this.q.getFillCount() < this.AJB_SHRINK_THRESHOLD) {
            this.shrinkCount = 0;
        }
    }

    public int getAbsoluteMaximumDelay() {
        long absoluteMaximumDelay;
        if (this.isAdaptive()) {
            long msPerPkt = this.msPerPkt;
            if (msPerPkt <= 0L) {
                msPerPkt = 20L;
            }
            absoluteMaximumDelay = (long)this.AJB_MAX_SIZE * msPerPkt;
        } else {
            absoluteMaximumDelay = super.getAbsoluteMaximumDelay();
        }
        return absoluteMaximumDelay > 65535L ? 65535 : (int)absoluteMaximumDelay;
    }

    public int getMaximumDelay() {
        long maximumDelay;
        long msPerPkt = this.msPerPkt;
        if (msPerPkt <= 0L) {
            msPerPkt = 20L;
        }
        return (maximumDelay = (long)this.q.getCapacity() * msPerPkt) > 65535L ? 65535 : (int)maximumDelay;
    }

    public int getNominalDelay() {
        long nominalDelay;
        long msPerPkt = this.msPerPkt;
        if (msPerPkt <= 0L) {
            msPerPkt = 20L;
        }
        return (nominalDelay = (long)(this.q.getCapacity() / 2) * msPerPkt) > 65535L ? 65535 : (int)nominalDelay;
    }

    protected void grow(int capacity) {
        super.grow(capacity);
        this.resetHistory();
    }

    private void initHistory() {
        this.history = new byte[this.AJB_GROW_INTERVAL];
        this.historyLength = 0;
        this.historyTail = 0;
        this.growCount = 0;
    }

    public boolean isAdaptive() {
        return this.AJB_ENABLED;
    }

    protected int monitorQSize(Buffer buffer) {
        long ms;
        int sizePerPkt;
        BufferControl bc;
        block13: {
            super.monitorQSize(buffer);
            if (this.AJB_ENABLED) {
                int n;
                int size = this.q.getCapacity();
                if (this.historyLength >= this.AJB_GROW_INTERVAL && this.growCount >= this.AJB_GROW_THRESHOLD && size < this.AJB_MAX_SIZE && (n = Math.min(size + this.AJB_GROW_INCREMENT, this.AJB_MAX_SIZE)) > size) {
                    this.grow(n);
                }
                ++this.shrinkCount;
                if (this.shrinkCount >= this.AJB_SHRINK_INTERVAL && size > this.AJB_MIN_SIZE && this.q.freeNotEmpty() && (n = Math.max(size - this.AJB_SHRINK_DECREMENT, this.AJB_MIN_SIZE)) < size) {
                    this.shrink(n);
                }
            }
            if ((bc = this.getBufferControl()) == null) {
                return 0;
            }
            Format format = this.stream.getFormat();
            sizePerPkt = this.stats.getSizePerPacket();
            if (sizePerPkt <= 0) {
                sizePerPkt = 256;
            }
            if (MPEG.matches(format)) {
                ms = sizePerPkt / 4;
            } else {
                ms = 20L;
                try {
                    long ns = buffer.getDuration();
                    if (ns <= 0L) {
                        ns = ((AudioFormat)format).computeDuration(buffer.getLength());
                        if (ns > 0L) {
                            ms = ns / 1000000L;
                        }
                    } else {
                        ms = ns / 1000000L;
                    }
                }
                catch (Throwable t) {
                    if (!(t instanceof ThreadDeath)) break block13;
                    throw (ThreadDeath)t;
                }
            }
        }
        this.msPerPkt = (this.msPerPkt + ms) / 2L;
        ms = this.msPerPkt == 0L ? 20L : this.msPerPkt;
        int aprxBufferLengthInPkts = (int)(bc.getBufferLength() / ms);
        if (!this.AJB_ENABLED && aprxBufferLengthInPkts > this.q.getCapacity()) {
            this.grow(aprxBufferLengthInPkts);
            int size = this.q.getCapacity();
            Log.comment("Grew audio RTP packet queue to: " + size + " pkts, " + size * sizePerPkt + " bytes.\n");
        }
        return aprxBufferLengthInPkts;
    }

    public boolean preAdd(Buffer buffer, RTPRawReceiver rtprawreceiver) {
        long bufferSN;
        long lastSeqSent = this.stream.getLastReadSequenceNumber();
        if (lastSeqSent != 0x7FFFFFFFFFFFFFFEL && (bufferSN = buffer.getSequenceNumber()) < lastSeqSent) {
            if (lastSeqSent - bufferSN < (long)this.AJB_MAX_SIZE) {
                this.recordInHistory(true);
                this.stats.incrementDiscardedLate();
            } else {
                this.stats.incrementDiscardedVeryLate();
            }
            return false;
        }
        this.recordInHistory(false);
        if (!super.preAdd(buffer, rtprawreceiver)) {
            return false;
        }
        if (this.AJB_ENABLED && this.q.noMoreFree() && this.stats.getNbAdd() > 300) {
            int size = this.q.getCapacity();
            if (size < this.AJB_MAX_SIZE) {
                this.grow(Math.min(size * 2, this.AJB_MAX_SIZE));
            } else {
                while (this.q.getFillCount() >= size / 2) {
                    this.stats.incrementDiscardedFull();
                    this.dropPkt();
                }
            }
        }
        return true;
    }

    public void read(Buffer buffer) {
        int totalPkts;
        super.read(buffer);
        if (!buffer.isDiscard() && this.skipFec) {
            buffer.setFlags(buffer.getFlags() | 0x10000);
            this.skipFec = false;
        }
        if ((totalPkts = this.q.getFillCount()) == 0) {
            this.replenish = true;
        }
        if (totalPkts < this.AJB_SHRINK_THRESHOLD) {
            this.shrinkCount = 0;
        }
    }

    private void recordInHistory(boolean late) {
        byte n = late ? (byte)1 : 0;
        this.growCount += n - this.history[this.historyTail];
        this.history[this.historyTail] = n;
        this.historyTail = (this.historyTail + 1) % this.AJB_GROW_INTERVAL;
        if (this.historyLength < this.AJB_GROW_INTERVAL) {
            ++this.historyLength;
        }
    }

    public void reset() {
        super.reset();
        this.resetHistory();
    }

    private void resetHistory() {
        this.historyLength = 0;
        this.shrinkCount = 0;
    }

    private void shrink(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("capacity");
        }
        int qCapacity = this.q.getCapacity();
        if (capacity == qCapacity) {
            return;
        }
        if (capacity > qCapacity) {
            throw new IllegalArgumentException("capacity");
        }
        Log.info("Shrinking packet queue to " + capacity);
        int dropped = 0;
        while (this.q.getFillCount() > capacity) {
            this.dropPkt();
            this.stats.incrementDiscardedShrink();
            ++dropped;
        }
        this.q.setCapacity(capacity);
        while (dropped < this.AJB_SHRINK_DECREMENT && this.q.fillNotEmpty()) {
            this.dropPkt();
            this.stats.incrementDiscardedShrink();
            ++dropped;
        }
        this.resetHistory();
    }

    public boolean willReadBlock() {
        boolean b = super.willReadBlock();
        if (!b) {
            if (this.replenish && this.q.getFillCount() >= this.q.getCapacity() / 2) {
                this.replenish = false;
            }
            b = this.replenish;
        }
        return b;
    }
}

