/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.utilities;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import org.glassfish.hk2.api.DescriptorFileFinder;
import org.glassfish.hk2.api.DescriptorFileFinderInformation;

public class ClasspathDescriptorFileFinder
implements DescriptorFileFinder,
DescriptorFileFinderInformation {
    private static final String DEFAULT_NAME = "default";
    private final ClassLoader classLoader;
    private final String[] names;
    private final ArrayList<String> identifiers = new ArrayList();

    public ClasspathDescriptorFileFinder() {
        this(ClasspathDescriptorFileFinder.class.getClassLoader(), DEFAULT_NAME);
    }

    public ClasspathDescriptorFileFinder(ClassLoader cl) {
        this(cl, DEFAULT_NAME);
    }

    public ClasspathDescriptorFileFinder(ClassLoader cl, String ... names) {
        this.classLoader = cl;
        this.names = names;
    }

    @Override
    public List<InputStream> findDescriptorFiles() throws IOException {
        this.identifiers.clear();
        ArrayList<InputStream> returnList = new ArrayList<InputStream>();
        for (String name : this.names) {
            Enumeration<URL> e = this.classLoader.getResources("META-INF/hk2-locator/" + name);
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                try {
                    this.identifiers.add(url.toURI().toString());
                }
                catch (URISyntaxException e1) {
                    throw new IOException(e1);
                }
                returnList.add(url.openStream());
            }
        }
        return returnList;
    }

    @Override
    public List<String> getDescriptorFileInformation() {
        return this.identifiers;
    }

    public String toString() {
        return "ClasspathDescriptorFileFinder(" + this.classLoader + "," + Arrays.toString(this.names) + "," + System.identityHashCode(this) + ")";
    }
}

