/*
 * Decompiled with CFR 0.152.
 */
package com.ifsoft.websockets.servlet;

import com.ifsoft.websockets.BasicStreamID;
import com.ifsoft.websockets.WSConnection;
import com.ifsoft.websockets.plugin.WebSocketsPlugin;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.DocumentHelper;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.jivesoftware.openfire.Connection;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.SessionPacketRouter;
import org.jivesoftware.openfire.StreamID;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.AuthFactory;
import org.jivesoftware.openfire.auth.AuthToken;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.session.LocalClientSession;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.ParamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public final class XMPPServlet
extends WebSocketServlet {
    private static Logger Log = LoggerFactory.getLogger((String)"XMPPServlet");
    private ConcurrentHashMap<String, XMPPWebSocket> sockets;
    private String remoteAddr;
    private WebSocketsPlugin plugin = (WebSocketsPlugin)XMPPServer.getInstance().getPluginManager().getPlugin("websockets");

    public XMPPServlet() {
        this.sockets = this.plugin.getSockets();
    }

    public void configure(WebSocketServletFactory factory) {
        factory.setCreator((WebSocketCreator)new WSocketCreator());
    }

    @WebSocket
    public class XMPPWebSocket {
        private Session wsSession;
        private WSConnection wsConnection;
        private String digest;
        private LocalClientSession xmppSession;

        public void setWSConnection(String digest, WSConnection wsConnection) {
            this.digest = digest;
            this.wsConnection = wsConnection;
            wsConnection.setSocket(this);
            XMPPServlet.this.sockets.put(digest, this);
            Log.debug(digest + " : setWSConnection");
        }

        public String getDigest() {
            return this.digest;
        }

        public void setSession(LocalClientSession xmppSession) {
            this.xmppSession = xmppSession;
        }

        public LocalClientSession getSession() {
            return this.xmppSession;
        }

        public boolean isOpen() {
            return this.wsSession.isOpen();
        }

        @OnWebSocketConnect
        public void onConnect(Session wsSession) {
            this.wsSession = wsSession;
            this.wsConnection.setSecure(wsSession.isSecure());
            Log.debug(this.digest + " : onConnect");
        }

        @OnWebSocketClose
        public void onClose(int statusCode, String reason) {
            try {
                XMPPServlet.this.sockets.remove(this.digest);
                if (this.xmppSession != null) {
                    this.xmppSession.close();
                }
                this.xmppSession = null;
            }
            catch (Exception e) {
                Log.error("An error occurred while attempting to remove the socket and xmppSession", (Throwable)e);
            }
            Log.debug(this.digest + " : onClose : " + statusCode + " " + reason);
        }

        @OnWebSocketError
        public void onError(Throwable error) {
            Log.error("XMPPWebSocket onError", error);
        }

        @OnWebSocketMessage
        public void onTextMethod(String data) {
            if (!"".equals(data.trim())) {
                try {
                    Log.debug(this.digest + " : onMessage : Received : " + data);
                    this.wsConnection.getRouter().route(DocumentHelper.parseText((String)data).getRootElement());
                }
                catch (Exception e) {
                    Log.error("An error occurred while attempting to route the packet : ", (Throwable)e);
                }
            }
        }

        @OnWebSocketMessage
        public void onBinaryMethod(byte[] data, int offset, int length) {
        }

        public void deliver(String packet) {
            if (this.wsSession != null && this.wsSession.isOpen() && !"".equals(packet.trim())) {
                try {
                    Log.debug(this.digest + " : Delivered : " + packet);
                    this.wsSession.getRemote().sendString(packet);
                }
                catch (Exception e) {
                    Log.error("XMPPWebSocket deliver " + e);
                }
            }
        }

        public void disconnect() {
            Log.debug(this.digest + " : disconnect : XMPPWebSocket disconnect");
            Log.debug("Total websockets created : " + XMPPServlet.this.sockets.size());
            try {
                if (this.wsSession != null && this.wsSession.isOpen()) {
                    this.wsSession.close();
                }
            }
            catch (Exception e) {
                try {
                    this.wsSession.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                XMPPServlet.this.sockets.remove(this.digest);
                SessionManager.getInstance().removeSession(this.xmppSession);
            }
            catch (Exception e) {
                Log.error("An error has occurred", (Throwable)e);
            }
            this.xmppSession = null;
        }
    }

    public class WSocketCreator
    implements WebSocketCreator {
        public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
            for (String subprotocol : req.getSubProtocols()) {
                if (!"xmpp".equals(subprotocol)) continue;
                XMPPWebSocket socket = new XMPPWebSocket();
                if (this.doWebSocketConnect(req.getHttpServletRequest(), socket)) {
                    resp.setAcceptedSubProtocol(subprotocol);
                    return socket;
                }
                return null;
            }
            return null;
        }

        private boolean doWebSocketConnect(HttpServletRequest request, XMPPWebSocket socket) {
            try {
                String username = URLDecoder.decode(ParamUtils.getParameter((HttpServletRequest)request, (String)"username"), "UTF-8");
                String password = URLDecoder.decode(ParamUtils.getParameter((HttpServletRequest)request, (String)"password"), "UTF-8");
                String resource = URLDecoder.decode(ParamUtils.getParameter((HttpServletRequest)request, (String)"resource"), "UTF-8");
                String register = ParamUtils.getParameter((HttpServletRequest)request, (String)"register");
                username = JID.escapeNode((String)username);
                String user = username.equals("null") ? resource : username;
                String digest = this.getMD5(user + password + resource);
                JID userJid = XMPPServer.getInstance().createJID(user, resource);
                Log.debug(digest + " : doWebSocketConnect : Digest created for " + userJid + " : " + register);
                LocalClientSession session = (LocalClientSession)SessionManager.getInstance().getSession(userJid);
                if (session != null) {
                    int conflictLimit = SessionManager.getInstance().getConflictKickLimit();
                    if (conflictLimit == -1) {
                        return false;
                    }
                    int conflictCount = session.incrementConflictCount();
                    if (conflictCount > conflictLimit) {
                        session.close();
                        SessionManager.getInstance().removeSession(session);
                    } else {
                        return false;
                    }
                }
                String remoteAddr = request.getRemoteAddr();
                if (JiveGlobals.getProperty((String)"websockets.header.remoteaddr") != null && request.getHeader(JiveGlobals.getProperty((String)"websockets.header.remoteaddr")) != null) {
                    remoteAddr = request.getHeader(JiveGlobals.getProperty((String)"websockets.header.remoteaddr"));
                }
                try {
                    WSConnection wsConnection = new WSConnection(remoteAddr, request.getRemoteHost());
                    socket.setWSConnection(digest, wsConnection);
                    try {
                        AuthToken authToken;
                        session = SessionManager.getInstance().createClientSession((Connection)wsConnection, (StreamID)new BasicStreamID("url" + System.currentTimeMillis()));
                        wsConnection.setRouter(new SessionPacketRouter(session));
                        if (username.equals("null") && password.equals("null")) {
                            authToken = new AuthToken(resource, Boolean.valueOf(true));
                        } else {
                            try {
                                String userName = JID.unescapeNode((String)username);
                                if (register != null && register.equals("true") && XMPPServer.getInstance().getIQRegisterHandler().isInbandRegEnabled()) {
                                    UserManager userManager = XMPPServer.getInstance().getUserManager();
                                    try {
                                        userManager.getUser(userName);
                                    }
                                    catch (UserNotFoundException e) {
                                        userManager.createUser(userName, password, null, null);
                                    }
                                }
                                authToken = AuthFactory.authenticate((String)userName, (String)password);
                            }
                            catch (UnauthorizedException e) {
                                Log.error("An error occurred while attempting to create a web socket (USERNAME: " + username + " RESOURCE: " + resource + " ) : ", (Throwable)e);
                                return false;
                            }
                            catch (Exception e) {
                                Log.error("An error occurred while attempting to create a web socket : ", (Throwable)e);
                                return false;
                            }
                        }
                        session.setAuthToken(authToken, resource);
                        socket.setSession(session);
                    }
                    catch (Exception e1) {
                        Log.error("An error occurred while attempting to create a new socket " + e1);
                        return false;
                    }
                    Log.debug("Created new socket for digest " + digest);
                    Log.debug("Total websockets created : " + XMPPServlet.this.sockets.size());
                }
                catch (Exception e) {
                    Log.error("An error occurred while attempting to create a new socket " + e);
                    return false;
                }
            }
            catch (Exception e) {
                if (socket.getSession() != null) {
                    SessionManager.getInstance().removeSession(socket.getSession());
                }
                return false;
            }
            return true;
        }

        private String getMD5(String input) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                byte[] messageDigest = md.digest(input.getBytes());
                BigInteger number = new BigInteger(1, messageDigest);
                String hashtext = number.toString(16);
                while (hashtext.length() < 32) {
                    hashtext = "0" + hashtext;
                }
                return hashtext;
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

