/*
 * Decompiled with CFR 0.152.
 */
package com.ifsoft.websockets.servlet;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketsAdmin
extends HttpServlet {
    private static Logger Log = LoggerFactory.getLogger((String)"WebSocketsAdmin");
    private String action = "edit";
    private String webAppName = "ws";
    private String errorMessage = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setHeader("Expires", "Sat, 6 May 1995 12:00:00 GMT");
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Content-Type", "text/html");
        response.setHeader("Connection", "close");
        ServletOutputStream out = response.getOutputStream();
        HashMap<String, String> errors = new HashMap<String, String>();
        this.action = request.getParameter("action");
        if (this.action == null) {
            this.action = "edit";
        }
        if (this.action.equals("edit")) {
            this.webAppName = JiveGlobals.getProperty((String)"websockets.webapp.name", (String)this.webAppName);
            this.displayPage(out, errors.size());
        } else if (this.action.equals("update")) {
            this.webAppName = request.getParameter("webAppName");
            this.validateFields(errors);
            if (errors.isEmpty()) {
                try {
                    JiveGlobals.setProperty((String)"websockets.webapp.name", (String)this.webAppName);
                    Log.info("WebSockets Properties updated");
                }
                catch (Exception e) {
                    Log.error(e.getMessage(), (Throwable)e);
                }
                response.sendRedirect("websockets-properties");
            } else {
                this.displayPage(out, errors.size());
            }
        } else {
            this.displayPage(out, errors.size());
        }
    }

    private void displayPage(ServletOutputStream out, int errorSize) {
        try {
            out.println("");
            out.println("<html>");
            out.println("    <head>");
            out.println("        <title>WebSockets Properties</title>");
            out.println("        <meta name=\"pageID\" content=\"WEBSOCKETS-PROPERTIES\"/>");
            out.println("    </head>");
            out.println("    <body>");
            if (errorSize > 0) {
                out.println("<div class=\"error\">");
                out.println(this.errorMessage);
                out.println("</div>");
            }
            out.println("");
            out.println("Use the form below to edit WebSockets Properties.<br>");
            out.println("</p>");
            out.println("<form action=\"websockets-properties\" method=\"get\">");
            if (this.action.equals("edit")) {
                out.println("<input type='hidden' name='action' value='update'>");
            } else {
                out.println("<input type='hidden' name='action' value='edit'>");
            }
            out.println("");
            out.println("<div class=\"jive-contentBoxHeader\">General</div>");
            out.println("<div class=\"jive-contentBox\">");
            out.println("\t <table>");
            out.println("\t \t<tr><td>Web Application Name</td><td><input size='20' type='text' name='webAppName' value='" + this.webAppName + "'></td>");
            out.println("\t \t\t<td>Name of WebSockets web application.</td></tr>");
            out.println("\t </table>");
            out.println("</div>");
            out.println("");
            out.println("&nbsp;<p/>&nbsp;<p/><input type=\"submit\" value=\"Save Properties\">");
            out.println("</form>");
            out.println("");
            out.println("</body>");
            out.println("</html>");
        }
        catch (Exception e) {
            Log.error("displayPage exception", (Throwable)e);
        }
    }

    private void validateFields(Map<String, String> errors) {
        if (this.webAppName.length() < 1) {
            errors.put("webAppName", "");
            this.errorMessage = "Please specify a web application name";
        }
    }
}

