/*
 * Decompiled with CFR 0.152.
 */
package com.ifsoft.websockets.plugin;

import com.ifsoft.websockets.servlet.XMPPServlet;
import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.container.Plugin;
import org.jivesoftware.openfire.container.PluginManager;
import org.jivesoftware.openfire.http.HttpBindManager;
import org.jivesoftware.openfire.session.LocalClientSession;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketsPlugin
implements Plugin {
    private static Logger Log = LoggerFactory.getLogger((String)"WebSocketsPlugin");
    private static final String NAME = "ws";
    private static final String DESCRIPTION = "WebSockets Plugin for Openfire";
    private PluginManager manager;
    private File pluginDirectory;
    private ConcurrentHashMap<String, XMPPServlet.XMPPWebSocket> sockets = new ConcurrentHashMap();

    public void initializePlugin(PluginManager manager, File pluginDirectory) {
        Log.info("[ws] initialize ws plugin resources");
        String appName = JiveGlobals.getProperty((String)"websockets.webapp.name", (String)NAME);
        try {
            ContextHandlerCollection contexts = HttpBindManager.getInstance().getContexts();
            try {
                Log.info("[ws] initialize ws initialize Websockets " + appName);
                ServletContextHandler context = new ServletContextHandler((HandlerContainer)contexts, "/" + appName, 1);
                context.addServlet(new ServletHolder((Servlet)new XMPPServlet()), "/server");
                WebAppContext context2 = new WebAppContext((HandlerContainer)contexts, pluginDirectory.getPath(), "/websockets");
                context.setWelcomeFiles(new String[]{"index.html"});
            }
            catch (Exception e) {
                Log.error("An error has occurred", (Throwable)e);
            }
        }
        catch (Exception e) {
            Log.error("Error initializing WebSockets Plugin", (Throwable)e);
        }
    }

    public void destroyPlugin() {
        Log.info("[ws] destroy ws plugin resources");
        try {
            for (XMPPServlet.XMPPWebSocket socket : this.sockets.values()) {
                try {
                    LocalClientSession session = socket.getSession();
                    session.close();
                    SessionManager.getInstance().removeSession(session);
                    session = null;
                }
                catch (Exception exception) {}
            }
            this.sockets.clear();
        }
        catch (Exception e) {
            Log.error("[ws] destroyPlugin exception " + e);
        }
    }

    public String getName() {
        return NAME;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public int getCount() {
        return this.sockets.size();
    }

    public ConcurrentHashMap<String, XMPPServlet.XMPPWebSocket> getSockets() {
        return this.sockets;
    }
}

