/*
 * Decompiled with CFR 0.152.
 */
package com.ifsoft.websockets;

import com.ifsoft.websockets.servlet.XMPPServlet;
import java.security.cert.Certificate;
import org.jivesoftware.openfire.SessionPacketRouter;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.net.VirtualConnection;
import org.jivesoftware.openfire.session.LocalClientSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.Packet;

public class WSConnection
extends VirtualConnection {
    private static Logger Log = LoggerFactory.getLogger((String)"WSConnection");
    private SessionPacketRouter router;
    private String remoteAddr;
    private String hostName;
    private LocalClientSession session;
    private XMPPServlet.XMPPWebSocket socket;
    private boolean isSecure = false;

    public WSConnection(String remoteAddr, String hostName) {
        this.remoteAddr = remoteAddr;
        this.hostName = hostName;
    }

    public void setSocket(XMPPServlet.XMPPWebSocket socket) {
        this.socket = socket;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public void setSecure(boolean isSecure) {
        this.isSecure = isSecure;
    }

    public SessionPacketRouter getRouter() {
        return this.router;
    }

    public void setRouter(SessionPacketRouter router) {
        this.router = router;
    }

    public void closeVirtualConnection() {
        Log.debug("WSConnection - close ");
        this.socket.disconnect();
    }

    public byte[] getAddress() {
        return this.remoteAddr.getBytes();
    }

    public String getHostAddress() {
        return this.remoteAddr;
    }

    public String getHostName() {
        return this.hostName != null ? this.hostName : "0.0.0.0";
    }

    public void systemShutdown() {
    }

    public void deliver(Packet packet) throws UnauthorizedException {
        this.deliverRawText(packet.toXML());
    }

    public void deliverRawText(String text) {
        this.socket.deliver(text);
    }

    public Certificate[] getPeerCertificates() {
        return null;
    }
}

