/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.convert;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import uk.ltd.getahead.dwr.ConversionException;
import uk.ltd.getahead.dwr.Converter;
import uk.ltd.getahead.dwr.ConverterManager;
import uk.ltd.getahead.dwr.InboundContext;
import uk.ltd.getahead.dwr.InboundVariable;
import uk.ltd.getahead.dwr.Messages;
import uk.ltd.getahead.dwr.OutboundContext;
import uk.ltd.getahead.dwr.OutboundVariable;
import uk.ltd.getahead.dwr.TypeHintContext;
import uk.ltd.getahead.dwr.compat.BaseV10Converter;
import uk.ltd.getahead.dwr.util.JavascriptUtil;
import uk.ltd.getahead.dwr.util.LocalUtil;

public class MapConverter
extends BaseV10Converter
implements Converter {
    private JavascriptUtil jsutil = new JavascriptUtil();
    private ConverterManager config = null;

    public void setConverterManager(ConverterManager newConfig) {
        this.config = newConfig;
    }

    public Object convertInbound(Class paramType, InboundVariable iv, InboundContext inctx) throws ConversionException {
        String value = iv.getValue();
        if (value.trim().equals("null")) {
            return null;
        }
        if (!value.startsWith("{")) {
            throw new IllegalArgumentException(Messages.getString("MapConverter.MissingOpener", "{"));
        }
        if (!value.endsWith("}")) {
            throw new IllegalArgumentException(Messages.getString("MapConverter.MissingCloser", "{"));
        }
        value = value.substring(1, value.length() - 1);
        try {
            Map map = null;
            map = !paramType.isInterface() && !Modifier.isAbstract(paramType.getModifiers()) ? (Map)paramType.newInstance() : new HashMap();
            TypeHintContext thc = inctx.getCurrentTypeHintContext();
            TypeHintContext keyThc = thc.createChildContext(0);
            Class keyType = this.config.getExtraTypeInfo(keyThc);
            TypeHintContext valThc = thc.createChildContext(1);
            Class valType = this.config.getExtraTypeInfo(valThc);
            inctx.addConverted(iv, paramType, map);
            InboundContext incx = iv.getLookup();
            StringTokenizer st = new StringTokenizer(value, ",");
            int size = st.countTokens();
            int i = 0;
            while (i < size) {
                String token = st.nextToken();
                if (token.trim().length() != 0) {
                    int colonpos = token.indexOf(":");
                    if (colonpos == -1) {
                        throw new ConversionException(Messages.getString("MapConverter.MissingSeparator", ":", token));
                    }
                    String valStr = token.substring(colonpos + 1).trim();
                    String[] splitIv = LocalUtil.splitInbound(valStr);
                    String splitIvValue = splitIv[1];
                    String splitIvType = splitIv[0];
                    InboundVariable valIv = new InboundVariable(incx, null, splitIvType, splitIvValue);
                    Object val = this.config.convertInbound(valType, valIv, inctx, valThc);
                    String keyStr = token.substring(0, colonpos).trim();
                    InboundVariable keyIv = new InboundVariable(incx, null, "string", keyStr);
                    Object key = this.config.convertInbound(keyType, keyIv, inctx, keyThc);
                    map.put(key, val);
                }
                ++i;
            }
            return map;
        }
        catch (ConversionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConversionException(ex);
        }
    }

    public String convertOutbound(Object data, String varname, OutboundContext outctx) throws ConversionException {
        Map map = (Map)data;
        StringBuffer buffer = new StringBuffer();
        buffer.append("var ");
        buffer.append(varname);
        buffer.append("={};");
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String outkey;
            Object key = it.next();
            if (key instanceof String) {
                outkey = String.valueOf('\'') + this.jsutil.escapeJavaScript((String)key) + '\'';
            } else {
                OutboundVariable ovkey = this.config.convertOutbound(key, outctx);
                buffer.append(ovkey.getInitCode());
                outkey = ovkey.getAssignCode();
            }
            Object value = map.get(key);
            OutboundVariable nested = this.config.convertOutbound(value, outctx);
            buffer.append(nested.getInitCode());
            buffer.append(varname);
            buffer.append('[');
            buffer.append(outkey);
            buffer.append("]=");
            buffer.append(nested.getAssignCode());
            buffer.append(';');
        }
        return buffer.toString();
    }
}

