/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.xml;

import com.lowagie.text.Anchor;
import com.lowagie.text.Annotation;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.Chapter;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocListener;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Meta;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Row;
import com.lowagie.text.Section;
import com.lowagie.text.Table;
import com.lowagie.text.TextElementArray;
import com.lowagie.text.html.HtmlTagMap;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.xml.simpleparser.EntitiesToSymbol;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SAXiTextHandler
extends DefaultHandler {
    protected DocListener document;
    protected Stack stack;
    protected int chapters = 0;
    protected Chunk currentChunk = null;
    protected boolean ignore = false;
    protected boolean controlOpenClose = true;
    float topMargin = 36.0f;
    float rightMargin = 36.0f;
    float leftMargin = 36.0f;
    float bottomMargin = 36.0f;
    protected HashMap myTags;
    private BaseFont bf = null;
    static /* synthetic */ Class class$com$lowagie$text$PageSize;

    public SAXiTextHandler(DocListener docListener) {
        this.document = docListener;
        this.stack = new Stack();
    }

    public SAXiTextHandler(DocListener docListener, HtmlTagMap htmlTagMap) {
        this(docListener);
        this.myTags = htmlTagMap;
    }

    public SAXiTextHandler(DocListener docListener, HtmlTagMap htmlTagMap, BaseFont baseFont) {
        this(docListener, htmlTagMap);
        this.bf = baseFont;
    }

    public SAXiTextHandler(DocListener docListener, HashMap hashMap) {
        this(docListener);
        this.myTags = hashMap;
    }

    public void setControlOpenClose(boolean bl) {
        this.controlOpenClose = bl;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        Properties properties = new Properties();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string4 = attributes.getQName(i);
                properties.setProperty(string4, attributes.getValue(i));
            }
        }
        this.handleStartingTags(string3, properties);
    }

    public void handleStartingTags(String string, Properties properties) {
        Object object;
        if (this.ignore || "ignore".equals(string)) {
            this.ignore = true;
            return;
        }
        if (this.currentChunk != null) {
            try {
                object = (TextElementArray)this.stack.pop();
            }
            catch (EmptyStackException emptyStackException) {
                object = this.bf == null ? new Paragraph("", new Font()) : new Paragraph("", new Font(this.bf));
            }
            object.add(this.currentChunk);
            this.stack.push(object);
            this.currentChunk = null;
        }
        if (Chunk.isTag(string)) {
            this.currentChunk = new Chunk(properties);
            if (this.bf != null) {
                this.currentChunk.setFont(new Font(this.bf));
            }
            return;
        }
        if (EntitiesToSymbol.isTag(string)) {
            object = new Font();
            if (this.currentChunk != null) {
                this.handleEndingTags("chunk");
                object = this.currentChunk.font();
            }
            this.currentChunk = EntitiesToSymbol.get(properties.getProperty("id"), (Font)object);
            return;
        }
        if (Phrase.isTag(string)) {
            this.stack.push(new Phrase(properties));
            return;
        }
        if (Anchor.isTag(string)) {
            this.stack.push(new Anchor(properties));
            return;
        }
        if (Paragraph.isTag(string) || Section.isTitle(string)) {
            this.stack.push(new Paragraph(properties));
            return;
        }
        if (List.isTag(string)) {
            this.stack.push(new List(properties));
            return;
        }
        if (ListItem.isTag(string)) {
            this.stack.push(new ListItem(properties));
            return;
        }
        if (Cell.isTag(string)) {
            this.stack.push(new Cell(properties));
            return;
        }
        if (Table.isTag(string)) {
            object = new Table(properties);
            float[] fArray = ((Table)object).getProportionalWidths();
            for (int i = 0; i < fArray.length; ++i) {
                if (fArray[i] != 0.0f) continue;
                fArray[i] = 100.0f / (float)fArray.length;
            }
            try {
                ((Table)object).setWidths(fArray);
            }
            catch (BadElementException badElementException) {
                throw new ExceptionConverter(badElementException);
            }
            this.stack.push(object);
            return;
        }
        if (Section.isTag(string)) {
            Section section;
            object = (Element)this.stack.pop();
            try {
                section = ((Section)object).addSection(properties);
            }
            catch (ClassCastException classCastException) {
                throw new ExceptionConverter(classCastException);
            }
            this.stack.push(object);
            this.stack.push(section);
            return;
        }
        if (Chapter.isTag(string)) {
            object = (String)properties.remove("number");
            this.chapters = object != null ? Integer.parseInt((String)object) : ++this.chapters;
            Chapter chapter = new Chapter(properties, this.chapters);
            this.stack.push(chapter);
            return;
        }
        if (Image.isTag(string)) {
            try {
                object = Image.getInstance(properties);
                try {
                    this.addImage((Image)object);
                    return;
                }
                catch (EmptyStackException emptyStackException) {
                    try {
                        this.document.add((Element)object);
                    }
                    catch (DocumentException documentException) {
                        throw new ExceptionConverter(documentException);
                    }
                    return;
                }
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
        }
        if (Annotation.isTag(string)) {
            object = new Annotation(properties);
            try {
                try {
                    TextElementArray textElementArray = (TextElementArray)this.stack.pop();
                    try {
                        textElementArray.add(object);
                    }
                    catch (Exception exception) {
                        this.document.add((Element)object);
                    }
                    this.stack.push(textElementArray);
                }
                catch (EmptyStackException emptyStackException) {
                    this.document.add((Element)object);
                }
                return;
            }
            catch (DocumentException documentException) {
                throw new ExceptionConverter(documentException);
            }
        }
        if (this.isNewline(string)) {
            try {
                object = (TextElementArray)this.stack.pop();
                object.add(Chunk.NEWLINE);
                this.stack.push(object);
            }
            catch (EmptyStackException emptyStackException) {
                if (this.currentChunk == null) {
                    try {
                        this.document.add(Chunk.NEWLINE);
                    }
                    catch (DocumentException documentException) {
                        throw new ExceptionConverter(documentException);
                    }
                }
                this.currentChunk.append("\n");
            }
            return;
        }
        if (this.isNewpage(string)) {
            try {
                object = (TextElementArray)this.stack.pop();
                Chunk chunk = new Chunk("");
                chunk.setNewPage();
                if (this.bf != null) {
                    chunk.setFont(new Font(this.bf));
                }
                object.add(chunk);
                this.stack.push(object);
            }
            catch (EmptyStackException emptyStackException) {
                this.document.newPage();
            }
            return;
        }
        if (this.isDocumentRoot(string)) {
            Rectangle rectangle = null;
            String string2 = null;
            Iterator<Object> iterator = properties.keySet().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                String string3 = properties.getProperty((String)object);
                try {
                    if ("left".equalsIgnoreCase((String)object)) {
                        this.leftMargin = Float.parseFloat(string3 + "f");
                    }
                    if ("right".equalsIgnoreCase((String)object)) {
                        this.rightMargin = Float.parseFloat(string3 + "f");
                    }
                    if ("top".equalsIgnoreCase((String)object)) {
                        this.topMargin = Float.parseFloat(string3 + "f");
                    }
                    if ("bottom".equalsIgnoreCase((String)object)) {
                        this.bottomMargin = Float.parseFloat(string3 + "f");
                    }
                }
                catch (Exception exception) {
                    throw new ExceptionConverter(exception);
                }
                if ("pagesize".equals(object)) {
                    try {
                        String string4 = string3;
                        Field field = (class$com$lowagie$text$PageSize == null ? SAXiTextHandler.class$("com.lowagie.text.PageSize") : class$com$lowagie$text$PageSize).getField(string4);
                        rectangle = (Rectangle)field.get(null);
                        continue;
                    }
                    catch (Exception exception) {
                        throw new ExceptionConverter(exception);
                    }
                }
                if ("orientation".equals(object)) {
                    try {
                        if (!"landscape".equals(string3)) continue;
                        string2 = "landscape";
                        continue;
                    }
                    catch (Exception exception) {
                        throw new ExceptionConverter(exception);
                    }
                }
                try {
                    this.document.add(new Meta((String)object, string3));
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
            }
            if (rectangle != null) {
                if ("landscape".equals(string2)) {
                    rectangle = rectangle.rotate();
                }
                this.document.setPageSize(rectangle);
            }
            this.document.setMargins(this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin);
            if (this.controlOpenClose) {
                this.document.open();
            }
        }
    }

    protected void addImage(Image image) throws EmptyStackException {
        Object e = this.stack.pop();
        if (e instanceof Chapter || e instanceof Section || e instanceof Cell) {
            ((TextElementArray)e).add(image);
            this.stack.push(e);
            return;
        }
        Stack stack = new Stack();
        while (!(e instanceof Chapter || e instanceof Section || e instanceof Cell)) {
            stack.push(e);
            if (e instanceof Anchor) {
                image.setAnnotation(new Annotation(0.0f, 0.0f, 0.0f, 0.0f, ((Anchor)e).reference()));
            }
            e = this.stack.pop();
        }
        ((TextElementArray)e).add(image);
        this.stack.push(e);
        while (!stack.empty()) {
            this.stack.push(stack.pop());
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.ignore) {
            return;
        }
        String string = new String(cArray, n, n2);
        if (string.trim().length() == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = string.length();
        boolean bl = false;
        block6: for (int i = 0; i < n3; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': {
                    if (bl) continue block6;
                    stringBuffer.append(c);
                    continue block6;
                }
                case '\n': {
                    if (i <= 0) continue block6;
                    bl = true;
                    stringBuffer.append(' ');
                    continue block6;
                }
                case '\r': {
                    continue block6;
                }
                case '\t': {
                    continue block6;
                }
                default: {
                    bl = false;
                    stringBuffer.append(c);
                }
            }
        }
        if (this.currentChunk == null) {
            this.currentChunk = this.bf == null ? new Chunk(stringBuffer.toString()) : new Chunk(stringBuffer.toString(), new Font(this.bf));
        } else {
            this.currentChunk.append(stringBuffer.toString());
        }
    }

    public void setBaseFont(BaseFont baseFont) {
        this.bf = baseFont;
    }

    public void endElement(String string, String string2, String string3) {
        this.handleEndingTags(string3);
    }

    public void handleEndingTags(String string) {
        if ("ignore".equals(string)) {
            this.ignore = false;
            return;
        }
        if (this.ignore) {
            return;
        }
        if (this.isNewpage(string) || Annotation.isTag(string) || Image.isTag(string) || this.isNewline(string)) {
            return;
        }
        try {
            TextElementArray textElementArray;
            Object object;
            if (Section.isTitle(string)) {
                Paragraph paragraph = (Paragraph)this.stack.pop();
                if (this.currentChunk != null) {
                    paragraph.add(this.currentChunk);
                    this.currentChunk = null;
                }
                Section section = (Section)this.stack.pop();
                section.setTitle(paragraph);
                this.stack.push(section);
                return;
            }
            if (this.currentChunk != null) {
                try {
                    object = (TextElementArray)this.stack.pop();
                }
                catch (EmptyStackException emptyStackException) {
                    object = new Paragraph();
                }
                object.add(this.currentChunk);
                this.stack.push(object);
                this.currentChunk = null;
            }
            if (Chunk.isTag(string)) {
                return;
            }
            if (Phrase.isTag(string) || Anchor.isTag(string) || List.isTag(string) || Paragraph.isTag(string)) {
                object = (Element)this.stack.pop();
                try {
                    TextElementArray textElementArray2 = (TextElementArray)this.stack.pop();
                    textElementArray2.add(object);
                    this.stack.push(textElementArray2);
                }
                catch (EmptyStackException emptyStackException) {
                    this.document.add((Element)object);
                }
                return;
            }
            if (ListItem.isTag(string)) {
                object = (ListItem)this.stack.pop();
                textElementArray = (List)this.stack.pop();
                ((List)textElementArray).add(object);
                this.stack.push(textElementArray);
            }
            if (Table.isTag(string)) {
                object = (Table)this.stack.pop();
                try {
                    textElementArray = (TextElementArray)this.stack.pop();
                    textElementArray.add(object);
                    this.stack.push(textElementArray);
                }
                catch (EmptyStackException emptyStackException) {
                    this.document.add((Element)object);
                }
                return;
            }
            if (Row.isTag(string)) {
                Cell cell;
                Object object2;
                object = new ArrayList();
                int n = 0;
                while ((object2 = (Element)this.stack.pop()).type() == 20) {
                    cell = (Cell)object2;
                    n += cell.colspan();
                    ((ArrayList)object).add(cell);
                }
                Table table = (Table)object2;
                if (table.columns() < n) {
                    table.addColumns(n - table.columns());
                }
                Collections.reverse(object);
                float[] fArray = new float[n];
                boolean[] blArray = new boolean[n];
                for (int i = 0; i < n; ++i) {
                    fArray[i] = 0.0f;
                    blArray[i] = true;
                }
                float f = 0.0f;
                int n2 = 0;
                Object object3 = ((ArrayList)object).iterator();
                while (object3.hasNext()) {
                    cell = (Cell)object3.next();
                    object2 = cell.cellWidth();
                    if (object2 == null) {
                        if (cell.colspan() == 1 && fArray[n2] == 0.0f) {
                            try {
                                fArray[n2] = 100.0f / (float)n;
                                f += fArray[n2];
                            }
                            catch (Exception exception) {}
                        } else if (cell.colspan() == 1) {
                            blArray[n2] = false;
                        }
                    } else if (cell.colspan() == 1 && ((String)object2).endsWith("%")) {
                        try {
                            fArray[n2] = Float.parseFloat(((String)object2).substring(0, ((String)object2).length() - 1) + "f");
                            f += fArray[n2];
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    n2 += cell.colspan();
                    table.addCell(cell);
                }
                object3 = table.getProportionalWidths();
                if (((Object)object3).length == n) {
                    int n3;
                    float f2 = 0.0f;
                    for (n3 = 0; n3 < n; ++n3) {
                        if (!blArray[n3] || object3[n3] == 0.0f) continue;
                        f2 += object3[n3];
                        fArray[n3] = (float)object3[n3];
                    }
                    if (100.0 >= (double)f) {
                        for (n3 = 0; n3 < ((Object)object3).length; ++n3) {
                            if (fArray[n3] != 0.0f || object3[n3] == 0.0f) continue;
                            fArray[n3] = (float)(object3[n3] / f2 * (100.0f - f));
                        }
                    }
                    table.setWidths(fArray);
                }
                this.stack.push(table);
            }
            if (Cell.isTag(string)) {
                return;
            }
            if (Section.isTag(string)) {
                this.stack.pop();
                return;
            }
            if (Chapter.isTag(string)) {
                this.document.add((Element)this.stack.pop());
                return;
            }
            if (this.isDocumentRoot(string)) {
                try {
                    while (true) {
                        object = (Element)this.stack.pop();
                        try {
                            TextElementArray textElementArray3 = (TextElementArray)this.stack.pop();
                            textElementArray3.add(object);
                            this.stack.push(textElementArray3);
                        }
                        catch (EmptyStackException emptyStackException) {
                            this.document.add((Element)object);
                        }
                    }
                }
                catch (EmptyStackException emptyStackException) {
                    if (this.controlOpenClose) {
                        this.document.close();
                    }
                    return;
                }
            }
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
    }

    private boolean isNewpage(String string) {
        return "newpage".equals(string);
    }

    private boolean isNewline(String string) {
        return "newline".equals(string);
    }

    protected boolean isDocumentRoot(String string) {
        return "itext".equals(string);
    }
}

